/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.builder.model.TestedTargetVariant;
import com.android.ddmlib.IDevice;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.fd.InstantRunBuilder;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.run.AndroidDeviceSpec;
import com.android.tools.idea.gradle.run.BeforeRunBuilder;
import com.android.tools.idea.gradle.run.DefaultGradleBuilder;
import com.android.tools.idea.gradle.run.GradleEditTaskDialog;
import com.android.tools.idea.gradle.run.GradleModuleTasksProvider;
import com.android.tools.idea.gradle.run.GradleTaskRunner;
import com.android.tools.idea.gradle.run.MakeBeforeRunTask;
import com.android.tools.idea.gradle.run.OutputBuildAction;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.run.AndroidAppRunConfigurationBase;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfigContext;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.PreferGradleMake;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.stats.RunStats;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Ordering;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import icons.AndroidIcons;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeBeforeRunTaskProvider
extends BeforeRunTaskProvider<MakeBeforeRunTask> {
    @NotNull
    public static final Key<MakeBeforeRunTask> ID = Key.create((String)"Android.Gradle.BeforeRunTask");
    private static int DEVICE_SPEC_TIMEOUT_SECONDS = 10;
    public static final String TASK_NAME = "Gradle-aware Make";
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidProjectInfo myAndroidProjectInfo;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final GradleTaskRunnerFactory myTaskRunnerFactory;

    public MakeBeforeRunTaskProvider(@NotNull Project project) {
        if (project == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myAndroidProjectInfo = AndroidProjectInfo.getInstance(project);
        this.myGradleProjectInfo = GradleProjectInfo.getInstance(project);
        this.myTaskRunnerFactory = new GradleTaskRunnerFactory(this.myProject, GradleVersions.getInstance());
    }

    public Key<MakeBeforeRunTask> getId() {
        return ID;
    }

    @Nullable
    public Icon getIcon() {
        return AndroidIcons.Android;
    }

    @Nullable
    public Icon getTaskIcon(MakeBeforeRunTask task) {
        return AndroidIcons.Android;
    }

    public String getName() {
        return TASK_NAME;
    }

    public String getDescription(MakeBeforeRunTask task) {
        String goal = task.getGoal();
        return StringUtil.isEmpty((String)goal) ? TASK_NAME : "gradle " + goal;
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public MakeBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(1);
        }
        if (this.configurationTypeIsSupported(runConfiguration)) {
            MakeBeforeRunTask task = new MakeBeforeRunTask();
            if (this.configurationTypeIsEnabledByDefault(runConfiguration)) {
                task.setEnabled(true);
            }
            return task;
        }
        return null;
    }

    public boolean configurationTypeIsSupported(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(2);
        }
        if (this.myAndroidProjectInfo.isApkProject()) {
            return false;
        }
        return runConfiguration instanceof PreferGradleMake || MakeBeforeRunTaskProvider.isUnitTestConfiguration(runConfiguration);
    }

    public boolean configurationTypeIsEnabledByDefault(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(3);
        }
        return runConfiguration instanceof PreferGradleMake;
    }

    private static boolean isUnitTestConfiguration(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(4);
        }
        return runConfiguration instanceof JUnitConfiguration || runConfiguration.getClass().getSimpleName().equals("TestNGConfiguration");
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull MakeBeforeRunTask task) {
        if (runConfiguration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(5);
        }
        if (task == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(6);
        }
        GradleEditTaskDialog dialog = new GradleEditTaskDialog(this.myProject);
        dialog.setGoal(task.getGoal());
        dialog.setAvailableGoals(this.createAvailableTasks());
        if (!dialog.showAndGet()) {
            task.setInvalid();
            return false;
        }
        task.setGoal(dialog.getGoal());
        return true;
    }

    @NotNull
    private List<String> createAvailableTasks() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ArrayList<String> gradleTasks = new ArrayList<String>();
        for (Module module : moduleManager.getModules()) {
            GradleModuleModel gradleModuleModel;
            GradleFacet facet = GradleFacet.getInstance(module);
            if (facet == null || (gradleModuleModel = facet.getGradleModuleModel()) == null) continue;
            gradleTasks.addAll(gradleModuleModel.getTaskNames());
        }
        ArrayList<String> arrayList = gradleTasks;
        if (arrayList == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull MakeBeforeRunTask task) {
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(8);
        }
        if (task == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(9);
        }
        return task.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeTask(DataContext context, RunConfiguration configuration, ExecutionEnvironment env, MakeBeforeRunTask task) {
        RunStats stats = RunStats.from(env);
        try {
            stats.beginBeforeRunTasks();
            boolean bl = this.doExecuteTask(context, configuration, env, task);
            return bl;
        }
        finally {
            stats.endBeforeRunTasks();
        }
    }

    @Nullable
    private String runGradleSyncIfNeeded() {
        boolean syncNeeded = false;
        boolean forceFullVariantsSync = false;
        final AtomicReference errorMsgRef = new AtomicReference();
        if (AndroidGradleBuildConfiguration.getInstance((Project)this.myProject).SYNC_PROJECT_BEFORE_BUILD && GradleSyncState.getInstance(this.myProject).isSyncNeeded() != ThreeState.NO) {
            syncNeeded = true;
        }
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            NdkModuleModel ndkModel = NdkModuleModel.get(module);
            if (ndkModel == null || ndkModel.getVariants().size() >= ndkModel.getNdkVariantNames().size()) continue;
            syncNeeded = true;
            forceFullVariantsSync = true;
            break;
        }
        if (syncNeeded) {
            GradleSyncInvoker.Request request = GradleSyncInvoker.Request.projectModified();
            request.runInBackground = false;
            request.forceFullVariantsSync = forceFullVariantsSync;
            GradleSyncInvoker.getInstance().requestProjectSync(this.myProject, request, new GradleSyncListener(){

                @Override
                public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (errorMessage == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    errorMsgRef.set(errorMessage);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray[1] = "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider$1";
                    objectArray[2] = "syncFailed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        return (String)errorMsgRef.get();
    }

    private boolean doExecuteTask(DataContext context, RunConfiguration configuration, ExecutionEnvironment env, MakeBeforeRunTask task) {
        List<String> cmdLineArgs;
        if (!this.myAndroidProjectInfo.requiresAndroidModel() || !this.myGradleProjectInfo.isDirectGradleBuildEnabled()) {
            CompileStepBeforeRun regularMake = new CompileStepBeforeRun(this.myProject);
            return regularMake.executeTask(context, configuration, env, new CompileStepBeforeRun.MakeBeforeRunTask());
        }
        String errorMsg = this.runGradleSyncIfNeeded();
        if (errorMsg != null) {
            MakeBeforeRunTaskProvider.getLog().info("Unable to launch 'Gradle-aware Make' task. Project sync failed with message: " + errorMsg);
            return false;
        }
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (configuration instanceof RunConfigurationBase && ((RunConfigurationBase)configuration).excludeCompileBeforeLaunchOption()) {
            return true;
        }
        Module[] modules = MakeBeforeRunTaskProvider.getModules(this.myProject, context, configuration);
        AndroidRunConfigContext runConfigContext = (AndroidRunConfigContext)env.getCopyableUserData(AndroidRunConfigContext.KEY);
        DeviceFutures deviceFutures = runConfigContext == null ? null : runConfigContext.getTargetDevices();
        List<AndroidDevice> targetDevices = deviceFutures == null ? Collections.emptyList() : deviceFutures.getDevices();
        try {
            cmdLineArgs = MakeBeforeRunTaskProvider.getCommonArguments(modules, configuration, targetDevices);
        }
        catch (Exception e) {
            MakeBeforeRunTaskProvider.getLog().warn("Error generating command line arguments for Gradle task", (Throwable)e);
            return false;
        }
        BeforeRunBuilder builder = MakeBeforeRunTaskProvider.createBuilder(env, modules, configuration, runConfigContext, targetDevices, task.getGoal());
        GradleTaskRunner.DefaultGradleTaskRunner runner = this.myTaskRunnerFactory.createTaskRunner(configuration);
        try {
            boolean success = builder.build(runner, cmdLineArgs);
            if (configuration instanceof AndroidRunConfigurationBase) {
                Object model = runner.getModel();
                if (model != null && model instanceof OutputBuildAction.PostBuildProjectModels) {
                    ((AndroidRunConfigurationBase)configuration).setOutputModel(new PostBuildModel((OutputBuildAction.PostBuildProjectModels)model));
                } else {
                    MakeBeforeRunTaskProvider.getLog().info("Couldn't get post build models.");
                }
            }
            MakeBeforeRunTaskProvider.getLog().info("Gradle invocation complete, success = " + success);
            return success;
        }
        catch (InvocationTargetException e) {
            MakeBeforeRunTaskProvider.getLog().info("Unexpected error while launching gradle before run tasks", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            MakeBeforeRunTaskProvider.getLog().info("Interrupted while launching gradle before run tasks");
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(MakeBeforeRunTask.class);
        if (logger == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(10);
        }
        return logger;
    }

    @NotNull
    private static List<String> getCommonArguments(@NotNull Module[] modules, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) throws IOException {
        if (modules == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(11);
        }
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(12);
        }
        if (targetDevices == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(13);
        }
        ArrayList<String> cmdLineArgs = new ArrayList<String>();
        cmdLineArgs.addAll(MakeBeforeRunTaskProvider.getDeviceSpecificArguments(modules, configuration, targetDevices));
        cmdLineArgs.addAll(MakeBeforeRunTaskProvider.getProfilingOptions(configuration, targetDevices));
        ArrayList<String> arrayList = cmdLineArgs;
        if (arrayList == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getDeviceSpecificArguments(@NotNull Module[] modules, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> devices) throws IOException {
        AndroidDeviceSpec deviceSpec;
        if (modules == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(15);
        }
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(16);
        }
        if (devices == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(17);
        }
        if ((deviceSpec = AndroidDeviceSpec.create(devices, MakeBeforeRunTaskProvider.shouldCollectListOfLanguages(modules, configuration, devices), DEVICE_SPEC_TIMEOUT_SECONDS, TimeUnit.SECONDS)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MakeBeforeRunTaskProvider.$$$reportNull$$$0(18);
            }
            return list;
        }
        ArrayList<String> properties = new ArrayList<String>(2);
        if (MakeBeforeRunTaskProvider.useSelectApksFromBundleBuilder(modules, configuration, devices)) {
            File deviceSpecFile = deviceSpec.writeToJsonTempFile();
            properties.add(AndroidGradleSettings.createProjectProperty((String)"android.inject.apkselect.config", (String)deviceSpecFile.getAbsolutePath()));
            if (configuration instanceof AndroidAppRunConfigurationBase && ((AndroidAppRunConfigurationBase)configuration).DEPLOY_AS_INSTANT) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.inject.bundle.extractinstant", (boolean)true));
            }
        } else {
            properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.api", (String)Integer.toString(deviceSpec.getApiLevel())));
            if (deviceSpec.getApiCodeName() != null) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.codename", (String)deviceSpec.getApiCodeName()));
            }
            if (deviceSpec.getBuildDensity() != null) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.density", (String)deviceSpec.getBuildDensity().getResourceValue()));
            }
            if (!deviceSpec.getBuildAbis().isEmpty()) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.abi", (String)Joiner.on((char)',').join(deviceSpec.getBuildAbis())));
            }
            if (configuration instanceof AndroidAppRunConfigurationBase && ((AndroidAppRunConfigurationBase)configuration).DEPLOY_AS_INSTANT) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.deploy.instant-app", (boolean)true));
            }
        }
        ArrayList<String> arrayList = properties;
        if (arrayList == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> getProfilingOptions(@NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> devices) throws IOException {
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(20);
        }
        if (devices == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(21);
        }
        if (!(configuration instanceof AndroidRunConfigurationBase) || devices.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MakeBeforeRunTaskProvider.$$$reportNull$$$0(22);
            }
            return list;
        }
        List versionLists = devices.stream().map(AndroidDevice::getVersion).collect(Collectors.toList());
        AndroidVersion minVersion = (AndroidVersion)Ordering.natural().min(versionLists);
        LinkedList<String> arguments = new LinkedList<String>();
        ProfilerState state = ((AndroidRunConfigurationBase)configuration).getProfilerState();
        if (state.ADVANCED_PROFILING_ENABLED && minVersion.getFeatureLevel() >= 21 && minVersion.getFeatureLevel() < 26) {
            File file = EmbeddedDistributionPaths.getInstance().findEmbeddedProfilerTransform(minVersion);
            arguments.add(AndroidGradleSettings.createProjectProperty((String)"android.advanced.profiling.transforms", (String)file.getAbsolutePath()));
            Properties profilerProperties = state.toProperties();
            File propertiesFile = FileUtil.createTempFile((String)"profiler", (String)".properties");
            propertiesFile.deleteOnExit();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(propertiesFile), Charsets.UTF_8);
            profilerProperties.store(writer, "Android Studio Profiler Gradle Plugin Properties");
            ((Writer)writer).close();
            arguments.add(AndroidGradleSettings.createJvmArg((String)"android.profiler.properties", (String)propertiesFile.getAbsolutePath()));
        }
        LinkedList<String> linkedList = arguments;
        if (linkedList == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(23);
        }
        return linkedList;
    }

    @NotNull
    private static BeforeRunBuilder createBuilder(@NotNull ExecutionEnvironment env, @NotNull Module[] modules, @NotNull RunConfiguration configuration, @Nullable AndroidRunConfigContext runConfigContext, @NotNull List<AndroidDevice> targetDevices, @Nullable String userGoal) {
        if (env == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(24);
        }
        if (modules == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(25);
        }
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(26);
        }
        if (targetDevices == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(27);
        }
        if (modules.length == 0) {
            throw new IllegalStateException("Unable to determine list of modules to build");
        }
        if (!StringUtil.isEmpty((String)userGoal)) {
            ArrayListMultimap tasks = ArrayListMultimap.create();
            ((StreamEx)StreamEx.of((Object[])modules).map(module -> ExternalSystemApiUtil.getExternalRootProjectPath((Module)module)).nonNull().distinct()).map(path -> Paths.get(path, new String[0])).forEach(arg_0 -> MakeBeforeRunTaskProvider.lambda$createBuilder$2((ListMultimap)tasks, userGoal, arg_0));
            DefaultGradleBuilder defaultGradleBuilder = new DefaultGradleBuilder((ListMultimap<Path, String>)tasks, null);
            if (defaultGradleBuilder == null) {
                MakeBeforeRunTaskProvider.$$$reportNull$$$0(28);
            }
            return defaultGradleBuilder;
        }
        GradleModuleTasksProvider gradleTasksProvider = new GradleModuleTasksProvider(modules);
        TestCompileType testCompileType = TestCompileType.get(configuration.getType().getId());
        if (testCompileType == TestCompileType.UNIT_TESTS) {
            BuildMode buildMode = BuildMode.COMPILE_JAVA;
            DefaultGradleBuilder defaultGradleBuilder = new DefaultGradleBuilder(gradleTasksProvider.getUnitTestTasks(buildMode), buildMode);
            if (defaultGradleBuilder == null) {
                MakeBeforeRunTaskProvider.$$$reportNull$$$0(29);
            }
            return defaultGradleBuilder;
        }
        InstantRunContext irContext = (InstantRunContext)env.getCopyableUserData(InstantRunContext.KEY);
        if (targetDevices.isEmpty() || irContext == null) {
            if (MakeBeforeRunTaskProvider.useSelectApksFromBundleBuilder(modules, configuration, targetDevices)) {
                DefaultGradleBuilder defaultGradleBuilder = new DefaultGradleBuilder(gradleTasksProvider.getTasksFor(BuildMode.APK_FROM_BUNDLE, testCompileType), BuildMode.APK_FROM_BUNDLE);
                if (defaultGradleBuilder == null) {
                    MakeBeforeRunTaskProvider.$$$reportNull$$$0(30);
                }
                return defaultGradleBuilder;
            }
            DefaultGradleBuilder defaultGradleBuilder = new DefaultGradleBuilder(gradleTasksProvider.getTasksFor(BuildMode.ASSEMBLE, testCompileType), BuildMode.ASSEMBLE);
            if (defaultGradleBuilder == null) {
                MakeBeforeRunTaskProvider.$$$reportNull$$$0(31);
            }
            return defaultGradleBuilder;
        }
        assert (targetDevices.size() == 1) : "instant run context available, but deploying to > 1 device";
        InstantRunBuilder instantRunBuilder = new InstantRunBuilder(MakeBeforeRunTaskProvider.getLaunchedDevice(targetDevices.get(0)), irContext, runConfigContext, gradleTasksProvider);
        if (instantRunBuilder == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(32);
        }
        return instantRunBuilder;
    }

    private static boolean useSelectApksFromBundleBuilder(@NotNull Module[] modules, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) {
        if (modules == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(33);
        }
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(34);
        }
        if (targetDevices == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(35);
        }
        return Arrays.stream(modules).anyMatch(module -> DynamicAppUtils.useSelectApksFromBundleBuilder(module, configuration, targetDevices));
    }

    private static boolean shouldCollectListOfLanguages(@NotNull Module[] modules, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) {
        if (modules == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(36);
        }
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(37);
        }
        if (targetDevices == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(38);
        }
        return Arrays.stream(modules).allMatch(module -> DynamicAppUtils.shouldCollectListOfLanguages(module, configuration, targetDevices));
    }

    @NotNull
    private static Module[] getModules(@NotNull Project project, @Nullable DataContext context, @Nullable RunConfiguration configuration) {
        if (project == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(39);
        }
        if (configuration instanceof ModuleRunProfile) {
            if (configuration instanceof AndroidJUnitConfiguration) {
                Module[] moduleArray = ((AndroidJUnitConfiguration)configuration).getModulesToCompile();
                if (moduleArray == null) {
                    MakeBeforeRunTaskProvider.$$$reportNull$$$0(40);
                }
                return moduleArray;
            }
            Module[] moduleArray = ((ModuleRunProfile)configuration).getModules();
            if (moduleArray == null) {
                MakeBeforeRunTaskProvider.$$$reportNull$$$0(41);
            }
            return moduleArray;
        }
        Module[] moduleArray = GradleProjects.getModulesToBuildFromSelection(project, context);
        if (moduleArray == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(42);
        }
        return moduleArray;
    }

    @Nullable
    public static IDevice getLaunchedDevice(@NotNull AndroidDevice device) {
        if (device == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(43);
        }
        if (!device.getLaunchedDevice().isDone()) {
            return null;
        }
        try {
            return (IDevice)device.getLaunchedDevice().get(1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException | TimeoutException e) {
            return null;
        }
    }

    private static /* synthetic */ void lambda$createBuilder$2(ListMultimap tasks, String userGoal, Path path) {
        tasks.put((Object)path, (Object)userGoal);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 40: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 40: 
            case 41: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 20: 
            case 26: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 11: 
            case 15: 
            case 25: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 13: 
            case 27: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDevices";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createAvailableTasks";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonArguments";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceSpecificArguments";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingOptions";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "configurationTypeIsSupported";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configurationTypeIsEnabledByDefault";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUnitTestConfiguration";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureTask";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 40: 
            case 41: 
            case 42: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canExecuteTask";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCommonArguments";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceSpecificArguments";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getProfilingOptions";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "useSelectApksFromBundleBuilder";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "shouldCollectListOfLanguages";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getModules";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getLaunchedDevice";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 40: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class GradleTaskRunnerFactory {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GradleVersions myGradleVersions;

        GradleTaskRunnerFactory(@NotNull Project project, @NotNull GradleVersions gradleVersions) {
            if (project == null) {
                GradleTaskRunnerFactory.$$$reportNull$$$0(0);
            }
            if (gradleVersions == null) {
                GradleTaskRunnerFactory.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myGradleVersions = gradleVersions;
        }

        @NotNull
        GradleTaskRunner.DefaultGradleTaskRunner createTaskRunner(@NotNull RunConfiguration configuration) {
            GradleVersion version2;
            if (configuration == null) {
                GradleTaskRunnerFactory.$$$reportNull$$$0(2);
            }
            if (configuration instanceof AndroidRunConfigurationBase && (version2 = this.myGradleVersions.getGradleVersion(this.myProject)) != null && version2.isAtLeast(3, 5, 0)) {
                Module selectedModule = ((JavaRunConfigurationModule)((AndroidRunConfigurationBase)configuration).getConfigurationModule()).getModule();
                GradleTaskRunner.DefaultGradleTaskRunner defaultGradleTaskRunner = GradleTaskRunner.newBuildActionRunner(this.myProject, new OutputBuildAction(GradleTaskRunnerFactory.getConcernedGradlePaths(selectedModule)));
                if (defaultGradleTaskRunner == null) {
                    GradleTaskRunnerFactory.$$$reportNull$$$0(3);
                }
                return defaultGradleTaskRunner;
            }
            GradleTaskRunner.DefaultGradleTaskRunner defaultGradleTaskRunner = GradleTaskRunner.newRunner(this.myProject);
            if (defaultGradleTaskRunner == null) {
                GradleTaskRunnerFactory.$$$reportNull$$$0(4);
            }
            return defaultGradleTaskRunner;
        }

        @NotNull
        private static Collection<String> getConcernedGradlePaths(@Nullable Module module) {
            IdeAndroidProject androidProject;
            if (module == null) {
                Set<String> set = Collections.emptySet();
                if (set == null) {
                    GradleTaskRunnerFactory.$$$reportNull$$$0(5);
                }
                return set;
            }
            HashSet<String> gradlePaths = new HashSet<String>();
            gradlePaths.add(GradleUtil.getGradlePath(module));
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel != null && (androidProject = androidModel.getAndroidProject()).getProjectType() == 2) {
                for (TestedTargetVariant testedVariant : androidModel.getSelectedVariant().getTestedTargetVariants()) {
                    gradlePaths.add(testedVariant.getTargetProjectPath());
                }
            }
            HashSet<String> hashSet = gradlePaths;
            if (hashSet == null) {
                GradleTaskRunnerFactory.$$$reportNull$$$0(6);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleVersions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider$GradleTaskRunnerFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider$GradleTaskRunnerFactory";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTaskRunner";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConcernedGradlePaths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createTaskRunner";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

