/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.upgrade;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.adtui.HtmlLabel;
import com.android.tools.idea.gradle.project.PropertyBasedDoNotAskOption;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.TimeBasedUpgradeReminder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecommendedPluginVersionUpgradeDialog
extends DialogWrapper {
    private static final String SHOW_DO_NOT_ASK_TO_UPGRADE_PLUGIN_PROPERTY_NAME = "show.do.not.ask.upgrade.gradle.plugin";
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleVersion myCurrentPluginVersion;
    @NotNull
    private final TimeBasedUpgradeReminder myUpgradeReminder;
    @NotNull
    private final PropertyBasedDoNotAskOption myDoNotAskOption;
    private JPanel myCenterPanel;
    private JEditorPane myMessagePane;
    private JButton[] myButtons;

    @VisibleForTesting
    RecommendedPluginVersionUpgradeDialog(@NotNull Project project, @NotNull GradleVersion current, @NotNull GradleVersion recommended, @NotNull TimeBasedUpgradeReminder upgradeReminder) {
        if (project == null) {
            RecommendedPluginVersionUpgradeDialog.$$$reportNull$$$0(0);
        }
        if (current == null) {
            RecommendedPluginVersionUpgradeDialog.$$$reportNull$$$0(1);
        }
        if (recommended == null) {
            RecommendedPluginVersionUpgradeDialog.$$$reportNull$$$0(2);
        }
        if (upgradeReminder == null) {
            RecommendedPluginVersionUpgradeDialog.$$$reportNull$$$0(3);
        }
        super(project);
        this.myProject = project;
        this.myCurrentPluginVersion = current;
        this.myUpgradeReminder = upgradeReminder;
        this.$$$setupUI$$$();
        this.setTitle("Android Gradle Plugin Update Recommended");
        this.myDoNotAskOption = new PropertyBasedDoNotAskOption(project, SHOW_DO_NOT_ASK_TO_UPGRADE_PLUGIN_PROPERTY_NAME){

            @Override
            @NotNull
            public String getDoNotShowMessage() {
                if ("Don't remind me again for this project" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "Don't remind me again for this project";
            }

            @Override
            public boolean isToBeShown() {
                return RecommendedPluginVersionUpgradeDialog.this.shouldDisplayDialog();
            }

            @Override
            public void setToBeShown(boolean toBeShown, int exitCode) {
                String valueToSave = "";
                if (!toBeShown) {
                    valueToSave = RecommendedPluginVersionUpgradeDialog.this.myCurrentPluginVersion.toString();
                }
                PropertiesComponent.getInstance((Project)RecommendedPluginVersionUpgradeDialog.this.myProject).setValue(RecommendedPluginVersionUpgradeDialog.SHOW_DO_NOT_ASK_TO_UPGRADE_PLUGIN_PROPERTY_NAME, valueToSave);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/post/upgrade/RecommendedPluginVersionUpgradeDialog$1", "getDoNotShowMessage"));
            }
        };
        this.init();
        HtmlLabel.setUpAsHtmlLabel((JEditorPane)this.myMessagePane);
        String msg = "To take advantage of the latest features, improvements, and security fixes, we strongly recommend that you update the Android Gradle plugin to version " + recommended + " and Gradle to version " + "4.10.1" + ". <a href='http://d.android.com/tools/revisions/gradle-plugin.html'>Release notes</a><br/><br/>Android plugin 3.2.0 and higher now support building the <i>Android App Bundle</i>\u2014a new upload format that defers APK generation and signing to compatible app stores, such as Google Play. With app bundles, you no longer have to build, sign, and manage multiple APKs, and users get smaller, more optimized downloads. <a href='http://d.android.com/r/studio-ui/dynamic-delivery/overview'>Learn more</a>";
        this.myMessagePane.setText(msg);
        this.myMessagePane.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                BrowserUtil.browse((URL)e.getURL());
            }
        });
    }

    @NotNull
    protected JComponent createSouthPanel() {
        Action[] actions2 = this.createActions();
        ArrayList buttons = Lists.newArrayList();
        JPanel panel2 = new JPanel(new BorderLayout());
        if (actions2.length > 0) {
            JPanel buttonsPanel = this.createButtons(actions2, buttons);
            panel2.add((Component)buttonsPanel, "Center");
            this.myButtons = buttons.toArray(new JButton[0]);
        }
        if (this.getStyle() == DialogWrapper.DialogStyle.COMPACT) {
            CustomLineBorder line = new CustomLineBorder(OnePixelDivider.BACKGROUND, 1, 0, 0, 0);
            panel2.setBorder(new CompoundBorder((Border)line, (Border)JBUI.Borders.empty((int)8, (int)12)));
        } else {
            panel2.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            RecommendedPluginVersionUpgradeDialog.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @NotNull
    protected Action[] createActions() {
        if (SystemInfo.isMac) {
            Action[] actionArray = new Action[]{new DoNotAskAction(), new RemindMeTomorrowAction(), this.getOKAction()};
            if (actionArray == null) {
                RecommendedPluginVersionUpgradeDialog.$$$reportNull$$$0(5);
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.getOKAction(), new RemindMeTomorrowAction(), new DoNotAskAction()};
        if (actionArray == null) {
            RecommendedPluginVersionUpgradeDialog.$$$reportNull$$$0(6);
        }
        return actionArray;
    }

    @NotNull
    protected Action getOKAction() {
        Action action2 = super.getOKAction();
        action2.putValue("Name", "Update");
        Action action3 = action2;
        if (action3 == null) {
            RecommendedPluginVersionUpgradeDialog.$$$reportNull$$$0(7);
        }
        return action3;
    }

    public void doCancelAction() {
        this.close(1);
    }

    @NotNull
    private JPanel createButtons(@NotNull Action[] actions2, @NotNull List<JButton> buttons) {
        if (actions2 == null) {
            RecommendedPluginVersionUpgradeDialog.$$$reportNull$$$0(8);
        }
        if (buttons == null) {
            RecommendedPluginVersionUpgradeDialog.$$$reportNull$$$0(9);
        }
        JPanel buttonsPanel = new JPanel(new FlowLayout(4));
        for (Action action2 : actions2) {
            JButton button = this.createJButtonForAction(action2);
            Object value2 = action2.getValue("MnemonicKey");
            if (value2 instanceof Integer) {
                int mnemonic = (Integer)value2;
                button.setMnemonic(mnemonic);
            }
            if (action2.getValue("FocusedAction") != null) {
                this.myPreferredFocusedComponent = button;
            }
            buttons.add(button);
            buttonsPanel.add(button);
        }
        JPanel jPanel = buttonsPanel;
        if (jPanel == null) {
            RecommendedPluginVersionUpgradeDialog.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    public void show() {
        if (this.shouldDisplayDialog()) {
            super.show();
        } else {
            this.doCancelAction();
        }
    }

    private boolean shouldDisplayDialog() {
        String value2 = PropertiesComponent.getInstance((Project)this.myProject).getValue(SHOW_DO_NOT_ASK_TO_UPGRADE_PLUGIN_PROPERTY_NAME, "");
        boolean storedVersionMatching = StringUtil.isNotEmpty((String)value2) && this.myCurrentPluginVersion.compareTo(value2) == 0;
        return !storedVersionMatching;
    }

    protected void dispose() {
        super.dispose();
        if (this.myButtons != null) {
            for (JButton button : this.myButtons) {
                button.setAction(null);
            }
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myCenterPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recommended";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upgradeReminder";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/post/upgrade/RecommendedPluginVersionUpgradeDialog";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buttons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/upgrade/RecommendedPluginVersionUpgradeDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSouthPanel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createButtons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createButtons";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JEditorPane jEditorPane;
        JPanel jPanel;
        this.myCenterPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myMessagePane = jEditorPane = new JEditorPane();
        jPanel.add((Component)jEditorPane, new GridConstraints(0, 0, 1, 1, 1, 1, 6, 6, null, new Dimension(470, 130), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myCenterPanel;
    }

    @VisibleForTesting
    class RemindMeTomorrowAction
    extends DialogWrapper.DialogWrapperAction {
        RemindMeTomorrowAction() {
            super((DialogWrapper)RecommendedPluginVersionUpgradeDialog.this, "Remind me tomorrow");
        }

        protected void doAction(ActionEvent e) {
            RecommendedPluginVersionUpgradeDialog.this.myUpgradeReminder.storeLastUpgradeRecommendation(RecommendedPluginVersionUpgradeDialog.this.myProject);
            RecommendedPluginVersionUpgradeDialog.this.close(1);
        }
    }

    private class DoNotAskAction
    extends DialogWrapper.DialogWrapperAction {
        protected DoNotAskAction() {
            super((DialogWrapper)RecommendedPluginVersionUpgradeDialog.this, RecommendedPluginVersionUpgradeDialog.this.myDoNotAskOption.getDoNotShowMessage());
        }

        protected void doAction(ActionEvent e) {
            RecommendedPluginVersionUpgradeDialog.this.myDoNotAskOption.setToBeShown(false, 1);
            RecommendedPluginVersionUpgradeDialog.this.doCancelAction();
        }
    }

    public static class Factory {
        @NotNull
        public RecommendedPluginVersionUpgradeDialog create(@NotNull Project project, @NotNull GradleVersion current, @NotNull GradleVersion recommended) {
            if (project == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (current == null) {
                Factory.$$$reportNull$$$0(1);
            }
            if (recommended == null) {
                Factory.$$$reportNull$$$0(2);
            }
            RecommendedPluginVersionUpgradeDialog recommendedPluginVersionUpgradeDialog = new RecommendedPluginVersionUpgradeDialog(project, current, recommended, new TimeBasedUpgradeReminder());
            if (recommendedPluginVersionUpgradeDialog == null) {
                Factory.$$$reportNull$$$0(3);
            }
            return recommendedPluginVersionUpgradeDialog;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "current";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recommended";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/post/upgrade/RecommendedPluginVersionUpgradeDialog$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/upgrade/RecommendedPluginVersionUpgradeDialog$Factory";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

