/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.cleanup;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallPlatformHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectCleanupStep;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.startup.ExternalAnnotationsSupport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdksCleanupStep
extends ProjectCleanupStep {
    @NotNull
    private final AndroidSdks myAndroidSdks;

    public SdksCleanupStep() {
        this.myAndroidSdks = AndroidSdks.getInstance();
    }

    public SdksCleanupStep(@NotNull AndroidSdks androidSdks) {
        if (androidSdks == null) {
            SdksCleanupStep.$$$reportNull$$$0(0);
        }
        this.myAndroidSdks = androidSdks;
    }

    @Override
    public void cleanUpProject(@NotNull Project project, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @Nullable com.intellij.openapi.progress.ProgressIndicator indicator) {
        if (project == null) {
            SdksCleanupStep.$$$reportNull$$$0(1);
        }
        if (ideModifiableModelsProvider == null) {
            SdksCleanupStep.$$$reportNull$$$0(2);
        }
        HashSet<Sdk> fixedSdks = new HashSet<Sdk>();
        HashSet<Sdk> invalidSdks = new HashSet<Sdk>();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            this.cleanUpSdk(module, fixedSdks, invalidSdks);
        }
        if (!invalidSdks.isEmpty()) {
            this.reinstallMissingPlatforms(invalidSdks, project);
        }
    }

    @VisibleForTesting
    void cleanUpSdk(@NotNull Module module, @NotNull Set<Sdk> fixedSdks, @NotNull Set<Sdk> invalidSdks) {
        AndroidFacet androidFacet;
        if (module == null) {
            SdksCleanupStep.$$$reportNull$$$0(3);
        }
        if (fixedSdks == null) {
            SdksCleanupStep.$$$reportNull$$$0(4);
        }
        if (invalidSdks == null) {
            SdksCleanupStep.$$$reportNull$$$0(5);
        }
        if ((androidFacet = AndroidFacet.getInstance(module)) == null || ((AndroidFacetConfiguration)androidFacet.getConfiguration()).getModel() == null) {
            return;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk != null && !invalidSdks.contains(sdk) && !fixedSdks.contains(sdk)) {
            AndroidSdkAdditionalData additionalData = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
            if (additionalData != null && sdkData != null) {
                IAndroidTarget target = additionalData.getBuildTarget(sdkData);
                if (target == null) {
                    AndroidSdkHandler sdkHandler = sdkData.getSdkHandler();
                    StudioLoggerProgressIndicator logger = new StudioLoggerProgressIndicator(this.getClass());
                    sdkHandler.getSdkManager((ProgressIndicator)logger).loadSynchronously(0L, (ProgressIndicator)logger, null, null);
                    target = sdkHandler.getAndroidTargetManager((ProgressIndicator)logger).getTargetFromHashString(additionalData.getBuildTargetHashString(), (ProgressIndicator)logger);
                }
                if (target != null) {
                    SdkModificator sdkModificator = null;
                    if (this.isMissingAndroidLibrary(sdk) || this.shouldRemoveAnnotationsJar(sdk)) {
                        sdkModificator = sdk.getSdkModificator();
                        sdkModificator.removeAllRoots();
                        for (OrderRoot orderRoot : this.myAndroidSdks.getLibraryRootsForTarget(target, FilePaths.toSystemDependentPath((String)sdk.getHomePath()), true)) {
                            sdkModificator.addRoot(orderRoot.getFile(), orderRoot.getType());
                        }
                        ExternalAnnotationsSupport.attachJdkAnnotations(sdkModificator);
                    }
                    if (!this.myAndroidSdks.hasValidDocs(sdk, target)) {
                        if (sdkModificator == null) {
                            sdkModificator = sdk.getSdkModificator();
                        }
                        VirtualFile documentationPath = HttpFileSystem.getInstance().findFileByPath("developer.android.com/reference/");
                        sdkModificator.addRoot(documentationPath, JavadocOrderRootType.getInstance());
                    }
                    if (!SdksCleanupStep.hasSources(sdk)) {
                        if (sdkModificator == null) {
                            sdkModificator = sdk.getSdkModificator();
                        }
                        this.myAndroidSdks.findAndSetPlatformSources(target, sdkModificator);
                    }
                    if (sdkModificator != null) {
                        ApplicationManager.getApplication().invokeAndWait(() -> ((SdkModificator)sdkModificator).commitChanges());
                        fixedSdks.add(sdk);
                    }
                }
            }
            if (this.isMissingAndroidLibrary(sdk)) {
                invalidSdks.add(sdk);
            }
        }
    }

    private boolean isMissingAndroidLibrary(@NotNull Sdk sdk) {
        if (sdk == null) {
            SdksCleanupStep.$$$reportNull$$$0(6);
        }
        if (this.myAndroidSdks.isAndroidSdk(sdk)) {
            for (VirtualFile library : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!library.getName().equals("android.jar") || !library.exists()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean shouldRemoveAnnotationsJar(@NotNull Sdk sdk) {
        if (sdk == null) {
            SdksCleanupStep.$$$reportNull$$$0(7);
        }
        if (this.myAndroidSdks.isAndroidSdk(sdk)) {
            IAndroidTarget target;
            AndroidSdkAdditionalData additionalData = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
            boolean needsAnnotationsJar = false;
            if (additionalData != null && sdkData != null && (target = additionalData.getBuildTarget(sdkData)) != null) {
                needsAnnotationsJar = this.myAndroidSdks.needsAnnotationsJarInClasspath(target);
            }
            for (VirtualFile library : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!library.getName().equals("annotations.jar") || !library.exists() || needsAnnotationsJar) continue;
                return true;
            }
        }
        return false;
    }

    private void reinstallMissingPlatforms(@NotNull Set<Sdk> invalidSdks, @NotNull Project project) {
        if (invalidSdks == null) {
            SdksCleanupStep.$$$reportNull$$$0(8);
        }
        if (project == null) {
            SdksCleanupStep.$$$reportNull$$$0(9);
        }
        ArrayList<AndroidVersion> versionsToInstall = new ArrayList<AndroidVersion>();
        ArrayList<String> missingPlatforms = new ArrayList<String>();
        for (Sdk sdk : invalidSdks) {
            String platform;
            AndroidSdkAdditionalData additionalData = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
            if (additionalData == null || (platform = additionalData.getBuildTargetHashString()) == null) continue;
            missingPlatforms.add("'" + platform + "'");
            AndroidVersion version2 = AndroidTargetHash.getPlatformVersion((String)platform);
            if (version2 == null) continue;
            versionsToInstall.add(version2);
        }
        if (!versionsToInstall.isEmpty()) {
            String text = "Missing Android platform(s) detected: " + Joiner.on((String)", ").join(missingPlatforms);
            SyncMessage msg = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, text);
            msg.add(new InstallPlatformHyperlink(versionsToInstall));
            GradleSyncMessages.getInstance(project).report(msg);
        }
    }

    private static boolean hasSources(@NotNull Sdk sdk) {
        String[] urls;
        if (sdk == null) {
            SdksCleanupStep.$$$reportNull$$$0(10);
        }
        return (urls = sdk.getRootProvider().getUrls(OrderRootType.SOURCES)).length > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdks";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModifiableModelsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixedSdks";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidSdks";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/SdksCleanupStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanUpProject";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanUpSdk";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isMissingAndroidLibrary";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRemoveAnnotationsJar";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "reinstallMissingPlatforms";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

