/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.gradle.model.level2.IdeDependencies;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class DependenciesExtractor {
    @NotNull
    public static DependenciesExtractor getInstance() {
        DependenciesExtractor dependenciesExtractor = (DependenciesExtractor)ServiceManager.getService(DependenciesExtractor.class);
        if (dependenciesExtractor == null) {
            DependenciesExtractor.$$$reportNull$$$0(0);
        }
        return dependenciesExtractor;
    }

    @NotNull
    public DependencySet extractFrom(@NotNull IdeVariant variant, @NotNull ModuleFinder moduleFinder) {
        if (variant == null) {
            DependenciesExtractor.$$$reportNull$$$0(1);
        }
        if (moduleFinder == null) {
            DependenciesExtractor.$$$reportNull$$$0(2);
        }
        DependencySet dependencies = new DependencySet();
        for (IdeBaseArtifact testArtifact : variant.getTestArtifacts()) {
            DependenciesExtractor.populate(dependencies, testArtifact, moduleFinder, DependencyScope.TEST);
        }
        IdeAndroidArtifact mainArtifact = variant.getMainArtifact();
        DependenciesExtractor.populate(dependencies, (IdeBaseArtifact)mainArtifact, moduleFinder, DependencyScope.COMPILE);
        DependencySet dependencySet = dependencies;
        if (dependencySet == null) {
            DependenciesExtractor.$$$reportNull$$$0(3);
        }
        return dependencySet;
    }

    @NotNull
    public DependencySet extractFrom(@NotNull IdeBaseArtifact artifact, @NotNull DependencyScope scope, @NotNull ModuleFinder moduleFinder) {
        if (artifact == null) {
            DependenciesExtractor.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            DependenciesExtractor.$$$reportNull$$$0(5);
        }
        if (moduleFinder == null) {
            DependenciesExtractor.$$$reportNull$$$0(6);
        }
        DependencySet dependencies = new DependencySet();
        DependenciesExtractor.populate(dependencies, artifact, moduleFinder, scope);
        DependencySet dependencySet = dependencies;
        if (dependencySet == null) {
            DependenciesExtractor.$$$reportNull$$$0(7);
        }
        return dependencySet;
    }

    private static void populate(@NotNull DependencySet dependencies, @NotNull IdeBaseArtifact artifact, @NotNull ModuleFinder moduleFinder, @NotNull DependencyScope scope) {
        if (dependencies == null) {
            DependenciesExtractor.$$$reportNull$$$0(8);
        }
        if (artifact == null) {
            DependenciesExtractor.$$$reportNull$$$0(9);
        }
        if (moduleFinder == null) {
            DependenciesExtractor.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            DependenciesExtractor.$$$reportNull$$$0(11);
        }
        IdeDependencies artifactDependencies = artifact.getLevel2Dependencies();
        for (Library library : artifactDependencies.getJavaLibraries()) {
            LibraryDependency libraryDependency = new LibraryDependency(library.getArtifact(), library.getArtifactAddress(), scope);
            libraryDependency.addBinaryPath(library.getArtifact());
            dependencies.add(libraryDependency);
        }
        for (Library library : artifactDependencies.getAndroidLibraries()) {
            dependencies.add(DependenciesExtractor.createLibraryDependencyFromAndroidLibrary(library, scope));
        }
        for (Library library : artifactDependencies.getModuleDependencies()) {
            String gradlePath = library.getProjectPath();
            if (!StringUtil.isNotEmpty((String)gradlePath)) continue;
            Module module = null;
            String moduleId = gradlePath;
            String projectFolderPath = library.getBuildId();
            if (StringUtil.isNotEmpty((String)projectFolderPath)) {
                moduleId = Modules.createUniqueModuleId(projectFolderPath, gradlePath);
                module = moduleFinder.findModuleByModuleId(moduleId);
            }
            if (module == null) {
                moduleId = gradlePath;
                module = moduleFinder.findModuleByGradlePath(moduleId);
            }
            ModuleDependency dependency = new ModuleDependency(moduleId, scope, module);
            dependencies.add(dependency);
        }
    }

    @NotNull
    private static LibraryDependency createLibraryDependencyFromAndroidLibrary(@NotNull Library library, @NotNull DependencyScope scope) {
        if (library == null) {
            DependenciesExtractor.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            DependenciesExtractor.$$$reportNull$$$0(13);
        }
        LibraryDependency dependency = new LibraryDependency(library.getArtifact(), library.getArtifactAddress(), scope);
        dependency.addBinaryPath(library.getCompileJarFile());
        dependency.addBinaryPath(library.getResFolder());
        for (String localJar : library.getLocalJars()) {
            dependency.addBinaryPath(localJar);
        }
        LibraryDependency libraryDependency = dependency;
        if (libraryDependency == null) {
            DependenciesExtractor.$$$reportNull$$$0(14);
        }
        return libraryDependency;
    }

    @NotNull
    public static String getDependencyDisplayName(@NotNull Library library) {
        String artifactAddress;
        GradleCoordinate coordinates;
        if (library == null) {
            DependenciesExtractor.$$$reportNull$$$0(15);
        }
        if ((coordinates = GradleCoordinate.parseCoordinateString((String)(artifactAddress = library.getArtifactAddress()))) != null) {
            GradleVersion version2;
            int index;
            String groupSuffix;
            String groupId;
            String name = coordinates.getArtifactId();
            if (name == null) {
                name = "?";
            }
            if (!name.contains("-") && (groupId = coordinates.getGroupId()) != null && !(groupSuffix = groupId.substring((index = groupId.lastIndexOf(46)) + 1)).equals(name)) {
                name = groupSuffix + ":" + name;
            }
            if ((version2 = coordinates.getVersion()) != null && !"unspecified".equals(version2.toString())) {
                name = name + ":" + version2;
            }
            String string = name;
            if (string == null) {
                DependenciesExtractor.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = StringUtil.trimLeading((String)artifactAddress, (char)':');
        if (string == null) {
            DependenciesExtractor.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFinder";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 5: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "extractFrom";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryDependencyFromAndroidLibrary";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractFrom";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "populate";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryDependencyFromAndroidLibrary";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyDisplayName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

