/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.ng.ProjectSetup;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutionCallback;
import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.ModelNotFoundInCacheException;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlyProjectModels;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

class SyncResultHandler {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final GradleProjectInfo myProjectInfo;
    @NotNull
    private final ProjectSetup.Factory myProjectSetupFactory;
    @NotNull
    private final PostSyncProjectSetup myPostSyncProjectSetup;
    @NotNull
    private final CompoundSyncTestManager myCompoundSyncTestManager;

    SyncResultHandler(@NotNull Project project) {
        if (project == null) {
            SyncResultHandler.$$$reportNull$$$0(0);
        }
        this(project, GradleSyncState.getInstance(project), GradleProjectInfo.getInstance(project), new ProjectSetup.Factory(), PostSyncProjectSetup.getInstance(project));
    }

    @VisibleForTesting
    SyncResultHandler(@NotNull Project project, @NotNull GradleSyncState syncState, @NotNull GradleProjectInfo projectInfo, @NotNull ProjectSetup.Factory projectSetupFactory, @NotNull PostSyncProjectSetup postSyncProjectSetup) {
        if (project == null) {
            SyncResultHandler.$$$reportNull$$$0(1);
        }
        if (syncState == null) {
            SyncResultHandler.$$$reportNull$$$0(2);
        }
        if (projectInfo == null) {
            SyncResultHandler.$$$reportNull$$$0(3);
        }
        if (projectSetupFactory == null) {
            SyncResultHandler.$$$reportNull$$$0(4);
        }
        if (postSyncProjectSetup == null) {
            SyncResultHandler.$$$reportNull$$$0(5);
        }
        this.myCompoundSyncTestManager = new CompoundSyncTestManager();
        this.myProject = project;
        this.mySyncState = syncState;
        this.myProjectInfo = projectInfo;
        this.myProjectSetupFactory = projectSetupFactory;
        this.myPostSyncProjectSetup = postSyncProjectSetup;
    }

    void onSyncFinished(@NotNull SyncExecutionCallback callback, @NotNull PostSyncProjectSetup.Request setupRequest, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener) {
        block8: {
            if (callback == null) {
                SyncResultHandler.$$$reportNull$$$0(6);
            }
            if (setupRequest == null) {
                SyncResultHandler.$$$reportNull$$$0(7);
            }
            if (indicator == null) {
                SyncResultHandler.$$$reportNull$$$0(8);
            }
            SyncProjectModels models = callback.getSyncModels();
            ExternalSystemTaskId taskId = callback.getTaskId();
            if (models != null) {
                try {
                    this.setUpProject(models, setupRequest, indicator, syncListener, taskId);
                    Runnable runnable = () -> {
                        boolean isTest = ApplicationManager.getApplication().isUnitTestMode();
                        boolean isImportedProject = this.myProjectInfo.isImportedProject();
                        if (!(!isImportedProject || isTest && GradleProjectImporter.ourSkipSetupFromTest)) {
                            GradleProjects.open(this.myProject);
                        }
                        if (!isTest) {
                            CommandProcessor.getInstance().runUndoTransparentAction(() -> this.myProject.save());
                        }
                        if (isImportedProject) {
                            AndroidGradleProjectComponent projectComponent = AndroidGradleProjectComponent.getInstance(this.myProject);
                            projectComponent.configureGradleProject();
                        }
                    };
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        runnable.run();
                        break block8;
                    }
                    ExternalSystemUtil.invokeLater((Project)this.myProject, (Runnable)runnable);
                }
                catch (Throwable e) {
                    this.notifyAndLogSyncError(SyncResultHandler.nullToUnknownErrorCause(SyncResultHandler.getRootCauseMessage(e)), e, syncListener);
                }
            } else {
                this.notifyAndLogSyncError("Gradle did not return any project models", null, syncListener);
            }
        }
    }

    private void setUpProject(@NotNull SyncProjectModels models, @NotNull PostSyncProjectSetup.Request setupRequest, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener, @Nullable ExternalSystemTaskId taskId) {
        if (models == null) {
            SyncResultHandler.$$$reportNull$$$0(9);
        }
        if (setupRequest == null) {
            SyncResultHandler.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            SyncResultHandler.$$$reportNull$$$0(11);
        }
        try {
            if (syncListener != null) {
                syncListener.setupStarted(this.myProject);
            }
            this.mySyncState.setupStarted();
            ProjectSetup projectSetup = this.myProjectSetupFactory.create(this.myProject);
            projectSetup.setUpProject(models, indicator);
            projectSetup.commit();
            SyncIssuesReporter.getInstance().report(ModuleManager.getInstance((Project)this.myProject).getModules());
            ExternalSystemUtil.scheduleExternalViewStructureUpdate((Project)this.myProject, (ProjectSystemId)GradleConstants.SYSTEM_ID);
            if (syncListener != null) {
                syncListener.syncSucceeded(this.myProject);
            }
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> this.myPostSyncProjectSetup.setUpProject(setupRequest, indicator, taskId));
        }
        catch (Throwable e) {
            this.notifyAndLogSyncError(SyncResultHandler.nullToUnknownErrorCause(SyncResultHandler.getRootCauseMessage(e)), e, syncListener);
        }
    }

    void onSyncSkipped(@NotNull CachedProjectModels projectModelsCache, @NotNull PostSyncProjectSetup.Request setupRequest, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener, @Nullable ExternalSystemTaskId taskId) throws ModelNotFoundInCacheException {
        if (projectModelsCache == null) {
            SyncResultHandler.$$$reportNull$$$0(12);
        }
        if (setupRequest == null) {
            SyncResultHandler.$$$reportNull$$$0(13);
        }
        if (indicator == null) {
            SyncResultHandler.$$$reportNull$$$0(14);
        }
        if (syncListener != null) {
            syncListener.setupStarted(this.myProject);
        }
        this.mySyncState.setupStarted();
        ProjectSetup projectSetup = this.myProjectSetupFactory.create(this.myProject);
        projectSetup.setUpProject(projectModelsCache, indicator);
        projectSetup.commit();
        SyncIssuesReporter.getInstance().report(ModuleManager.getInstance((Project)this.myProject).getModules());
        if (syncListener != null) {
            syncListener.syncSkipped(this.myProject);
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> this.myPostSyncProjectSetup.setUpProject(setupRequest, indicator, taskId));
    }

    void onSyncFailed(@NotNull SyncExecutionCallback callback, @Nullable GradleSyncListener syncListener) {
        Throwable error;
        if (callback == null) {
            SyncResultHandler.$$$reportNull$$$0(15);
        }
        String errorMessage = (error = callback.getSyncError()) != null ? SyncResultHandler.getRootCauseMessage(error) : callback.getError();
        errorMessage = SyncResultHandler.nullToUnknownErrorCause(errorMessage);
        this.notifyAndLogSyncError(errorMessage, error, syncListener);
    }

    private void notifyAndLogSyncError(@NotNull String errorMessage, @Nullable Throwable error, @Nullable GradleSyncListener syncListener) {
        if (errorMessage == null) {
            SyncResultHandler.$$$reportNull$$$0(16);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && error != null) {
            System.out.println("***** sync error: " + error.getMessage());
            error.printStackTrace();
        }
        if (syncListener != null) {
            syncListener.syncFailed(this.myProject, errorMessage);
        }
        this.mySyncState.syncFailed(errorMessage);
        if (error != null) {
            SyncResultHandler.getLog().warn("Gradle sync failed", error);
        } else {
            SyncResultHandler.logSyncFailure(errorMessage);
        }
    }

    @Nullable
    private static String getRootCauseMessage(@NotNull Throwable error) {
        Throwable rootCause;
        String message;
        if (error == null) {
            SyncResultHandler.$$$reportNull$$$0(17);
        }
        return StringUtil.isEmpty((String)(message = (rootCause = ExceptionUtil.getRootCause((Throwable)error)).getMessage())) ? rootCause.getClass().getName() : message;
    }

    @NotNull
    private static String nullToUnknownErrorCause(@Nullable String errorMessage) {
        String string = StringUtil.isEmpty((String)errorMessage) ? "<Unknown cause>" : errorMessage;
        if (string == null) {
            SyncResultHandler.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static void logSyncFailure(@NotNull String errorMessage) {
        if (errorMessage == null) {
            SyncResultHandler.$$$reportNull$$$0(19);
        }
        SyncResultHandler.getLog().warn("Gradle sync failed: " + errorMessage);
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(SyncResultHandler.class);
        if (logger == null) {
            SyncResultHandler.$$$reportNull$$$0(20);
        }
        return logger;
    }

    void onVariantOnlySyncFinished(@NotNull SyncExecutionCallback callback, @NotNull PostSyncProjectSetup.Request setupRequest, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener) {
        if (callback == null) {
            SyncResultHandler.$$$reportNull$$$0(21);
        }
        if (setupRequest == null) {
            SyncResultHandler.$$$reportNull$$$0(22);
        }
        if (indicator == null) {
            SyncResultHandler.$$$reportNull$$$0(23);
        }
        VariantOnlyProjectModels models = callback.getVariantOnlyModels();
        ExternalSystemTaskId taskId = callback.getTaskId();
        if (models != null) {
            try {
                this.mySyncState.setupStarted();
                ProjectSetup projectSetup = this.myProjectSetupFactory.create(this.myProject);
                projectSetup.setUpProject(models, indicator);
                projectSetup.commit();
                SyncIssuesReporter.getInstance().report(ModuleManager.getInstance((Project)this.myProject).getModules());
                if (syncListener != null) {
                    syncListener.syncSucceeded(this.myProject);
                }
                StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> this.myPostSyncProjectSetup.setUpProject(setupRequest, indicator, taskId));
            }
            catch (Throwable e) {
                this.notifyAndLogSyncError(SyncResultHandler.nullToUnknownErrorCause(SyncResultHandler.getRootCauseMessage(e)), e, syncListener);
            }
        } else {
            this.notifyAndLogSyncError("Gradle did not return any project models", null, syncListener);
        }
    }

    void onCompoundSyncModels(@NotNull SyncExecutionCallback callback, @NotNull PostSyncProjectSetup.Request setupRequest, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener, boolean variantOnlySync) {
        Runnable runnable;
        SyncProjectModels models;
        if (callback == null) {
            SyncResultHandler.$$$reportNull$$$0(24);
        }
        if (setupRequest == null) {
            SyncResultHandler.$$$reportNull$$$0(25);
        }
        if (indicator == null) {
            SyncResultHandler.$$$reportNull$$$0(26);
        }
        if ((models = callback.getSyncModels()) != null && SyncResultHandler.isCompoundSyncSupported(models)) {
            setupRequest.generateSourcesAfterSync = false;
        }
        Runnable runnable2 = runnable = variantOnlySync ? () -> this.onVariantOnlySyncFinished(callback, setupRequest, indicator, syncListener) : () -> this.onSyncFinished(callback, setupRequest, indicator, syncListener);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myCompoundSyncTestManager.myModelsCallback.set(runnable);
            this.myCompoundSyncTestManager.myLatch.countDown();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(runnable);
        }
    }

    void onCompoundSyncFinished(@Nullable GradleSyncListener syncListener) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                if (!this.myCompoundSyncTestManager.myLatch.await(1L, TimeUnit.MINUTES)) {
                    throw new RuntimeException("Waiting for Project Setup in Compound Sync timed out");
                }
            }
            catch (InterruptedException e) {
                this.myCompoundSyncTestManager.reset();
                throw new RuntimeException(e);
            }
            ((Runnable)this.myCompoundSyncTestManager.myModelsCallback.get()).run();
            this.myCompoundSyncTestManager.reset();
        }
        LocalFileSystem.getInstance().refresh(true);
        if (syncListener != null) {
            syncListener.sourceGenerationFinished(this.myProject);
        }
        this.mySyncState.sourceGenerationFinished();
    }

    private static boolean isCompoundSyncSupported(@NotNull SyncProjectModels projectModels) {
        if (projectModels == null) {
            SyncResultHandler.$$$reportNull$$$0(27);
        }
        for (SyncModuleModels moduleModels : projectModels.getModuleModels()) {
            GradleVersion pluginVersion;
            AndroidProject androidProject = moduleModels.findModel(AndroidProject.class);
            if (androidProject == null || (pluginVersion = GradleVersion.tryParseAndroidGradlePluginVersion((String)androidProject.getModelVersion())) != null && pluginVersion.isAtLeastIncludingPreviews(3, 3, 0)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSetupFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postSyncProjectSetup";
                break;
            }
            case 6: 
            case 15: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupRequest";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModelsCache";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/SyncResultHandler";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/SyncResultHandler";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "nullToUnknownErrorCause";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onSyncFinished";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setUpProject";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onSyncSkipped";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "onSyncFailed";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "notifyAndLogSyncError";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRootCauseMessage";
                break;
            }
            case 18: 
            case 20: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "logSyncFailure";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "onVariantOnlySyncFinished";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "onCompoundSyncModels";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isCompoundSyncSupported";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompoundSyncTestManager {
        @NotNull
        private AtomicReference<Runnable> myModelsCallback = new AtomicReference();
        @NotNull
        private CountDownLatch myLatch = new CountDownLatch(1);

        private CompoundSyncTestManager() {
        }

        private void reset() {
            this.myModelsCallback.set(null);
            this.myLatch = new CountDownLatch(1);
        }
    }
}

