/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.level2.GlobalLibraryMap;
import com.android.java.model.GradlePluginModel;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSyncNotSupportedException;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariantChooser;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariants;
import com.android.tools.idea.gradle.project.sync.ng.SyncActionOptions;
import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncProjectModels
implements Serializable {
    private static final long serialVersionUID = 4L;
    @NotNull
    private final Set<Class<?>> myExtraAndroidModelTypes;
    @NotNull
    private final Set<Class<?>> myExtraJavaModelTypes;
    @NotNull
    private final SyncActionOptions myOptions;
    @NotNull
    private final SelectedVariantChooser myVariantChooser;
    @NotNull
    private final List<SyncModuleModels> myModuleModels;
    @NotNull
    private final List<GlobalLibraryMap> myGlobalLibraryMaps;
    private BuildIdentifier myRootBuildId;
    private String myProjectName;

    public SyncProjectModels(@NotNull Set<Class<?>> extraAndroidModelTypes, @NotNull Set<Class<?>> extraJavaModelTypes, @NotNull SyncActionOptions options) {
        if (extraAndroidModelTypes == null) {
            SyncProjectModels.$$$reportNull$$$0(0);
        }
        if (extraJavaModelTypes == null) {
            SyncProjectModels.$$$reportNull$$$0(1);
        }
        if (options == null) {
            SyncProjectModels.$$$reportNull$$$0(2);
        }
        this(extraAndroidModelTypes, extraJavaModelTypes, options, new SelectedVariantChooser());
    }

    @VisibleForTesting
    SyncProjectModels(@NotNull Set<Class<?>> extraAndroidModelTypes, @NotNull Set<Class<?>> extraJavaModelTypes, @NotNull SyncActionOptions options, @NotNull SelectedVariantChooser variantChooser) {
        if (extraAndroidModelTypes == null) {
            SyncProjectModels.$$$reportNull$$$0(3);
        }
        if (extraJavaModelTypes == null) {
            SyncProjectModels.$$$reportNull$$$0(4);
        }
        if (options == null) {
            SyncProjectModels.$$$reportNull$$$0(5);
        }
        if (variantChooser == null) {
            SyncProjectModels.$$$reportNull$$$0(6);
        }
        this.myModuleModels = new ArrayList<SyncModuleModels>();
        this.myGlobalLibraryMaps = new ArrayList<GlobalLibraryMap>();
        this.myExtraAndroidModelTypes = extraAndroidModelTypes;
        this.myExtraJavaModelTypes = extraJavaModelTypes;
        this.myOptions = options;
        this.myVariantChooser = variantChooser;
    }

    public void populate(@NotNull BuildController controller) {
        GradleProject gradleProject;
        if (controller == null) {
            SyncProjectModels.$$$reportNull$$$0(7);
        }
        GradleBuild rootBuild = controller.getBuildModel();
        this.myRootBuildId = rootBuild.getBuildIdentifier();
        this.myProjectName = rootBuild.getRootProject().getName();
        ArrayList<GradleBuild> gradleBuilds = new ArrayList<GradleBuild>();
        gradleBuilds.add(rootBuild);
        gradleBuilds.addAll((Collection<GradleBuild>)rootBuild.getIncludedBuilds());
        for (GradleBuild gradleBuild : gradleBuilds) {
            gradleProject = (GradleProject)controller.findModel((Model)gradleBuild.getRootProject(), GradleProject.class);
            SyncProjectModels.failIfKotlinPluginApplied(controller, gradleProject);
        }
        for (GradleBuild gradleBuild : gradleBuilds) {
            gradleProject = (GradleProject)controller.findModel((Model)gradleBuild.getRootProject(), GradleProject.class);
            this.populateModelsForModule(gradleProject, controller, gradleBuild.getBuildIdentifier());
        }
        if (this.myOptions.isSingleVariantSyncEnabled()) {
            SelectedVariants variants = this.myOptions.getSelectedVariants();
            Objects.requireNonNull(variants);
            this.myVariantChooser.chooseSelectedVariants(this.myModuleModels, controller, variants, this.myOptions.shouldGenerateSources());
        }
        this.populateGlobalLibraryMap(controller);
    }

    private static void failIfKotlinPluginApplied(@NotNull BuildController controller, @Nullable GradleProject gradleProject) {
        if (controller == null) {
            SyncProjectModels.$$$reportNull$$$0(8);
        }
        if (gradleProject != null) {
            GradlePluginModel pluginModel = (GradlePluginModel)controller.findModel((Model)gradleProject, GradlePluginModel.class);
            if (pluginModel != null && pluginModel.getGraldePluginList().stream().anyMatch(p -> p.startsWith("org.jetbrains.kotlin"))) {
                throw new NewGradleSyncNotSupportedException("containing Kotlin modules");
            }
            for (GradleProject child : gradleProject.getChildren()) {
                SyncProjectModels.failIfKotlinPluginApplied(controller, child);
            }
        }
    }

    private void populateModelsForModule(@Nullable GradleProject project, @NotNull BuildController controller, @NotNull BuildIdentifier buildId2) {
        if (controller == null) {
            SyncProjectModels.$$$reportNull$$$0(9);
        }
        if (buildId2 == null) {
            SyncProjectModels.$$$reportNull$$$0(10);
        }
        if (project == null) {
            return;
        }
        SyncModuleModels models = new SyncModuleModels(project, buildId2, this.myExtraAndroidModelTypes, this.myExtraJavaModelTypes, this.myOptions);
        models.populate(project, controller);
        this.myModuleModels.add(models);
        for (GradleProject child : project.getChildren()) {
            this.populateModelsForModule(child, controller, buildId2);
        }
    }

    private void populateGlobalLibraryMap(@NotNull BuildController controller) {
        if (controller == null) {
            SyncProjectModels.$$$reportNull$$$0(11);
        }
        HashSet<BuildIdentifier> visitedBuildId = new HashSet<BuildIdentifier>();
        for (SyncModuleModels moduleModels : this.myModuleModels) {
            GlobalLibraryMap map2;
            AndroidProject androidProject = moduleModels.findModel(AndroidProject.class);
            BuildIdentifier buildId2 = moduleModels.getBuildId();
            if (androidProject == null || visitedBuildId.contains(buildId2) || (map2 = (GlobalLibraryMap)controller.findModel((Model)moduleModels.findModel(GradleProject.class), GlobalLibraryMap.class)) == null) continue;
            visitedBuildId.add(buildId2);
            this.myGlobalLibraryMaps.add(map2);
        }
    }

    @NotNull
    public List<SyncModuleModels> getModuleModels() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myModuleModels);
        if (immutableList == null) {
            SyncProjectModels.$$$reportNull$$$0(12);
        }
        return immutableList;
    }

    @NotNull
    public List<GlobalLibraryMap> getGlobalLibraryMap() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myGlobalLibraryMaps);
        if (immutableList == null) {
            SyncProjectModels.$$$reportNull$$$0(13);
        }
        return immutableList;
    }

    @NotNull
    public BuildIdentifier getRootBuildId() {
        BuildIdentifier buildIdentifier = this.myRootBuildId;
        if (buildIdentifier == null) {
            SyncProjectModels.$$$reportNull$$$0(14);
        }
        return buildIdentifier;
    }

    @NotNull
    public String getProjectName() {
        String string = this.myProjectName;
        if (string == null) {
            SyncProjectModels.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraAndroidModelTypes";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraJavaModelTypes";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantChooser";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildId";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/SyncProjectModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/SyncProjectModels";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleModels";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalLibraryMap";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootBuildId";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "populate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "failIfKotlinPluginApplied";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "populateModelsForModule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "populateGlobalLibraryMap";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory
    implements Serializable {
        @NotNull
        public SyncProjectModels create(@NotNull Set<Class<?>> extraAndroidModelTypes, @NotNull Set<Class<?>> extraJavaModelTypes, @NotNull SyncActionOptions options) {
            if (extraAndroidModelTypes == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (extraJavaModelTypes == null) {
                Factory.$$$reportNull$$$0(1);
            }
            if (options == null) {
                Factory.$$$reportNull$$$0(2);
            }
            SyncProjectModels syncProjectModels = new SyncProjectModels(extraAndroidModelTypes, extraJavaModelTypes, options);
            if (syncProjectModels == null) {
                Factory.$$$reportNull$$$0(3);
            }
            return syncProjectModels;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extraAndroidModelTypes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extraJavaModelTypes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/SyncProjectModels$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/SyncProjectModels$Factory";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

