/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.Projects;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.build.output.AndroidGradleSyncTextConsoleView;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.SimulatedSyncErrors;
import com.android.tools.idea.gradle.project.sync.common.CommandLineArgs;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandlerManager;
import com.android.tools.idea.gradle.project.sync.idea.IdeaGradleSync;
import com.android.tools.idea.gradle.project.sync.ng.ExtraGradleSyncModelsManager;
import com.android.tools.idea.gradle.project.sync.ng.GradleSyncProgress;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSync;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSyncNotSupportedException;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariantCollector;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariants;
import com.android.tools.idea.gradle.project.sync.ng.SyncAction;
import com.android.tools.idea.gradle.project.sync.ng.SyncActionOptions;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutionCallback;
import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlyProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlySyncAction;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlySyncOptions;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildEventDispatcher;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemEventDispatcher;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import java.util.Collections;
import java.util.List;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.UnsupportedVersionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

class SyncExecutor {
    @NotNull
    private final Project myProject;
    @NotNull
    private final CommandLineArgs myCommandLineArgs;
    @NotNull
    private final SyncErrorHandlerManager myErrorHandlerManager;
    @NotNull
    private final ExtraGradleSyncModelsManager myExtraModelsManager;
    @NotNull
    private final SelectedVariantCollector mySelectedVariantCollector;
    @NotNull
    private final GradleExecutionHelper myHelper;

    SyncExecutor(@NotNull Project project) {
        if (project == null) {
            SyncExecutor.$$$reportNull$$$0(0);
        }
        this(project, ExtraGradleSyncModelsManager.getInstance(), new CommandLineArgs(true), new SyncErrorHandlerManager(project), new SelectedVariantCollector(project));
    }

    @VisibleForTesting
    SyncExecutor(@NotNull Project project, @NotNull ExtraGradleSyncModelsManager extraModelsManager, @NotNull CommandLineArgs commandLineArgs, @NotNull SyncErrorHandlerManager errorHandlerManager, @NotNull SelectedVariantCollector selectedVariantCollector) {
        if (project == null) {
            SyncExecutor.$$$reportNull$$$0(1);
        }
        if (extraModelsManager == null) {
            SyncExecutor.$$$reportNull$$$0(2);
        }
        if (commandLineArgs == null) {
            SyncExecutor.$$$reportNull$$$0(3);
        }
        if (errorHandlerManager == null) {
            SyncExecutor.$$$reportNull$$$0(4);
        }
        if (selectedVariantCollector == null) {
            SyncExecutor.$$$reportNull$$$0(5);
        }
        this.myHelper = new GradleExecutionHelper();
        this.myProject = project;
        this.myCommandLineArgs = commandLineArgs;
        this.myErrorHandlerManager = errorHandlerManager;
        this.myExtraModelsManager = extraModelsManager;
        this.mySelectedVariantCollector = selectedVariantCollector;
    }

    @NotNull
    List<SyncModuleModels> fetchGradleModels(ProgressIndicator indicator) {
        GradleExecutionSettings executionSettings = this.findGradleExecutionSettings();
        Function syncFunction = connection -> this.doFetchModels((ProjectConnection)connection, executionSettings, indicator, SyncExecutor.createId(this.myProject), null, true);
        SyncProjectModels models = (SyncProjectModels)this.myHelper.execute(Projects.getBaseDirPath((Project)this.myProject).getPath(), executionSettings, syncFunction);
        List<SyncModuleModels> list = models.getModuleModels();
        if (list == null) {
            SyncExecutor.$$$reportNull$$$0(6);
        }
        return list;
    }

    void syncProject(@NotNull ProgressIndicator indicator, @NotNull SyncExecutionCallback callback) {
        if (indicator == null) {
            SyncExecutor.$$$reportNull$$$0(7);
        }
        if (callback == null) {
            SyncExecutor.$$$reportNull$$$0(8);
        }
        this.syncProject(indicator, callback, null, null, null, false);
    }

    void syncProject(@NotNull ProgressIndicator indicator, @NotNull SyncExecutionCallback callback, @NotNull VariantOnlySyncOptions options) {
        if (indicator == null) {
            SyncExecutor.$$$reportNull$$$0(9);
        }
        if (callback == null) {
            SyncExecutor.$$$reportNull$$$0(10);
        }
        if (options == null) {
            SyncExecutor.$$$reportNull$$$0(11);
        }
        this.syncProject(indicator, callback, options, null, null, options.myShouldGenerateSources);
    }

    void syncProject(@NotNull ProgressIndicator indicator, @NotNull SyncExecutionCallback callback, @Nullable VariantOnlySyncOptions options, @Nullable GradleSyncListener listener2, @Nullable GradleSyncInvoker.Request request, boolean shouldGenerateSources) {
        if (indicator == null) {
            SyncExecutor.$$$reportNull$$$0(12);
        }
        if (callback == null) {
            SyncExecutor.$$$reportNull$$$0(13);
        }
        if (this.myProject.isDisposed()) {
            callback.reject(String.format("Project '%1$s' is already disposed", this.myProject.getName()));
        }
        IdeaGradleSync.createGradleProjectSettingsIfNotExist(this.myProject);
        GradleExecutionSettings executionSettings = this.findGradleExecutionSettings();
        Function syncFunction = connection -> {
            this.syncProject((ProjectConnection)connection, executionSettings, indicator, callback, options, listener2, request, shouldGenerateSources);
            return null;
        };
        try {
            this.myHelper.execute(Projects.getBaseDirPath((Project)this.myProject).getPath(), executionSettings, syncFunction);
        }
        catch (Throwable e) {
            callback.setRejected(e);
        }
    }

    @NotNull
    private GradleExecutionSettings findGradleExecutionSettings() {
        GradleExecutionSettings executionSettings = GradleUtil.getOrCreateGradleExecutionSettings(this.myProject);
        executionSettings.withArguments(this.myCommandLineArgs.get(this.myProject)).withVmOptions(Collections.emptyList());
        GradleExecutionSettings gradleExecutionSettings = executionSettings;
        if (gradleExecutionSettings == null) {
            SyncExecutor.$$$reportNull$$$0(14);
        }
        return gradleExecutionSettings;
    }

    private void syncProject(@NotNull ProjectConnection connection, @NotNull GradleExecutionSettings executionSettings, @NotNull ProgressIndicator indicator, @NotNull SyncExecutionCallback callback, @Nullable VariantOnlySyncOptions options, @Nullable GradleSyncListener listener2, @Nullable GradleSyncInvoker.Request request, boolean shouldGenerateSources) {
        block24: {
            if (connection == null) {
                SyncExecutor.$$$reportNull$$$0(15);
            }
            if (executionSettings == null) {
                SyncExecutor.$$$reportNull$$$0(16);
            }
            if (indicator == null) {
                SyncExecutor.$$$reportNull$$$0(17);
            }
            if (callback == null) {
                SyncExecutor.$$$reportNull$$$0(18);
            }
            ExternalSystemTaskId id = SyncExecutor.createId(this.myProject);
            SyncViewManager syncViewManager = (SyncViewManager)ServiceManager.getService((Project)this.myProject, SyncViewManager.class);
            try (ExternalSystemEventDispatcher eventDispatcher = new ExternalSystemEventDispatcher(id, (BuildProgressListener)syncViewManager);){
                String projectPath = Projects.getBaseDirPath((Project)this.myProject).getPath();
                DefaultBuildDescriptor buildDescriptor = new DefaultBuildDescriptor((Object)id, this.myProject.getName(), projectPath, System.currentTimeMillis());
                StartBuildEventImpl startEvent = new StartBuildEventImpl((BuildDescriptor)buildDescriptor, "syncing...").withContentDescriptorSupplier(() -> {
                    AndroidGradleSyncTextConsoleView consoleView = new AndroidGradleSyncTextConsoleView(this.myProject);
                    return new RunContentDescriptor((ExecutionConsole)consoleView, null, consoleView.getComponent(), "Gradle Sync");
                });
                eventDispatcher.onEvent((Object)id, (BuildEvent)startEvent);
                try {
                    boolean forceFullVariantsSync;
                    boolean bl = forceFullVariantsSync = request != null && request.forceFullVariantsSync;
                    if (CommandLineArgs.isInTestingMode()) {
                        SimulatedSyncErrors.simulateRegisteredSyncError();
                    }
                    if (shouldGenerateSources) {
                        if (options != null) {
                            SyncExecutor.executeVariantOnlySyncAndGenerateSources(connection, executionSettings, indicator, id, (BuildEventDispatcher)eventDispatcher, callback, options);
                        } else {
                            this.executeFullSyncAndGenerateSources(connection, executionSettings, indicator, id, (BuildEventDispatcher)eventDispatcher, callback, forceFullVariantsSync);
                        }
                        break block24;
                    }
                    if (options != null) {
                        SyncExecutor.executeVariantOnlySync(connection, executionSettings, indicator, id, (BuildEventDispatcher)eventDispatcher, callback, options);
                        break block24;
                    }
                    this.executeFullSync(connection, executionSettings, indicator, id, (BuildEventDispatcher)eventDispatcher, callback, forceFullVariantsSync);
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof NewGradleSyncNotSupportedException) {
                        PropertiesComponent.getInstance((Project)this.myProject).setValue("not.eligible.for.single.variant.sync", true);
                        StudioFlags.SINGLE_VARIANT_SYNC_ENABLED.override(false);
                        StudioFlags.NEW_SYNC_INFRA_ENABLED.override(false);
                        GradleSyncState.getInstance(this.myProject).syncEnded();
                        this.generateFailureEvent(id);
                        GradleSyncInvoker.getInstance().requestProjectSync(this.myProject, request != null ? request : GradleSyncInvoker.Request.projectModified(), listener2);
                        break block24;
                    }
                    this.myErrorHandlerManager.handleError(e);
                    callback.setRejected(e);
                    this.generateFailureEvent(id);
                }
            }
        }
    }

    private void generateFailureEvent(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            SyncExecutor.$$$reportNull$$$0(19);
        }
        if (CommandLineArgs.isInTestingMode()) {
            PostSyncProjectSetup.finishFailedSync(id, this.myProject);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> PostSyncProjectSetup.finishFailedSync(id, this.myProject));
        }
    }

    private void executeFullSync(@NotNull ProjectConnection connection, @NotNull GradleExecutionSettings executionSettings, @NotNull ProgressIndicator indicator, @NotNull ExternalSystemTaskId id, @NotNull BuildEventDispatcher buildEventDispatcher, @NotNull SyncExecutionCallback callback, boolean forceFullVariantsSync) {
        if (connection == null) {
            SyncExecutor.$$$reportNull$$$0(20);
        }
        if (executionSettings == null) {
            SyncExecutor.$$$reportNull$$$0(21);
        }
        if (indicator == null) {
            SyncExecutor.$$$reportNull$$$0(22);
        }
        if (id == null) {
            SyncExecutor.$$$reportNull$$$0(23);
        }
        if (buildEventDispatcher == null) {
            SyncExecutor.$$$reportNull$$$0(24);
        }
        if (callback == null) {
            SyncExecutor.$$$reportNull$$$0(25);
        }
        SyncProjectModels projectModels = this.doFetchModels(connection, executionSettings, indicator, id, buildEventDispatcher, forceFullVariantsSync);
        callback.setDone(projectModels, id);
    }

    @NotNull
    private SyncProjectModels doFetchModels(@NotNull ProjectConnection connection, @NotNull GradleExecutionSettings executionSettings, @NotNull ProgressIndicator indicator, @NotNull ExternalSystemTaskId id, @Nullable BuildEventDispatcher buildEventDispatcher, boolean forceFullVariantsSync) {
        if (connection == null) {
            SyncExecutor.$$$reportNull$$$0(26);
        }
        if (executionSettings == null) {
            SyncExecutor.$$$reportNull$$$0(27);
        }
        if (indicator == null) {
            SyncExecutor.$$$reportNull$$$0(28);
        }
        if (id == null) {
            SyncExecutor.$$$reportNull$$$0(29);
        }
        boolean isSingleVariantSync = !forceFullVariantsSync && NewGradleSync.isSingleVariantSync(this.myProject);
        SyncAction syncAction = this.createSyncAction(false, isSingleVariantSync);
        BuildActionExecuter executor = connection.action((BuildAction)syncAction);
        if (buildEventDispatcher == null) {
            final SyncViewManager syncViewManager = (SyncViewManager)ServiceManager.getService((Project)this.myProject, SyncViewManager.class);
            buildEventDispatcher = new BuildEventDispatcher(){

                public void onEvent(@NotNull Object buildId2, @NotNull BuildEvent event) {
                    if (buildId2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    syncViewManager.onEvent(buildId2, event);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "buildId";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "com/android/tools/idea/gradle/project/sync/ng/SyncExecutor$1";
                    objectArray[2] = "onEvent";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        GradleExecutionHelper.prepare((LongRunningOperation)executor, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)new GradleSyncNotificationListener(id, indicator, buildEventDispatcher), (ProjectConnection)connection);
        SyncProjectModels syncProjectModels = (SyncProjectModels)executor.run();
        if (syncProjectModels == null) {
            SyncExecutor.$$$reportNull$$$0(30);
        }
        return syncProjectModels;
    }

    private void executeFullSyncAndGenerateSources(@NotNull ProjectConnection connection, @NotNull GradleExecutionSettings executionSettings, @NotNull ProgressIndicator indicator, @NotNull ExternalSystemTaskId id, @NotNull BuildEventDispatcher buildEventDispatcher, @NotNull SyncExecutionCallback callback, boolean forceFullVariantsSync) {
        if (connection == null) {
            SyncExecutor.$$$reportNull$$$0(31);
        }
        if (executionSettings == null) {
            SyncExecutor.$$$reportNull$$$0(32);
        }
        if (indicator == null) {
            SyncExecutor.$$$reportNull$$$0(33);
        }
        if (id == null) {
            SyncExecutor.$$$reportNull$$$0(34);
        }
        if (buildEventDispatcher == null) {
            SyncExecutor.$$$reportNull$$$0(35);
        }
        if (callback == null) {
            SyncExecutor.$$$reportNull$$$0(36);
        }
        SyncAction syncAction = this.createSyncAction(true, NewGradleSync.isSingleVariantSync(this.myProject));
        BuildActionExecuter executor = connection.action().projectsLoaded((BuildAction)syncAction, models -> callback.setDone((SyncProjectModels)models, id)).build().forTasks(Collections.emptyList());
        GradleExecutionHelper.prepare((LongRunningOperation)executor, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)new GradleSyncNotificationListener(id, indicator, buildEventDispatcher), (ProjectConnection)connection);
        try {
            executor.run();
        }
        catch (UnsupportedVersionException e) {
            if (e.getMessage().contains("PhasedBuildActionExecuter API")) {
                this.executeFullSync(connection, executionSettings, indicator, id, buildEventDispatcher, callback, forceFullVariantsSync);
            }
            throw e;
        }
    }

    private static void executeVariantOnlySync(@NotNull ProjectConnection connection, @NotNull GradleExecutionSettings executionSettings, @NotNull ProgressIndicator indicator, @NotNull ExternalSystemTaskId id, @NotNull BuildEventDispatcher buildEventDispatcher, @NotNull SyncExecutionCallback callback, @NotNull VariantOnlySyncOptions options) {
        if (connection == null) {
            SyncExecutor.$$$reportNull$$$0(37);
        }
        if (executionSettings == null) {
            SyncExecutor.$$$reportNull$$$0(38);
        }
        if (indicator == null) {
            SyncExecutor.$$$reportNull$$$0(39);
        }
        if (id == null) {
            SyncExecutor.$$$reportNull$$$0(40);
        }
        if (buildEventDispatcher == null) {
            SyncExecutor.$$$reportNull$$$0(41);
        }
        if (callback == null) {
            SyncExecutor.$$$reportNull$$$0(42);
        }
        if (options == null) {
            SyncExecutor.$$$reportNull$$$0(43);
        }
        VariantOnlySyncAction syncAction = new VariantOnlySyncAction(options);
        BuildActionExecuter executor = connection.action((BuildAction)syncAction);
        GradleExecutionHelper.prepare((LongRunningOperation)executor, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)new GradleSyncNotificationListener(id, indicator, buildEventDispatcher), (ProjectConnection)connection);
        callback.setDone((VariantOnlyProjectModels)executor.run(), id);
    }

    private static void executeVariantOnlySyncAndGenerateSources(@NotNull ProjectConnection connection, @NotNull GradleExecutionSettings executionSettings, @NotNull ProgressIndicator indicator, @NotNull ExternalSystemTaskId id, @NotNull BuildEventDispatcher buildEventDispatcher, @NotNull SyncExecutionCallback callback, @NotNull VariantOnlySyncOptions options) {
        if (connection == null) {
            SyncExecutor.$$$reportNull$$$0(44);
        }
        if (executionSettings == null) {
            SyncExecutor.$$$reportNull$$$0(45);
        }
        if (indicator == null) {
            SyncExecutor.$$$reportNull$$$0(46);
        }
        if (id == null) {
            SyncExecutor.$$$reportNull$$$0(47);
        }
        if (buildEventDispatcher == null) {
            SyncExecutor.$$$reportNull$$$0(48);
        }
        if (callback == null) {
            SyncExecutor.$$$reportNull$$$0(49);
        }
        if (options == null) {
            SyncExecutor.$$$reportNull$$$0(50);
        }
        VariantOnlySyncAction syncAction = new VariantOnlySyncAction(options);
        BuildActionExecuter executor = connection.action().projectsLoaded((BuildAction)syncAction, models -> callback.setDone((VariantOnlyProjectModels)models, id)).build().forTasks(Collections.emptyList());
        GradleExecutionHelper.prepare((LongRunningOperation)executor, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)new GradleSyncNotificationListener(id, indicator, buildEventDispatcher), (ProjectConnection)connection);
        try {
            executor.run();
        }
        catch (UnsupportedVersionException e) {
            if (e.getMessage().contains("PhasedBuildActionExecuter API")) {
                SyncExecutor.executeVariantOnlySync(connection, executionSettings, indicator, id, buildEventDispatcher, callback, options);
            }
            throw e;
        }
    }

    @VisibleForTesting
    @NotNull
    SyncAction createSyncAction(boolean shouldGenerateSources, boolean isSingleVariantSync) {
        SyncActionOptions options = new SyncActionOptions();
        options.setSingleVariantSyncEnabled(isSingleVariantSync);
        if (options.isSingleVariantSyncEnabled()) {
            SelectedVariants selectedVariants2 = this.mySelectedVariantCollector.collectSelectedVariants();
            options.setSelectedVariants(selectedVariants2);
            options.setShouldGenerateSources(shouldGenerateSources);
        }
        SyncAction syncAction = new SyncAction(this.myExtraModelsManager.getAndroidModelTypes(), this.myExtraModelsManager.getJavaModelTypes(), options);
        if (syncAction == null) {
            SyncExecutor.$$$reportNull$$$0(51);
        }
        return syncAction;
    }

    @NotNull
    private static ExternalSystemTaskId createId(@NotNull Project project) {
        if (project == null) {
            SyncExecutor.$$$reportNull$$$0(52);
        }
        ExternalSystemTaskId externalSystemTaskId = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)project);
        if (externalSystemTaskId == null) {
            SyncExecutor.$$$reportNull$$$0(53);
        }
        return externalSystemTaskId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 14: 
            case 30: 
            case 51: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 14: 
            case 30: 
            case 51: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraModelsManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArgs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandlerManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedVariantCollector";
                break;
            }
            case 6: 
            case 14: 
            case 30: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/SyncExecutor";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 17: 
            case 22: 
            case 28: 
            case 33: 
            case 39: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 18: 
            case 25: 
            case 36: 
            case 42: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 11: 
            case 43: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 15: 
            case 20: 
            case 26: 
            case 31: 
            case 37: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 16: 
            case 21: 
            case 27: 
            case 32: 
            case 38: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionSettings";
                break;
            }
            case 19: 
            case 23: 
            case 29: 
            case 34: 
            case 40: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 24: 
            case 35: 
            case 41: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildEventDispatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/SyncExecutor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchGradleModels";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findGradleExecutionSettings";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "doFetchModels";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createSyncAction";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 14: 
            case 30: 
            case 51: 
            case 53: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "syncProject";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generateFailureEvent";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "executeFullSync";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doFetchModels";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "executeFullSyncAndGenerateSources";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "executeVariantOnlySync";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "executeVariantOnlySyncAndGenerateSources";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 14: 
            case 30: 
            case 51: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class GradleSyncNotificationListener
    extends ExternalSystemTaskNotificationListenerAdapter {
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final ExternalSystemTaskId myTaskId;
        @NotNull
        private final BuildEventDispatcher myBuildEventDispatcher;

        GradleSyncNotificationListener(@NotNull ExternalSystemTaskId taskId, @NotNull ProgressIndicator indicator, @NotNull BuildEventDispatcher eventDispatcher) {
            if (taskId == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(1);
            }
            if (eventDispatcher == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(2);
            }
            this.myIndicator = indicator;
            this.myTaskId = taskId;
            this.myBuildEventDispatcher = eventDispatcher;
        }

        public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
            Project project;
            if (id == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(3);
            }
            if (text == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(4);
            }
            if ((project = this.myTaskId.findProject()) == null) {
                return;
            }
            this.myBuildEventDispatcher.setStdOut(stdOut);
            this.myBuildEventDispatcher.append((CharSequence)text);
        }

        public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
            if (event == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(5);
            }
            GradleSyncProgress.notifyProgress(this.myIndicator, event.getDescription());
            BuildEvent buildEvent = null;
            if (event instanceof ExternalSystemBuildEvent) {
                buildEvent = ((ExternalSystemBuildEvent)event).getBuildEvent();
            } else if (event instanceof ExternalSystemTaskExecutionEvent) {
                buildEvent = ExternalSystemUtil.convert((ExternalSystemTaskExecutionEvent)((ExternalSystemTaskExecutionEvent)event));
            }
            if (buildEvent == null) {
                return;
            }
            Project project = this.myTaskId.findProject();
            if (project == null) {
                return;
            }
            this.myBuildEventDispatcher.onEvent((Object)this.myTaskId, buildEvent);
        }

        public void onEnd(@NotNull ExternalSystemTaskId id) {
            if (id == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(6);
            }
            this.closeOutputReader();
        }

        public void onCancel(@NotNull ExternalSystemTaskId id) {
            if (id == null) {
                GradleSyncNotificationListener.$$$reportNull$$$0(7);
            }
            super.onCancel(id);
            Project project = this.myTaskId.findProject();
            if (project != null) {
                FinishBuildEventImpl event = new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "cancelled", (EventResult)new SkippedResultImpl());
                this.myBuildEventDispatcher.onEvent((Object)id, (BuildEvent)event);
            }
            this.closeOutputReader();
        }

        private void closeOutputReader() {
            this.myBuildEventDispatcher.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventDispatcher";
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/SyncExecutor$GradleSyncNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTaskOutput";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onStatusChange";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onEnd";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCancel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

