/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacetConfiguration;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariants;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SelectedVariantCollector {
    @NotNull
    private final Project myProject;

    SelectedVariantCollector(@NotNull Project project) {
        if (project == null) {
            SelectedVariantCollector.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    SelectedVariants collectSelectedVariants() {
        SelectedVariants selectedVariants2 = new SelectedVariants();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            SelectedVariant variant = this.findSelectedVariant(module);
            if (variant == null) continue;
            selectedVariants2.addSelectedVariant(variant.moduleId, variant.variantName, variant.abiName);
        }
        SelectedVariants selectedVariants3 = selectedVariants2;
        if (selectedVariants3 == null) {
            SelectedVariantCollector.$$$reportNull$$$0(1);
        }
        return selectedVariants3;
    }

    @VisibleForTesting
    @Nullable
    SelectedVariant findSelectedVariant(@NotNull Module module) {
        GradleModuleModel gradleModel;
        GradleFacet gradleFacet;
        if (module == null) {
            SelectedVariantCollector.$$$reportNull$$$0(2);
        }
        if ((gradleFacet = GradleFacet.getInstance(module)) != null && (gradleModel = gradleFacet.getGradleModuleModel()) != null) {
            File rootFolder = gradleModel.getRootFolderPath();
            String projectPath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            NdkModuleModel ndkModuleModel = NdkModuleModel.get(module);
            NdkFacet ndkFacet = NdkFacet.getInstance(module);
            if (ndkFacet != null && ndkModuleModel != null) {
                String ndkVariantName = ((NdkFacetConfiguration)ndkFacet.getConfiguration()).SELECTED_BUILD_VARIANT;
                return new SelectedVariant(rootFolder, projectPath, ndkModuleModel.getVariantName(ndkVariantName), ndkModuleModel.getAbiName(ndkVariantName));
            }
            if (androidFacet != null) {
                return new SelectedVariant(rootFolder, projectPath, androidFacet.getProperties().SELECTED_BUILD_VARIANT, null);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/SelectedVariantCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/SelectedVariantCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSelectedVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSelectedVariant";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class SelectedVariant {
        @NotNull
        final String moduleId;
        @NotNull
        final String variantName;
        @Nullable
        final String abiName;

        SelectedVariant(@NotNull File rootFolderPath, @NotNull String gradlePath, @NotNull String variantName, @Nullable String abiName) {
            if (rootFolderPath == null) {
                SelectedVariant.$$$reportNull$$$0(0);
            }
            if (gradlePath == null) {
                SelectedVariant.$$$reportNull$$$0(1);
            }
            if (variantName == null) {
                SelectedVariant.$$$reportNull$$$0(2);
            }
            this.moduleId = Modules.createUniqueModuleId(rootFolderPath, gradlePath);
            this.variantName = variantName;
            this.abiName = abiName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rootFolderPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "gradlePath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variantName";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/project/sync/ng/SelectedVariantCollector$SelectedVariant";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

