/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.java.model.ArtifactModel;
import com.android.java.model.JavaProject;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectBuildFileChecksums;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModelFactory;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.GradleSync;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.PsdModuleModels;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutionCallback;
import com.android.tools.idea.gradle.project.sync.ng.SyncExecutor;
import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.SyncResultHandler;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedProjectModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.ModelNotFoundInCacheException;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewGradleSync
implements GradleSync {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleSyncMessages mySyncMessages;
    @NotNull
    private final SyncExecutor mySyncExecutor;
    @NotNull
    private final SyncResultHandler myResultHandler;
    @NotNull
    private final ProjectBuildFileChecksums.Loader myBuildFileChecksumsLoader;
    @NotNull
    private final CachedProjectModels.Loader myProjectModelsCacheLoader;
    @NotNull
    private final SyncExecutionCallback.Factory myCallbackFactory;
    public static final String NOT_ELIGIBLE_FOR_SINGLE_VARIANT_SYNC = "not.eligible.for.single.variant.sync";

    public static boolean isLevel4Model() {
        return (Boolean)StudioFlags.L4_DEPENDENCY_MODEL.get();
    }

    public static boolean isEnabled(@NotNull Project project) {
        if (project == null) {
            NewGradleSync.$$$reportNull$$$0(0);
        }
        return (Boolean)StudioFlags.NEW_SYNC_INFRA_ENABLED.get() != false || NewGradleSync.isSingleVariantSync(project);
    }

    public static boolean isSingleVariantSync(@NotNull Project project) {
        if (project == null) {
            NewGradleSync.$$$reportNull$$$0(1);
        }
        return (Boolean)StudioFlags.SINGLE_VARIANT_SYNC_ENABLED.get() != false || GradleExperimentalSettings.getInstance().USE_SINGLE_VARIANT_SYNC && !PropertiesComponent.getInstance((Project)project).getBoolean(NOT_ELIGIBLE_FOR_SINGLE_VARIANT_SYNC);
    }

    public static boolean isCompoundSync(@NotNull Project project) {
        if (project == null) {
            NewGradleSync.$$$reportNull$$$0(2);
        }
        return (Boolean)StudioFlags.COMPOUND_SYNC_ENABLED.get() != false && NewGradleSync.isEnabled(project) && NewGradleSync.isSingleVariantSync(project);
    }

    public static boolean isShippedSync(@NotNull Project project) {
        if (project == null) {
            NewGradleSync.$$$reportNull$$$0(3);
        }
        return (Boolean)StudioFlags.SHIPPED_SYNC_ENABLED.get() != false && NewGradleSync.isEnabled(project) && GradleProjectInfo.getInstance(project).isNewProject();
    }

    public NewGradleSync(@NotNull Project project) {
        if (project == null) {
            NewGradleSync.$$$reportNull$$$0(4);
        }
        this(project, GradleSyncMessages.getInstance(project), new SyncExecutor(project), new SyncResultHandler(project), new ProjectBuildFileChecksums.Loader(), new CachedProjectModels.Loader(), new SyncExecutionCallback.Factory());
    }

    @VisibleForTesting
    NewGradleSync(@NotNull Project project, @NotNull GradleSyncMessages syncMessages, @NotNull SyncExecutor syncExecutor, @NotNull SyncResultHandler resultHandler, @NotNull ProjectBuildFileChecksums.Loader buildFileChecksumsLoader, @NotNull CachedProjectModels.Loader projectModelsCacheLoader, @NotNull SyncExecutionCallback.Factory callbackFactory) {
        if (project == null) {
            NewGradleSync.$$$reportNull$$$0(5);
        }
        if (syncMessages == null) {
            NewGradleSync.$$$reportNull$$$0(6);
        }
        if (syncExecutor == null) {
            NewGradleSync.$$$reportNull$$$0(7);
        }
        if (resultHandler == null) {
            NewGradleSync.$$$reportNull$$$0(8);
        }
        if (buildFileChecksumsLoader == null) {
            NewGradleSync.$$$reportNull$$$0(9);
        }
        if (projectModelsCacheLoader == null) {
            NewGradleSync.$$$reportNull$$$0(10);
        }
        if (callbackFactory == null) {
            NewGradleSync.$$$reportNull$$$0(11);
        }
        this.myProject = project;
        this.mySyncMessages = syncMessages;
        this.mySyncExecutor = syncExecutor;
        this.myResultHandler = resultHandler;
        this.myBuildFileChecksumsLoader = buildFileChecksumsLoader;
        this.myProjectModelsCacheLoader = projectModelsCacheLoader;
        this.myCallbackFactory = callbackFactory;
    }

    @Override
    public void sync(@NotNull GradleSyncInvoker.Request request, @Nullable GradleSyncListener listener2) {
        Application application;
        if (request == null) {
            NewGradleSync.$$$reportNull$$$0(12);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode()) {
            this.mySyncMessages.removeAllMessages();
            this.sync(request, (ProgressIndicator)new EmptyProgressIndicator(), listener2);
            return;
        }
        Task task = this.createSyncTask(request, listener2);
        application.invokeLater(() -> {
            this.mySyncMessages.removeAllMessages();
            task.queue();
        }, ModalityState.defaultModalityState());
    }

    @VisibleForTesting
    @NotNull
    Task createSyncTask(final @NotNull GradleSyncInvoker.Request request, final @Nullable GradleSyncListener listener2) {
        Object syncTask;
        if (request == null) {
            NewGradleSync.$$$reportNull$$$0(13);
        }
        String title = "Gradle Sync";
        ProgressExecutionMode executionMode = request.getProgressExecutionMode();
        switch (executionMode) {
            case MODAL_SYNC: {
                syncTask = new Task.Modal(this.myProject, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        NewGradleSync.this.sync(request, indicator, listener2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/ng/NewGradleSync$1", "run"));
                    }
                };
                break;
            }
            case IN_BACKGROUND_ASYNC: {
                syncTask = new Task.Backgroundable(this.myProject, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        NewGradleSync.this.sync(request, indicator, listener2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/ng/NewGradleSync$2", "run"));
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException(executionMode + " is not a supported execution mode");
            }
        }
        Object object = syncTask;
        if (object == null) {
            NewGradleSync.$$$reportNull$$$0(14);
        }
        return object;
    }

    private void sync(@NotNull GradleSyncInvoker.Request request, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener) {
        PostSyncProjectSetup.Request setupRequest;
        if (request == null) {
            NewGradleSync.$$$reportNull$$$0(15);
        }
        if (indicator == null) {
            NewGradleSync.$$$reportNull$$$0(16);
        }
        if (this.trySyncWithCachedGradleModels(setupRequest = NewGradleSync.createPostSyncRequest(request), indicator, syncListener)) {
            return;
        }
        boolean isVariantOnlySync = request.variantOnlySyncOptions != null;
        boolean isCompoundSync = NewGradleSync.isCompoundSync(this.myProject) && request.generateSourcesOnSuccess;
        SyncExecutionCallback callback = this.myCallbackFactory.create();
        callback.doWhenRejected(() -> this.myResultHandler.onSyncFailed(callback, syncListener));
        if (isCompoundSync) {
            callback.doWhenDone(() -> this.myResultHandler.onCompoundSyncModels(callback, setupRequest, indicator, syncListener, isVariantOnlySync));
        } else if (isVariantOnlySync) {
            callback.doWhenDone(() -> this.myResultHandler.onVariantOnlySyncFinished(callback, setupRequest, indicator, syncListener));
        } else {
            callback.doWhenDone(() -> this.myResultHandler.onSyncFinished(callback, setupRequest, indicator, syncListener));
        }
        this.mySyncExecutor.syncProject(indicator, callback, request.variantOnlySyncOptions, syncListener, request, isCompoundSync);
        if (isCompoundSync) {
            this.myResultHandler.onCompoundSyncFinished(syncListener);
        }
    }

    private boolean trySyncWithCachedGradleModels(@NotNull PostSyncProjectSetup.Request setupRequest, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener) {
        if (setupRequest == null) {
            NewGradleSync.$$$reportNull$$$0(17);
        }
        if (indicator == null) {
            NewGradleSync.$$$reportNull$$$0(18);
        }
        if (!setupRequest.usingCachedGradleModels) {
            return false;
        }
        ProjectBuildFileChecksums buildFileChecksums = this.myBuildFileChecksumsLoader.loadFromDisk(this.myProject);
        if (buildFileChecksums == null || !buildFileChecksums.canUseCachedData()) {
            return false;
        }
        CachedProjectModels projectModelsCache = this.myProjectModelsCacheLoader.loadFromDisk(this.myProject);
        if (projectModelsCache == null) {
            return false;
        }
        setupRequest.generateSourcesAfterSync = false;
        setupRequest.lastSyncTimestamp = buildFileChecksums.getLastGradleSyncTimestamp();
        ExternalSystemTaskId taskId = PostSyncProjectSetup.createProjectSetupFromCacheTaskWithStartMessage(this.myProject);
        try {
            this.myResultHandler.onSyncSkipped(projectModelsCache, setupRequest, indicator, syncListener, taskId);
        }
        catch (ModelNotFoundInCacheException e) {
            Logger.getInstance(NewGradleSync.class).warn("Restoring project state from cache failed. Performing a Gradle Sync.", (Throwable)e);
            return false;
        }
        return true;
    }

    private static PostSyncProjectSetup.Request createPostSyncRequest(@NotNull GradleSyncInvoker.Request request) {
        if (request == null) {
            NewGradleSync.$$$reportNull$$$0(19);
        }
        PostSyncProjectSetup.Request setupRequest = new PostSyncProjectSetup.Request();
        setupRequest.usingCachedGradleModels = request.useCachedGradleModels;
        setupRequest.generateSourcesAfterSync = request.generateSourcesOnSuccess;
        setupRequest.cleanProjectAfterSync = request.cleanProject;
        NewGradleSync.setSkipAndroidPluginUpgrade(request, setupRequest);
        return setupRequest;
    }

    private static void setSkipAndroidPluginUpgrade(@NotNull GradleSyncInvoker.Request syncRequest, @NotNull PostSyncProjectSetup.Request setupRequest) {
        if (syncRequest == null) {
            NewGradleSync.$$$reportNull$$$0(20);
        }
        if (setupRequest == null) {
            NewGradleSync.$$$reportNull$$$0(21);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && syncRequest.skipAndroidPluginUpgrade) {
            setupRequest.skipAndroidPluginUpgrade = true;
        }
    }

    @Override
    @NotNull
    public List<GradleModuleModels> fetchGradleModels(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            NewGradleSync.$$$reportNull$$$0(22);
        }
        List<SyncModuleModels> models = this.mySyncExecutor.fetchGradleModels(indicator);
        ImmutableList.Builder builder = ImmutableList.builder();
        IdeDependenciesFactory dependenciesFactory = new IdeDependenciesFactory();
        JavaModuleModelFactory javaModelFactory = new JavaModuleModelFactory();
        String emptyVariantName = "";
        for (SyncModuleModels moduleModels : models) {
            GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
            if (gradleProject == null) continue;
            String name = moduleModels.getModuleName();
            PsdModuleModels newModels = new PsdModuleModels(name);
            builder.add((Object)newModels);
            GradleScript buildScript = null;
            try {
                buildScript = gradleProject.getBuildScript();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            File buildFilePath = buildScript != null ? buildScript.getSourceFile() : null;
            GradleModuleModel gradleModel = new GradleModuleModel(name, gradleProject, Collections.emptyList(), buildFilePath, null);
            newModels.addModel(GradleModuleModel.class, gradleModel);
            File moduleRootPath = gradleProject.getProjectDirectory();
            AndroidProject androidProject = moduleModels.findModel(AndroidProject.class);
            if (androidProject != null) {
                AndroidModuleModel androidModel = new AndroidModuleModel(name, moduleRootPath, androidProject, emptyVariantName, dependenciesFactory);
                newModels.addModel(AndroidModuleModel.class, androidModel);
                continue;
            }
            JavaProject javaProject = moduleModels.findModel(JavaProject.class);
            if (javaProject != null) {
                JavaModuleModel javaModel = javaModelFactory.create(moduleRootPath, gradleProject, javaProject);
                newModels.addModel(JavaModuleModel.class, javaModel);
                continue;
            }
            ArtifactModel jarAarProject = moduleModels.findModel(ArtifactModel.class);
            if (gradleProject.getPath().equals(":") || jarAarProject == null) continue;
            JavaModuleModel javaModel = javaModelFactory.create(moduleRootPath, gradleProject, jarAarProject);
            newModels.addModel(JavaModuleModel.class, javaModel);
        }
        ImmutableList immutableList = builder.build();
        if (immutableList == null) {
            NewGradleSync.$$$reportNull$$$0(23);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncMessages";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncExecutor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFileChecksumsLoader";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModelsCacheLoader";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackFactory";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/NewGradleSync";
                break;
            }
            case 16: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupRequest";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/NewGradleSync";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createSyncTask";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchGradleModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSingleVariantSync";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCompoundSync";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isShippedSync";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sync";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createSyncTask";
                break;
            }
            case 14: 
            case 23: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "trySyncWithCachedGradleModels";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createPostSyncRequest";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setSkipAndroidPluginUpgrade";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fetchGradleModels";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

