/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Strings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.tooling.model.GradleProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class ModuleNameGenerator {
    private static final int MAX_FILE_DEPTH = 3;

    static void deduplicateModuleNames(@NotNull SyncProjectModels projectModels, @NotNull Project project) {
        if (projectModels == null) {
            ModuleNameGenerator.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ModuleNameGenerator.$$$reportNull$$$0(1);
        }
        HashMap<SyncModuleModels, ModuleName> moduleModelsToModuleName = new HashMap<SyncModuleModels, ModuleName>();
        List<SyncModuleModels> moduleModels = projectModels.getModuleModels();
        for (SyncModuleModels moduleModel : moduleModels) {
            GradleProject gradleProject = moduleModel.findModel(GradleProject.class);
            if (gradleProject == null) continue;
            moduleModelsToModuleName.put(moduleModel, new ModuleName(gradleProject.getProjectDirectory().getPath(), moduleModel.getModuleName()));
        }
        ModuleNameGenerator.doDeduplicate(moduleModelsToModuleName.values(), project);
        for (SyncModuleModels moduleModel : moduleModels) {
            ModuleName moduleName = (ModuleName)moduleModelsToModuleName.get(moduleModel);
            if (moduleName == null) continue;
            moduleModel.setModuleName(moduleName.name);
        }
    }

    @NotNull
    public static Map<String, String> getModuleNameByModulePath(@NotNull Collection<String> modulePaths, @NotNull Project project) {
        if (modulePaths == null) {
            ModuleNameGenerator.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ModuleNameGenerator.$$$reportNull$$$0(3);
        }
        Map<String, ModuleName> moduleNameByModulePath = modulePaths.stream().collect(Collectors.toMap(p -> p, p -> new ModuleName((String)p, new File((String)p).getName())));
        ModuleNameGenerator.doDeduplicate(moduleNameByModulePath.values(), project);
        Map<String, String> map2 = moduleNameByModulePath.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((ModuleName)e.getValue()).name));
        if (map2 == null) {
            ModuleNameGenerator.$$$reportNull$$$0(4);
        }
        return map2;
    }

    private static void doDeduplicate(@NotNull Collection<ModuleName> moduleNames, @NotNull Project project) {
        if (moduleNames == null) {
            ModuleNameGenerator.$$$reportNull$$$0(5);
        }
        if (project == null) {
            ModuleNameGenerator.$$$reportNull$$$0(6);
        }
        Map<String, List<ModuleName>> moduleNamesByName = moduleNames.stream().collect(Collectors.groupingBy(m -> ((ModuleName)m).name));
        GradleProjectSettings settings = GradleUtil.getGradleProjectSettings(project);
        char delimiter = settings != null && settings.isUseQualifiedModuleNames() ? (char)'.' : '-';
        for (List<ModuleName> names : moduleNamesByName.values()) {
            if (names.size() <= 1) continue;
            ModuleNameGenerator.doDeduplicate(names, delimiter);
        }
    }

    private static void doDeduplicate(@NotNull List<ModuleName> moduleNames, char delimiter) {
        Set uniqueNames;
        if (moduleNames == null) {
            ModuleNameGenerator.$$$reportNull$$$0(7);
        }
        HashMap moduleNameToNameCandidates = new HashMap();
        for (ModuleName moduleName : moduleNames) {
            List pathParts = FileUtil.splitPath((String)FileUtil.toSystemDependentName((String)moduleName.moduleDirectory));
            ArrayList<String> nameCandidates = new ArrayList<String>();
            moduleNameToNameCandidates.put(moduleName, nameCandidates);
            StringBuilder nameBuilder = new StringBuilder(moduleName.name);
            int i2 = pathParts.size() - 2;
            for (int j = 0; i2 >= 0 && j < 3; --i2, ++j) {
                String prefix = (String)pathParts.get(i2);
                if (Strings.isNullOrEmpty((String)prefix)) continue;
                nameBuilder.insert(0, prefix + delimiter);
                nameCandidates.add(nameBuilder.toString());
            }
        }
        int nameIndex = 0;
        do {
            for (ModuleName moduleName : moduleNames) {
                List nameCandidates = (List)moduleNameToNameCandidates.get(moduleName);
                if (nameCandidates == null || nameIndex >= nameCandidates.size()) continue;
                moduleName.name = (String)nameCandidates.get(nameIndex);
            }
        } while ((uniqueNames = moduleNames.stream().map(m -> ((ModuleName)m).name).collect(Collectors.toSet())).size() < moduleNames.size() && ++nameIndex < 3);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModels";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePaths";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/ModuleNameGenerator";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/ModuleNameGenerator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleNameByModulePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deduplicateModuleNames";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameByModulePath";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doDeduplicate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModuleName {
        @NotNull
        private String moduleDirectory;
        @NotNull
        private String name;

        ModuleName(@NotNull String moduleDirectory, @NotNull String baseName) {
            if (moduleDirectory == null) {
                ModuleName.$$$reportNull$$$0(0);
            }
            if (baseName == null) {
                ModuleName.$$$reportNull$$$0(1);
            }
            this.moduleDirectory = moduleDirectory;
            this.name = baseName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleDirectory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "baseName";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/project/sync/ng/ModuleNameGenerator$ModuleName";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

