/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;

class ModuleFactory {
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeModifiableModelsProvider myModelsProvider;

    ModuleFactory(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (project == null) {
            ModuleFactory.$$$reportNull$$$0(0);
        }
        if (modelsProvider == null) {
            ModuleFactory.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myModelsProvider = modelsProvider;
    }

    @NotNull
    Module createModule(@NotNull GradleModuleModels moduleModels) {
        if (moduleModels == null) {
            ModuleFactory.$$$reportNull$$$0(2);
        }
        GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
        assert (gradleProject != null);
        File imlFilePath = this.getModuleImlFilePath(gradleProject, moduleModels);
        Module newModule = this.myModelsProvider.newModule(imlFilePath.getPath(), StdModuleTypes.JAVA.getId());
        newModule.setOption("external.system.id", GradleUtil.GRADLE_SYSTEM_ID.getId());
        ModifiableRootModel rootModel = this.myModelsProvider.getModifiableRootModel(newModule);
        rootModel.inheritSdk();
        DependencyRemover dependencyRemover = new DependencyRemover(rootModel);
        for (OrderEntry orderEntry : rootModel.getOrderEntries()) {
            orderEntry.accept((RootPolicy)dependencyRemover, null);
        }
        Module module = newModule;
        if (module == null) {
            ModuleFactory.$$$reportNull$$$0(3);
        }
        return module;
    }

    @NotNull
    private File getModuleImlFilePath(@NotNull GradleProject gradleProject, @NotNull GradleModuleModels moduleModels) {
        if (gradleProject == null) {
            ModuleFactory.$$$reportNull$$$0(4);
        }
        if (moduleModels == null) {
            ModuleFactory.$$$reportNull$$$0(5);
        }
        String modulePath = this.getModulePath(gradleProject, moduleModels);
        String imlFileName = moduleModels.getModuleName() + ".iml";
        File file = new File(modulePath, imlFileName);
        if (file == null) {
            ModuleFactory.$$$reportNull$$$0(6);
        }
        return file;
    }

    @NotNull
    private String getModulePath(@NotNull GradleProject gradleProject, @NotNull GradleModuleModels moduleModels) {
        GradleBuild gradleBuild;
        if (gradleProject == null) {
            ModuleFactory.$$$reportNull$$$0(7);
        }
        if (moduleModels == null) {
            ModuleFactory.$$$reportNull$$$0(8);
        }
        if ((gradleBuild = moduleModels.findModel(GradleBuild.class)) != null) {
            File moduleDirPath = GradleProjectResolverUtil.getModuleDirPath((GradleBuild)gradleBuild, (String)gradleProject.getPath());
            if (moduleDirPath == null) {
                throw new IllegalStateException(String.format("Unable to find root directory for module '%1$s'", gradleProject.getName()));
            }
            String string = FileUtil.toCanonicalPath((String)moduleDirPath.getPath());
            if (string == null) {
                ModuleFactory.$$$reportNull$$$0(9);
            }
            return string;
        }
        String projectPath = this.myProject.getBasePath();
        assert (projectPath != null);
        String string = FileUtil.toSystemDependentName((String)org.jetbrains.plugins.gradle.util.GradleUtil.getConfigPath((GradleProject)gradleProject, (String)projectPath));
        if (string == null) {
            ModuleFactory.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModels";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/ModuleFactory";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/ModuleFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleImlFilePath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModuleImlFilePath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModulePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DependencyRemover
    extends RootPolicy<Object> {
        @NotNull
        private final ModifiableRootModel myRootModel;

        DependencyRemover(@NotNull ModifiableRootModel rootModel) {
            if (rootModel == null) {
                DependencyRemover.$$$reportNull$$$0(0);
            }
            this.myRootModel = rootModel;
        }

        public Object visitModuleOrderEntry(@NotNull ModuleOrderEntry orderEntry, Object value2) {
            if (orderEntry == null) {
                DependencyRemover.$$$reportNull$$$0(1);
            }
            return this.remove((OrderEntry)orderEntry, value2);
        }

        public Object visitLibraryOrderEntry(@NotNull LibraryOrderEntry orderEntry, Object value2) {
            if (orderEntry == null) {
                DependencyRemover.$$$reportNull$$$0(2);
            }
            return this.remove((OrderEntry)orderEntry, value2);
        }

        private Object remove(OrderEntry orderEntry, Object value2) {
            this.myRootModel.removeOrderEntry(orderEntry);
            return value2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootModel";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orderEntry";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/ModuleFactory$DependencyRemover";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModuleOrderEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLibraryOrderEntry";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

