/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues.processor;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.issues.SdkInManifestIssuesReporter;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.UsesSdk;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class RemoveSdkFromManifestProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final Collection<Module> myModules;
    @NotNull
    private final SdkInManifestIssuesReporter.SdkProperty myProperty;

    public RemoveSdkFromManifestProcessor(@NotNull Project project, @NotNull Collection<Module> modules, @NotNull SdkInManifestIssuesReporter.SdkProperty property2) {
        if (project == null) {
            RemoveSdkFromManifestProcessor.$$$reportNull$$$0(0);
        }
        if (modules == null) {
            RemoveSdkFromManifestProcessor.$$$reportNull$$$0(1);
        }
        if (property2 == null) {
            RemoveSdkFromManifestProcessor.$$$reportNull$$$0(2);
        }
        super(project);
        this.myModules = modules;
        this.myProperty = property2;
    }

    @NotNull
    public UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            RemoveSdkFromManifestProcessor.$$$reportNull$$$0(3);
        }
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return String.format("Propert%s to move/remove %s", usagesCount > 1 ? "ies" : "y", UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount));
            }

            @NotNull
            public PsiElement[] getElements() {
                if (PsiElement.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return String.format("Remove %s from manifest%s", RemoveSdkFromManifestProcessor.this.myProperty.getPropertyName(), RemoveSdkFromManifestProcessor.this.myModules.size() > 1 ? "s" : "");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/issues/processor/RemoveSdkFromManifestProcessor$1", "getElements"));
            }
        };
        if (usageViewDescriptorAdapter == null) {
            RemoveSdkFromManifestProcessor.$$$reportNull$$$0(4);
        }
        return usageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList usages = new ArrayList();
        this.runOverSdkManifestElements((module, usesSdk) -> {
            XmlElement element = this.myProperty.getManifestFunction().apply((UsesSdk)usesSdk).getXmlElement();
            if (element != null) {
                usages.add(new UsageInfo((PsiElement)element));
            }
        });
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            RemoveSdkFromManifestProcessor.$$$reportNull$$$0(5);
        }
        return usageInfoArray;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            RemoveSdkFromManifestProcessor.$$$reportNull$$$0(6);
        }
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
        Ref xmlChanged = new Ref((Object)false);
        Ref buildFileChanged = new Ref((Object)false);
        this.runOverSdkManifestElements((module, usesSdk) -> {
            ResolvedPropertyModel propertyInBuildModel;
            GradleBuildModel buildModel;
            int defaultVersion = this.myProperty.getDefaultValue();
            AndroidAttributeValue<String> androidAttributeValue = this.myProperty.getManifestFunction().apply((UsesSdk)usesSdk);
            try {
                defaultVersion = Integer.parseInt(Strings.nullToEmpty((String)androidAttributeValue.getStringValue()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            XmlElement element = androidAttributeValue.getXmlElement();
            if (element != null) {
                xmlChanged.set((Object)true);
                element.delete();
                if (usesSdk.getXmlTag().getAttributes().length == 0) {
                    usesSdk.getXmlTag().delete();
                }
            }
            if ((buildModel = projectBuildModel.getModuleBuildModel((Module)module)) != null && (propertyInBuildModel = this.getSdkPropertyInBuildModel(buildModel)).getValueType() == GradlePropertyModel.ValueType.NONE) {
                buildFileChanged.set((Object)true);
                propertyInBuildModel.setValue(defaultVersion);
            }
        });
        if (((Boolean)buildFileChanged.get()).booleanValue()) {
            projectBuildModel.applyChanges();
        }
        if (((Boolean)xmlChanged.get()).booleanValue()) {
            FileDocumentManager.getInstance().saveAllDocuments();
        }
        if (((Boolean)xmlChanged.get()).booleanValue() || ((Boolean)buildFileChanged.get()).booleanValue()) {
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = String.format("Remove %s from manifest%s", this.myProperty.getPropertyName(), this.myModules.size() > 1 ? "s" : "");
        if (string == null) {
            RemoveSdkFromManifestProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private ResolvedPropertyModel getSdkPropertyInBuildModel(@NotNull GradleBuildModel buildModel) {
        if (buildModel == null) {
            RemoveSdkFromManifestProcessor.$$$reportNull$$$0(8);
        }
        ResolvedPropertyModel resolvedPropertyModel = this.myProperty.getBuildFileFunction().apply(buildModel.android().defaultConfig());
        if (resolvedPropertyModel == null) {
            RemoveSdkFromManifestProcessor.$$$reportNull$$$0(9);
        }
        return resolvedPropertyModel;
    }

    private void runOverSdkManifestElements(@NotNull BiConsumer<Module, UsesSdk> func) {
        if (func == null) {
            RemoveSdkFromManifestProcessor.$$$reportNull$$$0(10);
        }
        for (Module module : this.myModules) {
            Manifest manifest;
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet == null || (manifest = androidFacet.getManifest()) == null) continue;
            for (UsesSdk usesSdk : manifest.getUsesSdks()) {
                func.accept(module, usesSdk);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/processor/RemoveSdkFromManifestProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/processor/RemoveSdkFromManifestProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkPropertyInBuildModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSdkPropertyInBuildModel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runOverSdkManifestElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

