/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues.processor;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class AddRepoProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final List<VirtualFile> myBuildFiles;
    @NotNull
    private final Repository myRepository;
    private final boolean myRequestSync;

    public AddRepoProcessor(@NotNull Project project, @NotNull List<VirtualFile> buildFiles, @NotNull Repository repository, boolean requestSync) {
        if (project == null) {
            AddRepoProcessor.$$$reportNull$$$0(0);
        }
        if (buildFiles == null) {
            AddRepoProcessor.$$$reportNull$$$0(1);
        }
        if (repository == null) {
            AddRepoProcessor.$$$reportNull$$$0(2);
        }
        super(project);
        this.myBuildFiles = buildFiles;
        this.myRequestSync = requestSync;
        this.myRepository = repository;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            AddRepoProcessor.$$$reportNull$$$0(3);
        }
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return String.format("File%s to add %s repository to (%d file%s found)", filesCount == 1 ? "" : "s", AddRepoProcessor.this.myRepository.getDisplayName(), filesCount, filesCount == 1 ? "" : "s");
            }

            @NotNull
            public PsiElement[] getElements() {
                if (PsiElement.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return "Add " + AddRepoProcessor.this.myRepository.getDisplayName() + " repository";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/issues/processor/AddRepoProcessor$1", "getElements"));
            }
        };
        if (usageViewDescriptorAdapter == null) {
            AddRepoProcessor.$$$reportNull$$$0(4);
        }
        return usageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (VirtualFile file : this.myBuildFiles) {
            GradleBuildModel buildModel;
            PsiElement psiElement;
            if (!file.isValid() || !file.isWritable() || (psiElement = (buildModel = projectBuildModel.getModuleBuildModel(file)).getPsiElement()) == null) continue;
            usages.add(new UsageInfo(psiElement));
        }
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            AddRepoProcessor.$$$reportNull$$$0(5);
        }
        return usageInfoArray;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            AddRepoProcessor.$$$reportNull$$$0(6);
        }
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
        List elements = Arrays.stream(usages).map(usage -> usage.getElement()).collect(Collectors.toList());
        block3: for (VirtualFile file : this.myBuildFiles) {
            GradleBuildModel buildModel = projectBuildModel.getModuleBuildModel(file);
            PsiElement filePsiElement = buildModel.getPsiElement();
            if (filePsiElement == null || !elements.contains(filePsiElement)) continue;
            switch (this.myRepository) {
                case GOOGLE: {
                    buildModel.repositories().addGoogleMavenRepository(this.myProject);
                    PsiElement buildScriptElement = buildModel.buildscript().getPsiElement();
                    if (buildScriptElement == null) continue block3;
                    buildModel.buildscript().repositories().addGoogleMavenRepository(this.myProject);
                    continue block3;
                }
            }
            throw new IllegalStateException("No handle for requested repository: " + this.myRepository.name());
        }
        projectBuildModel.applyChanges();
        if (this.myRequestSync) {
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = "Add " + this.myRepository.getDisplayName() + " repository";
        if (string == null) {
            AddRepoProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/processor/AddRepoProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/processor/AddRepoProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Repository {
        GOOGLE("Google");

        @NotNull
        private final String myName;

        private Repository(String name) {
            if (name == null) {
                Repository.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @NotNull
        public String getDisplayName() {
            String string = this.myName;
            if (string == null) {
                Repository.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/processor/AddRepoProcessor$Repository";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/processor/AddRepoProcessor$Repository";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

