/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.BuildToolsTooLowReporter;
import com.android.tools.idea.gradle.project.sync.issues.DeprecatedConfigurationReporter;
import com.android.tools.idea.gradle.project.sync.issues.ExternalNdkBuildIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.MinSdkInManifestIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.MissingSdkPackageSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueRegister;
import com.android.tools.idea.gradle.project.sync.issues.TargetSdkInManifestIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnhandledIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnresolvedDependenciesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnsupportedGradleReporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SyncIssuesReporter {
    @NotNull
    private final Map<Integer, BaseSyncIssuesReporter> myStrategies;
    @NotNull
    private final BaseSyncIssuesReporter myDefaultMessageFactory;

    @NotNull
    public static SyncIssuesReporter getInstance() {
        SyncIssuesReporter syncIssuesReporter = (SyncIssuesReporter)ServiceManager.getService(SyncIssuesReporter.class);
        if (syncIssuesReporter == null) {
            SyncIssuesReporter.$$$reportNull$$$0(0);
        }
        return syncIssuesReporter;
    }

    public SyncIssuesReporter(@NotNull UnresolvedDependenciesReporter unresolvedDependenciesReporter) {
        if (unresolvedDependenciesReporter == null) {
            SyncIssuesReporter.$$$reportNull$$$0(1);
        }
        this(unresolvedDependenciesReporter, new ExternalNdkBuildIssuesReporter(), new UnsupportedGradleReporter(), new BuildToolsTooLowReporter(), new MissingSdkPackageSyncIssuesReporter(), new MinSdkInManifestIssuesReporter(), new TargetSdkInManifestIssuesReporter(), new DeprecatedConfigurationReporter());
    }

    @VisibleForTesting
    SyncIssuesReporter(BaseSyncIssuesReporter ... strategies) {
        if (strategies == null) {
            SyncIssuesReporter.$$$reportNull$$$0(2);
        }
        this.myStrategies = new HashMap<Integer, BaseSyncIssuesReporter>(6);
        for (BaseSyncIssuesReporter strategy : strategies) {
            int issueType = strategy.getSupportedIssueType();
            this.myStrategies.put(issueType, strategy);
        }
        this.myDefaultMessageFactory = new UnhandledIssuesReporter();
    }

    public void report(Module ... modules) {
        if (modules == null) {
            SyncIssuesReporter.$$$reportNull$$$0(3);
        }
        this.report(Arrays.asList(modules));
    }

    public void report(@NotNull List<Module> modules) {
        if (modules == null) {
            SyncIssuesReporter.$$$reportNull$$$0(4);
        }
        if (modules.isEmpty()) {
            return;
        }
        this.report(SyncIssueRegister.getInstance(modules.get(0).getProject()).getSyncIssueMap());
    }

    public void report(@NotNull Map<Module, List<SyncIssue>> issuesByModules) {
        if (issuesByModules == null) {
            SyncIssuesReporter.$$$reportNull$$$0(5);
        }
        if (issuesByModules.isEmpty()) {
            return;
        }
        LinkedHashMap syncIssues = new LinkedHashMap();
        IdentityHashMap<SyncIssue, Module> moduleMap = new IdentityHashMap<SyncIssue, Module>();
        LinkedHashMap<Module, VirtualFile> buildFileMap = new LinkedHashMap<Module, VirtualFile>();
        Project project = null;
        boolean[] hasSyncErrors = new boolean[1];
        for (Module module : issuesByModules.keySet()) {
            project = module.getProject();
            buildFileMap.put(module, GradleUtil.getGradleBuildFile(module));
            issuesByModules.get(module).forEach(issue2 -> {
                if (issue2 != null) {
                    syncIssues.computeIfAbsent(issue2.getType(), type -> new ArrayList()).add(issue2);
                    moduleMap.put((SyncIssue)issue2, module);
                    if (issue2.getSeverity() == 2) {
                        hasSyncErrors[0] = true;
                    }
                }
            });
        }
        Map sortedSyncIssues = syncIssues.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue(Comparator.comparing(issues -> ((SyncIssue)issues.get(0)).getSeverity())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldVal, newVal) -> oldVal, LinkedHashMap::new));
        for (Map.Entry entry : sortedSyncIssues.entrySet()) {
            BaseSyncIssuesReporter strategy = this.myStrategies.get(entry.getKey());
            if (strategy == null) {
                strategy = this.myDefaultMessageFactory;
            }
            strategy.reportAll((List)entry.getValue(), moduleMap, buildFileMap);
        }
        if (hasSyncErrors[0] && project != null) {
            GradleSyncState.getInstance(project).getSummary().setSyncErrorsFound(true);
        }
    }

    @VisibleForTesting
    @NotNull
    Map<Integer, BaseSyncIssuesReporter> getStrategies() {
        Map<Integer, BaseSyncIssuesReporter> map2 = this.myStrategies;
        if (map2 == null) {
            SyncIssuesReporter.$$$reportNull$$$0(6);
        }
        return map2;
    }

    @VisibleForTesting
    @NotNull
    BaseSyncIssuesReporter getDefaultMessageFactory() {
        BaseSyncIssuesReporter baseSyncIssuesReporter = this.myDefaultMessageFactory;
        if (baseSyncIssuesReporter == null) {
            SyncIssuesReporter.$$$reportNull$$$0(7);
        }
        return baseSyncIssuesReporter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/SyncIssuesReporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unresolvedDependenciesReporter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategies";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issuesByModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/SyncIssuesReporter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrategies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMessageFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

