/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.ui.QuickFixNotificationListener;
import com.android.tools.idea.util.PositionInFile;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleDeduplicatingSyncIssueReporter
extends BaseSyncIssuesReporter {
    @Override
    void report(@NotNull SyncIssue syncIssue, @NotNull Module module, @Nullable VirtualFile buildFile) {
        if (syncIssue == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(1);
        }
        this.reportAll((List<SyncIssue>)ImmutableList.of((Object)syncIssue), (Map<SyncIssue, Module>)ImmutableMap.of((Object)syncIssue, (Object)module), (Map<Module, VirtualFile>)(buildFile == null ? ImmutableMap.of() : ImmutableMap.of((Object)module, (Object)buildFile)));
    }

    @Override
    void reportAll(@NotNull List<SyncIssue> syncIssues, @NotNull Map<SyncIssue, Module> moduleMap, @NotNull Map<Module, VirtualFile> buildFileMap) {
        if (syncIssues == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(2);
        }
        if (moduleMap == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(3);
        }
        if (buildFileMap == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(4);
        }
        LinkedHashMap<Object, List> groupedIssues = new LinkedHashMap<Object, List>();
        for (SyncIssue issue2 : syncIssues) {
            Object key = this.getDeduplicationKey(issue2);
            if (key == null) continue;
            groupedIssues.computeIfAbsent(key, config -> new ArrayList()).add(issue2);
        }
        for (List entry : groupedIssues.values()) {
            SyncIssue issue3;
            Module module;
            if (entry.isEmpty() || (module = moduleMap.get(issue3 = (SyncIssue)entry.get(0))) == null) continue;
            List<Module> affectedModules = entry.stream().map(moduleMap::get).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(Module::getName)).collect(Collectors.toList());
            boolean isError = entry.stream().anyMatch(i2 -> i2.getSeverity() == 2);
            this.createNotificationDataAndReport(module.getProject(), entry, affectedModules, buildFileMap, isError);
        }
    }

    private void createNotificationDataAndReport(@NotNull Project project, @NotNull List<SyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, boolean isError) {
        MessageType type;
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(5);
        }
        if (syncIssues == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(6);
        }
        if (affectedModules == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(7);
        }
        if (buildFileMap == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(8);
        }
        GradleSyncMessages messages = GradleSyncMessages.getInstance(project);
        MessageType messageType = type = isError ? MessageType.ERROR : MessageType.WARNING;
        assert (!syncIssues.isEmpty());
        NotificationData notification = this.setupNotificationData(project, syncIssues, affectedModules, buildFileMap, type);
        StringBuilder builder = new StringBuilder();
        messages.updateNotification(notification, notification.getMessage(), this.getCustomLinks(project, syncIssues, affectedModules, buildFileMap));
        String message = notification.getMessage().trim();
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(project);
        if (this.shouldIncludeModuleLinks() && !affectedModules.isEmpty()) {
            builder.append("\nAffected Modules: ");
            Iterator<Module> it = affectedModules.iterator();
            while (it.hasNext()) {
                Module m = it.next();
                if (m == null) continue;
                this.doCreateModuleLink(project, notification, builder, m, projectBuildModel, syncIssues, buildFileMap.get(m));
                if (!it.hasNext()) continue;
                builder.append(", ");
            }
        }
        message = message + builder.toString();
        notification.setMessage(message);
        messages.report(notification);
    }

    private void doCreateModuleLink(@NotNull Project project, @NotNull NotificationData notification, @NotNull StringBuilder builder, @NotNull Module module, @NotNull ProjectBuildModel projectBuildModel, @NotNull List<SyncIssue> syncIssues, @Nullable VirtualFile buildFile) {
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(9);
        }
        if (notification == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(10);
        }
        if (builder == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(11);
        }
        if (module == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(12);
        }
        if (projectBuildModel == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(13);
        }
        if (syncIssues == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(14);
        }
        if (buildFile == null) {
            builder.append(module.getName());
        } else {
            OpenFileHyperlink link = this.createModuleLink(project, module, projectBuildModel, syncIssues, buildFile);
            builder.append(link.toHtml());
            notification.setListener(link.getUrl(), (NotificationListener)new QuickFixNotificationListener(project, link));
        }
    }

    @NotNull
    protected OpenFileHyperlink createModuleLink(@NotNull Project project, @NotNull Module module, @NotNull ProjectBuildModel projectBuildModel, @NotNull List<SyncIssue> syncIssues, @NotNull VirtualFile buildFile) {
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(15);
        }
        if (module == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(16);
        }
        if (projectBuildModel == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(17);
        }
        if (syncIssues == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(18);
        }
        if (buildFile == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(19);
        }
        OpenFileHyperlink openFileHyperlink = new OpenFileHyperlink(buildFile.getPath(), module.getName(), -1, -1);
        if (openFileHyperlink == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(20);
        }
        return openFileHyperlink;
    }

    @Nullable
    protected abstract Object getDeduplicationKey(@NotNull SyncIssue var1);

    protected boolean shouldIncludeModuleLinks() {
        return true;
    }

    @NotNull
    protected List<NotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<SyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(21);
        }
        if (syncIssues == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(22);
        }
        if (affectedModules == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(23);
        }
        if (buildFileMap == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(24);
        }
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(25);
        }
        return immutableList;
    }

    @NotNull
    protected NotificationData setupNotificationData(@NotNull Project project, @NotNull List<SyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull MessageType type) {
        VirtualFile file;
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(26);
        }
        if (syncIssues == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(27);
        }
        if (affectedModules == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(28);
        }
        if (buildFileMap == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(29);
        }
        if (type == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(30);
        }
        assert (!syncIssues.isEmpty());
        GradleSyncMessages messages = GradleSyncMessages.getInstance(project);
        PositionInFile position = null;
        if (affectedModules.size() == 1 && (file = buildFileMap.get(affectedModules.get(0))) != null) {
            position = new PositionInFile(file);
        }
        NotificationData data = messages.createNotification("Gradle Sync Issues", syncIssues.get(0).getMessage(), type.convertToCategory(), position);
        if (position != null) {
            data.setNavigatable((Navigatable)new OpenFileDescriptor(project, position.file, position.line, position.column));
        }
        NotificationData notificationData = data;
        if (notificationData == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(31);
        }
        return notificationData;
    }

    public static int getLineNumberForElement(@NotNull Project project, @Nullable PsiElement element) {
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(32);
        }
        return (Integer)ApplicationManager.getApplication().runReadAction(() -> {
            Document document;
            if (element != null && (document = PsiDocumentManager.getInstance((Project)project).getDocument(element.getContainingFile())) != null) {
                return document.getLineNumber(element.getTextOffset());
            }
            return -1;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 25: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 25: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssue";
                break;
            }
            case 1: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 6: 
            case 14: 
            case 18: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssues";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleMap";
                break;
            }
            case 4: 
            case 8: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFileMap";
                break;
            }
            case 5: 
            case 9: 
            case 15: 
            case 21: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedModules";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectBuildModel";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 20: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/SimpleDeduplicatingSyncIssueReporter";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/SimpleDeduplicatingSyncIssueReporter";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleLink";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomLinks";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "setupNotificationData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reportAll";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationDataAndReport";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doCreateModuleLink";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createModuleLink";
                break;
            }
            case 20: 
            case 25: 
            case 31: {
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getCustomLinks";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setupNotificationData";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getLineNumberForElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 25: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

