/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.EnableEmbeddedRepoHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ToggleOfflineModeHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class MissingDependencyErrorHandler
extends SyncErrorHandler {
    private static final Pattern MISSING_MATCHING_DEPENDENCY_PATTERN = Pattern.compile("Could not find any version that matches (.*)\\.");
    public static final Pattern MISSING_DEPENDENCY_PATTERN = Pattern.compile("Could not find (.*)\\.");

    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        Throwable rootCause;
        String text;
        List<String> message;
        if (error == null) {
            MissingDependencyErrorHandler.$$$reportNull$$$0(0);
        }
        if (notification == null) {
            MissingDependencyErrorHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            MissingDependencyErrorHandler.$$$reportNull$$$0(2);
        }
        if ((message = MissingDependencyErrorHandler.getMessageLines(text = (rootCause = this.getRootCause(error)).getMessage())).isEmpty()) {
            return false;
        }
        String firstLine = message.get(0);
        Matcher matcher = MISSING_MATCHING_DEPENDENCY_PATTERN.matcher(firstLine);
        if (matcher.matches()) {
            String dependency = matcher.group(1);
            MissingDependencyErrorHandler.handleMissingDependency(notification, project, firstLine, dependency, Collections.emptyList());
            return true;
        }
        String lastLine = message.get(message.size() - 1);
        matcher = MISSING_DEPENDENCY_PATTERN.matcher(firstLine);
        if (matcher.matches() && message.size() > 1 && message.get(1).startsWith("Required by:")) {
            String dependency = matcher.group(1);
            ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
            if (StringUtil.isNotEmpty((String)dependency)) {
                Pair<String, Integer> errorLocation;
                if (lastLine != null && (errorLocation = MissingDependencyErrorHandler.getErrorLocation(lastLine)) != null) {
                    String filePath = (String)errorLocation.getFirst();
                    int line = (Integer)errorLocation.getSecond();
                    hyperlinks.add(new OpenFileHyperlink(filePath, line - 1));
                }
                MissingDependencyErrorHandler.handleMissingDependency(notification, project, error.getMessage(), dependency, hyperlinks);
                return true;
            }
        }
        for (String line : message) {
            if (line == null || !(matcher = MISSING_MATCHING_DEPENDENCY_PATTERN.matcher(line)).matches()) continue;
            String dependency = matcher.group(1);
            MissingDependencyErrorHandler.handleMissingDependency(notification, project, line, dependency, Collections.emptyList());
            return true;
        }
        return false;
    }

    private static void handleMissingDependency(@NotNull NotificationData notification, @NotNull Project project, @NotNull String msg, @NotNull String dependency, @NotNull List<NotificationHyperlink> additionalHyperlinks) {
        if (notification == null) {
            MissingDependencyErrorHandler.$$$reportNull$$$0(3);
        }
        if (project == null) {
            MissingDependencyErrorHandler.$$$reportNull$$$0(4);
        }
        if (msg == null) {
            MissingDependencyErrorHandler.$$$reportNull$$$0(5);
        }
        if (dependency == null) {
            MissingDependencyErrorHandler.$$$reportNull$$$0(6);
        }
        if (additionalHyperlinks == null) {
            MissingDependencyErrorHandler.$$$reportNull$$$0(7);
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>(additionalHyperlinks);
        ToggleOfflineModeHyperlink disableOfflineMode = ToggleOfflineModeHyperlink.disableOfflineMode(project);
        if (disableOfflineMode != null) {
            hyperlinks.add(0, disableOfflineMode);
        }
        hyperlinks.add(new SearchInBuildFilesHyperlink(dependency));
        if (EnableEmbeddedRepoHyperlink.shouldEnableEmbeddedRepo(dependency)) {
            hyperlinks.add(new EnableEmbeddedRepoHyperlink());
        }
        GradleSyncMessages.getInstance(project).updateNotification(notification, msg, hyperlinks);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalHyperlinks";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/MissingDependencyErrorHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleError";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "handleMissingDependency";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

