/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.builder.model.BaseArtifact;
import com.android.builder.model.TestedTargetVariant;
import com.android.builder.model.Variant;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.build.invoker.GradleRootPathFinder;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class GradleTaskFinder {
    private final GradleRootPathFinder myRootPathFinder;

    @NotNull
    public static GradleTaskFinder getInstance() {
        GradleTaskFinder gradleTaskFinder = (GradleTaskFinder)ServiceManager.getService(GradleTaskFinder.class);
        if (gradleTaskFinder == null) {
            GradleTaskFinder.$$$reportNull$$$0(0);
        }
        return gradleTaskFinder;
    }

    public GradleTaskFinder() {
        this(new GradleRootPathFinder());
    }

    @VisibleForTesting
    GradleTaskFinder(GradleRootPathFinder rootPathFinder) {
        this.myRootPathFinder = rootPathFinder;
    }

    @NotNull
    public ListMultimap<Path, String> findTasksToExecuteForTest(@NotNull File projectPath, @NotNull Module[] modules, @NotNull Module[] testModules, @NotNull BuildMode buildMode, @NotNull TestCompileType testCompileType) {
        if (projectPath == null) {
            GradleTaskFinder.$$$reportNull$$$0(1);
        }
        if (modules == null) {
            GradleTaskFinder.$$$reportNull$$$0(2);
        }
        if (testModules == null) {
            GradleTaskFinder.$$$reportNull$$$0(3);
        }
        if (buildMode == null) {
            GradleTaskFinder.$$$reportNull$$$0(4);
        }
        if (testCompileType == null) {
            GradleTaskFinder.$$$reportNull$$$0(5);
        }
        ListMultimap<Path, String> allTasks = this.findTasksToExecute(projectPath, modules, buildMode, TestCompileType.NONE);
        ListMultimap<Path, String> testedModulesTasks = this.findTasksToExecute(projectPath, testModules, buildMode, testCompileType);
        for (Map.Entry task : testedModulesTasks.entries()) {
            if (allTasks.values().contains(task.getValue())) continue;
            allTasks.put(task.getKey(), task.getValue());
        }
        ListMultimap<Path, String> listMultimap = allTasks;
        if (listMultimap == null) {
            GradleTaskFinder.$$$reportNull$$$0(6);
        }
        return listMultimap;
    }

    @NotNull
    public ListMultimap<Path, String> findTasksToExecute(@NotNull File projectPath, @NotNull Module[] modules, @NotNull BuildMode buildMode, @NotNull TestCompileType testCompileType) {
        if (projectPath == null) {
            GradleTaskFinder.$$$reportNull$$$0(7);
        }
        if (modules == null) {
            GradleTaskFinder.$$$reportNull$$$0(8);
        }
        if (buildMode == null) {
            GradleTaskFinder.$$$reportNull$$$0(9);
        }
        if (testCompileType == null) {
            GradleTaskFinder.$$$reportNull$$$0(10);
        }
        LinkedHashMultimap tasks = LinkedHashMultimap.create();
        if (BuildMode.ASSEMBLE == buildMode && !GradleTaskFinder.canAssembleModules(modules)) {
            tasks.put((Object)projectPath.toPath(), (Object)"assemble");
            ArrayListMultimap arrayListMultimap = ArrayListMultimap.create((Multimap)tasks);
            if (arrayListMultimap == null) {
                GradleTaskFinder.$$$reportNull$$$0(11);
            }
            return arrayListMultimap;
        }
        HashSet<Module> allModules = new HashSet<Module>();
        for (Module module : modules) {
            allModules.addAll(DynamicAppUtils.getModulesToBuild(module));
        }
        for (Module module : allModules) {
            String rootProjectPath;
            if ("buildSrc".equals(module.getName()) || StringUtil.isEmpty((String)(rootProjectPath = this.myRootPathFinder.getProjectRootPath(module)))) continue;
            LinkedHashSet<String> moduleTasks = new LinkedHashSet<String>();
            this.findAndAddGradleBuildTasks(module, buildMode, moduleTasks, testCompileType);
            Path keyPath = Paths.get(rootProjectPath, new String[0]);
            moduleTasks.addAll(tasks.get((Object)keyPath));
            tasks.removeAll((Object)keyPath);
            if (buildMode == BuildMode.REBUILD && !moduleTasks.isEmpty()) {
                tasks.put((Object)keyPath, (Object)"clean");
            }
            tasks.putAll((Object)keyPath, moduleTasks);
        }
        if (tasks.isEmpty()) {
            String format = "Unable to find Gradle tasks for project '%1$s' using BuildMode %2$s";
            GradleTaskFinder.getLogger().info(String.format(format, modules[0].getProject().getName(), buildMode.name()));
        }
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create((Multimap)tasks);
        if (arrayListMultimap == null) {
            GradleTaskFinder.$$$reportNull$$$0(12);
        }
        return arrayListMultimap;
    }

    private static boolean canAssembleModules(@NotNull Module[] modules) {
        if (modules == null) {
            GradleTaskFinder.$$$reportNull$$$0(13);
        }
        if (modules.length == 0) {
            return false;
        }
        Project project = modules[0].getProject();
        return !GradleSyncState.getInstance(project).lastSyncFailed();
    }

    private void findAndAddGradleBuildTasks(@NotNull Module module, @NotNull BuildMode buildMode, @NotNull Set<String> tasks, @NotNull TestCompileType testCompileType) {
        block25: {
            String gradlePath;
            block24: {
                GradleFacet gradleFacet;
                if (module == null) {
                    GradleTaskFinder.$$$reportNull$$$0(14);
                }
                if (buildMode == null) {
                    GradleTaskFinder.$$$reportNull$$$0(15);
                }
                if (tasks == null) {
                    GradleTaskFinder.$$$reportNull$$$0(16);
                }
                if (testCompileType == null) {
                    GradleTaskFinder.$$$reportNull$$$0(17);
                }
                if ((gradleFacet = GradleFacet.getInstance(module)) == null) {
                    return;
                }
                gradlePath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
                if (StringUtil.isEmpty((String)gradlePath)) {
                    String msg = String.format("Module '%1$s' does not have a Gradle path. It is likely that this module was manually added by the user.", module.getName());
                    GradleTaskFinder.getLogger().info(msg);
                    return;
                }
                if (ProjectStructure.getInstance(module.getProject()).getModuleFinder().isCompositeBuild(module)) {
                    String msg = String.format("Module '%1$s' comes from composite build, skip gradle tasks.", module.getName());
                    GradleTaskFinder.getLogger().info(msg);
                    return;
                }
                AndroidFacet androidFacet = AndroidFacet.getInstance(module);
                if (androidFacet == null) break block24;
                JpsAndroidModuleProperties properties = androidFacet.getProperties();
                AndroidModuleModel androidModel = AndroidModuleModel.get(module);
                switch (buildMode) {
                    case CLEAN: 
                    case SOURCE_GEN: {
                        this.addAfterSyncTasks(tasks, gradlePath, properties);
                        if (androidModel != null) {
                            this.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidModel);
                            break;
                        }
                        break block25;
                    }
                    case ASSEMBLE: 
                    case REBUILD: {
                        this.addTaskIfSpecified(tasks, gradlePath, properties.ASSEMBLE_TASK_NAME);
                        if (testCompileType != TestCompileType.ALL && androidModel != null) {
                            for (BaseArtifact baseArtifact : testCompileType.getArtifacts(androidModel.getSelectedVariant())) {
                                this.addTaskIfSpecified(tasks, gradlePath, baseArtifact.getAssembleTaskName());
                            }
                        }
                        this.addAssembleTasksForTargetVariants(tasks, module);
                        break;
                    }
                    case BUNDLE: {
                        if (androidModel != null && androidModel.getAndroidProject().getProjectType() == 0) {
                            String taskName = androidModel.getSelectedVariant().getMainArtifact().getBundleTaskName();
                            this.addTaskIfSpecified(tasks, gradlePath, taskName);
                            break;
                        }
                        break block25;
                    }
                    case APK_FROM_BUNDLE: {
                        if (androidModel != null && androidModel.getAndroidProject().getProjectType() == 0) {
                            String taskName = androidModel.getSelectedVariant().getMainArtifact().getApkFromBundleTaskName();
                            this.addTaskIfSpecified(tasks, gradlePath, taskName);
                            break;
                        }
                        break block25;
                    }
                    default: {
                        this.addAfterSyncTasks(tasks, gradlePath, properties);
                        if (androidModel != null) {
                            this.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidModel);
                            for (BaseArtifact baseArtifact : testCompileType.getArtifacts(androidModel.getSelectedVariant())) {
                                this.addTaskIfSpecified(tasks, gradlePath, baseArtifact.getCompileTaskName());
                            }
                        }
                        if (testCompileType != TestCompileType.UNIT_TESTS) {
                            this.addTaskIfSpecified(tasks, gradlePath, properties.COMPILE_JAVA_TASK_NAME);
                            break;
                        }
                        break block25;
                    }
                }
                break block25;
            }
            JavaFacet javaFacet = JavaFacet.getInstance(module);
            if (javaFacet != null && ((JavaFacetConfiguration)javaFacet.getConfiguration()).BUILDABLE) {
                String gradleTaskName = javaFacet.getGradleTaskName(buildMode);
                if (gradleTaskName != null) {
                    tasks.add(this.createBuildTask(gradlePath, gradleTaskName));
                }
                if (TestCompileType.UNIT_TESTS.equals(testCompileType) || TestCompileType.ALL.equals(testCompileType)) {
                    tasks.add(this.createBuildTask(gradlePath, "testClasses"));
                }
            }
        }
    }

    private void addAssembleTasksForTargetVariants(@NotNull Set<String> tasks, @NotNull Module testOnlyModule) {
        AndroidModuleModel testAndroidModel;
        if (tasks == null) {
            GradleTaskFinder.$$$reportNull$$$0(18);
        }
        if (testOnlyModule == null) {
            GradleTaskFinder.$$$reportNull$$$0(19);
        }
        if ((testAndroidModel = AndroidModuleModel.get(testOnlyModule)) == null || !testAndroidModel.getFeatures().isTestedTargetVariantsSupported() || testAndroidModel.getAndroidProject().getProjectType() != 2) {
            return;
        }
        for (TestedTargetVariant testedTargetVariant : testAndroidModel.getSelectedVariant().getTestedTargetVariants()) {
            String targetVariantName;
            Variant targetVariant;
            AndroidModuleModel targetAndroidModel;
            String targetProjectGradlePath = testedTargetVariant.getTargetProjectPath();
            Module targetModule = GradleUtil.findModuleByGradlePath(testOnlyModule.getProject(), targetProjectGradlePath);
            if (targetModule == null || (targetAndroidModel = AndroidModuleModel.get(targetModule)) == null || (targetVariant = targetAndroidModel.findVariantByName(targetVariantName = testedTargetVariant.getTargetVariant())) == null) continue;
            this.addTaskIfSpecified(tasks, targetProjectGradlePath, targetVariant.getMainArtifact().getAssembleTaskName());
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(GradleTaskFinder.class);
        if (logger == null) {
            GradleTaskFinder.$$$reportNull$$$0(20);
        }
        return logger;
    }

    private void addAfterSyncTasksForTestArtifacts(@NotNull Set<String> tasks, @NotNull String gradlePath, @NotNull TestCompileType testCompileType, @NotNull AndroidModuleModel androidModel) {
        if (tasks == null) {
            GradleTaskFinder.$$$reportNull$$$0(21);
        }
        if (gradlePath == null) {
            GradleTaskFinder.$$$reportNull$$$0(22);
        }
        if (testCompileType == null) {
            GradleTaskFinder.$$$reportNull$$$0(23);
        }
        if (androidModel == null) {
            GradleTaskFinder.$$$reportNull$$$0(24);
        }
        IdeVariant variant = androidModel.getSelectedVariant();
        Collection<IdeBaseArtifact> testArtifacts = testCompileType.getArtifacts(variant);
        for (IdeBaseArtifact artifact : testArtifacts) {
            for (String taskName : artifact.getIdeSetupTaskNames()) {
                this.addTaskIfSpecified(tasks, gradlePath, taskName);
            }
        }
    }

    private void addAfterSyncTasks(@NotNull Set<String> tasks, @NotNull String gradlePath, @NotNull JpsAndroidModuleProperties properties) {
        if (tasks == null) {
            GradleTaskFinder.$$$reportNull$$$0(25);
        }
        if (gradlePath == null) {
            GradleTaskFinder.$$$reportNull$$$0(26);
        }
        if (properties == null) {
            GradleTaskFinder.$$$reportNull$$$0(27);
        }
        for (String taskName : properties.AFTER_SYNC_TASK_NAMES) {
            this.addTaskIfSpecified(tasks, gradlePath, taskName);
        }
    }

    private void addTaskIfSpecified(@NotNull Set<String> tasks, @NotNull String gradlePath, @Nullable String gradleTaskName) {
        if (tasks == null) {
            GradleTaskFinder.$$$reportNull$$$0(28);
        }
        if (gradlePath == null) {
            GradleTaskFinder.$$$reportNull$$$0(29);
        }
        if (StringUtil.isNotEmpty((String)gradleTaskName)) {
            String buildTask = this.createBuildTask(gradlePath, gradleTaskName);
            tasks.add(buildTask);
        }
    }

    @NotNull
    public String createBuildTask(@NotNull String gradleProjectPath, @NotNull String taskName) {
        if (gradleProjectPath == null) {
            GradleTaskFinder.$$$reportNull$$$0(30);
        }
        if (taskName == null) {
            GradleTaskFinder.$$$reportNull$$$0(31);
        }
        if (gradleProjectPath.equals(":")) {
            String string = gradleProjectPath + taskName;
            if (string == null) {
                GradleTaskFinder.$$$reportNull$$$0(32);
            }
            return string;
        }
        String string = gradleProjectPath + ":" + taskName;
        if (string == null) {
            GradleTaskFinder.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/GradleTaskFinder";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 2: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testModules";
                break;
            }
            case 4: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildMode";
                break;
            }
            case 5: 
            case 10: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCompileType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 16: 
            case 18: 
            case 21: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testOnlyModule";
                break;
            }
            case 22: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectPath";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleTaskFinder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasksToExecuteForTest";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasksToExecute";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildTask";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTasksToExecuteForTest";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findTasksToExecute";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canAssembleModules";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findAndAddGradleBuildTasks";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addAssembleTasksForTargetVariants";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addAfterSyncTasksForTestArtifacts";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addAfterSyncTasks";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addTaskIfSpecified";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createBuildTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

