/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.AndroidNotification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class SupportedModuleChecker {
    @NotNull
    public static SupportedModuleChecker getInstance() {
        SupportedModuleChecker supportedModuleChecker = (SupportedModuleChecker)ServiceManager.getService(SupportedModuleChecker.class);
        if (supportedModuleChecker == null) {
            SupportedModuleChecker.$$$reportNull$$$0(0);
        }
        return supportedModuleChecker;
    }

    public void checkForSupportedModules(@NotNull Project project) {
        Module[] modules;
        if (project == null) {
            SupportedModuleChecker.$$$reportNull$$$0(1);
        }
        if ((modules = ModuleManager.getInstance((Project)project).getModules()).length == 0 || !GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            return;
        }
        ArrayList<Module> unsupportedModules = new ArrayList<Module>();
        boolean androidGradleSeen = false;
        for (Module module : modules) {
            ModuleType moduleType = ModuleType.get((Module)module);
            if (!(moduleType instanceof JavaModuleType)) continue;
            String externalSystemId = module.getOptionValue("external.system.id");
            if (!GradleUtil.GRADLE_SYSTEM_ID.getId().equals(externalSystemId)) {
                unsupportedModules.add(module);
                continue;
            }
            if (!GradleFacet.isAppliedTo(module)) continue;
            androidGradleSeen = true;
        }
        if (!androidGradleSeen || unsupportedModules.isEmpty()) {
            return;
        }
        String moduleNames = StringUtil.join(unsupportedModules, Module::getName, (String)", ");
        String text = "Compilation is not supported for following modules: " + moduleNames + ". Unfortunately you can't have non-Gradle Java modules and Android-Gradle modules in one project.";
        AndroidNotification.getInstance(project).showBalloon("Unsupported Modules Detected", text, NotificationType.ERROR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/SupportedModuleChecker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/SupportedModuleChecker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkForSupportedModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

