/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.ng.nosyncbuilder.misc.NewProjectExtraInfo;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.collect.ImmutableList;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleProjectInfo {
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidProjectInfo myProjectInfo;
    @NotNull
    private final ProjectFileIndex myProjectFileIndex;
    private volatile boolean myNewProject;
    @Nullable
    private NewProjectExtraInfo myExtraInfo;
    private volatile boolean myImportedProject;
    private final ProjectFacetManager myFacetManager;
    private volatile boolean mySkipStartupActivity;

    @NotNull
    public static GradleProjectInfo getInstance(@NotNull Project project) {
        if (project == null) {
            GradleProjectInfo.$$$reportNull$$$0(0);
        }
        GradleProjectInfo gradleProjectInfo = (GradleProjectInfo)ServiceManager.getService((Project)project, GradleProjectInfo.class);
        if (gradleProjectInfo == null) {
            GradleProjectInfo.$$$reportNull$$$0(1);
        }
        return gradleProjectInfo;
    }

    public GradleProjectInfo(@NotNull Project project, @NotNull AndroidProjectInfo projectInfo, @NotNull ProjectFileIndex projectFileIndex) {
        if (project == null) {
            GradleProjectInfo.$$$reportNull$$$0(2);
        }
        if (projectInfo == null) {
            GradleProjectInfo.$$$reportNull$$$0(3);
        }
        if (projectFileIndex == null) {
            GradleProjectInfo.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myProjectInfo = projectInfo;
        this.myProjectFileIndex = projectFileIndex;
        this.myFacetManager = ProjectFacetManager.getInstance((Project)this.myProject);
    }

    public boolean isNewProject() {
        return this.myNewProject;
    }

    public void setNewProject(boolean newProject) {
        this.myNewProject = newProject;
    }

    public boolean isSkipStartupActivity() {
        return this.mySkipStartupActivity;
    }

    public void setSkipStartupActivity(boolean skipStartupActivity) {
        this.mySkipStartupActivity = skipStartupActivity;
    }

    @Nullable
    public NewProjectExtraInfo getExtraInfo() {
        return this.myExtraInfo;
    }

    public void setExtraInfo(@Nullable NewProjectExtraInfo extraInfo) {
        this.myExtraInfo = extraInfo;
    }

    public boolean isImportedProject() {
        return this.myImportedProject;
    }

    public void setImportedProject(boolean importedProject) {
        this.myImportedProject = importedProject;
    }

    public boolean isDirectGradleBuildEnabled() {
        AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(this.myProject);
        return buildConfiguration.USE_EXPERIMENTAL_FASTER_BUILD;
    }

    public boolean isBuildWithGradle() {
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return false;
            }
            if (this.myFacetManager.hasFacets(GradleFacet.getFacetTypeId())) {
                return true;
            }
            if (GradleSyncState.getInstance(this.myProject).getSummary().getSyncTimestamp() != -1L) {
                return true;
            }
            return this.hasTopLevelGradleBuildFile();
        });
    }

    public boolean hasGradleFacets() {
        return this.myFacetManager.hasFacets(GradleFacet.getFacetTypeId());
    }

    public boolean hasTopLevelGradleBuildFile() {
        if (this.myProject.isDefault()) {
            return false;
        }
        VirtualFile baseDir = this.myProject.getBaseDir();
        VirtualFile buildGradle = baseDir == null ? null : baseDir.findChild("build.gradle");
        return buildGradle != null && !buildGradle.isDirectory();
    }

    @NotNull
    public List<Module> getAndroidModules() {
        ImmutableList.Builder modules = ImmutableList.builder();
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                if (AndroidFacet.getInstance(module) == null || GradleFacet.getInstance(module) == null) continue;
                modules.add((Object)module);
            }
        });
        ImmutableList immutableList = modules.build();
        if (immutableList == null) {
            GradleProjectInfo.$$$reportNull$$$0(5);
        }
        return immutableList;
    }

    public void forEachAndroidModule(@NotNull Consumer<AndroidFacet> consumer) {
        if (consumer == null) {
            GradleProjectInfo.$$$reportNull$$$0(6);
        }
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                AndroidFacet androidFacet = AndroidFacet.getInstance(module);
                if (androidFacet == null || GradleFacet.getInstance(module) == null) continue;
                consumer.consume((Object)androidFacet);
            }
        });
    }

    @Nullable
    public AndroidModuleModel findAndroidModelInModule(@NotNull VirtualFile file) {
        if (file == null) {
            GradleProjectInfo.$$$reportNull$$$0(7);
        }
        return this.findAndroidModelInModule(file, true);
    }

    @Nullable
    public AndroidModuleModel findAndroidModelInModule(@NotNull VirtualFile file, boolean honorExclusion) {
        Module module;
        if (file == null) {
            GradleProjectInfo.$$$reportNull$$$0(8);
        }
        if ((module = this.findModuleForFile(file, honorExclusion)) == null) {
            VirtualFile rootFolder;
            if (this.myProjectInfo.requiresAndroidModel() && (rootFolder = this.myProject.getBaseDir()) != null) {
                for (VirtualFile parent = file.getParent(); parent != null && parent.equals(rootFolder) && (module = this.findModuleForFile(file, honorExclusion)) == null; parent = parent.getParent()) {
                }
            }
            if (module == null) {
                return null;
            }
        }
        if (module.isDisposed()) {
            this.getLog().warn("Attempted to get an Android Facet from a disposed module");
            return null;
        }
        return AndroidModuleModel.get(module);
    }

    @Nullable
    private Module findModuleForFile(@NotNull VirtualFile file, boolean honorExclusion) {
        if (file == null) {
            GradleProjectInfo.$$$reportNull$$$0(9);
        }
        return this.myProjectFileIndex.getModuleForFile(file, honorExclusion);
    }

    @NotNull
    public Module[] getModulesToBuildFromSelection(@Nullable DataContext dataContext) {
        Module[] modules;
        if (dataContext == null) {
            ProjectView projectView = ProjectView.getInstance((Project)this.myProject);
            AbstractProjectViewPane pane = projectView.getCurrentProjectViewPane();
            if (pane != null) {
                JComponent treeComponent = pane.getComponentToFocus();
                dataContext = DataManager.getInstance().getDataContext((Component)treeComponent);
            } else {
                if (Module.EMPTY_ARRAY == null) {
                    GradleProjectInfo.$$$reportNull$$$0(10);
                }
                return Module.EMPTY_ARRAY;
            }
        }
        if ((modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext)) != null) {
            if (modules.length == 1 && GradleProjectInfo.isProjectModule(modules[0])) {
                Module[] moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
                if (moduleArray == null) {
                    GradleProjectInfo.$$$reportNull$$$0(11);
                }
                return moduleArray;
            }
            if (modules == null) {
                GradleProjectInfo.$$$reportNull$$$0(12);
            }
            return modules;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module != null) {
            Module[] moduleArray;
            if (GradleProjectInfo.isProjectModule(module)) {
                moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
            } else {
                Module[] moduleArray2 = new Module[1];
                moduleArray = moduleArray2;
                moduleArray2[0] = module;
            }
            if (moduleArray == null) {
                GradleProjectInfo.$$$reportNull$$$0(13);
            }
            return moduleArray;
        }
        if (Module.EMPTY_ARRAY == null) {
            GradleProjectInfo.$$$reportNull$$$0(14);
        }
        return Module.EMPTY_ARRAY;
    }

    private static boolean isProjectModule(@NotNull Module module) {
        File moduleRootFolderPath;
        if (module == null) {
            GradleProjectInfo.$$$reportNull$$$0(15);
        }
        if ((moduleRootFolderPath = GradleProjects.findModuleRootFolderPath(module)) == null) {
            return false;
        }
        String basePath = module.getProject().getBasePath();
        return basePath != null && FileUtil.filesEqual((File)moduleRootFolderPath, (File)new File(basePath)) && !GradleFacet.isAppliedTo(module);
    }

    @NotNull
    private Logger getLog() {
        Logger logger = Logger.getInstance(this.getClass());
        if (logger == null) {
            GradleProjectInfo.$$$reportNull$$$0(16);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/GradleProjectInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFileIndex";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/GradleProjectInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidModules";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesToBuildFromSelection";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forEachAndroidModule";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findAndroidModelInModule";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findModuleForFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isProjectModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

