/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.LegacyAndroidProjects;
import com.android.tools.idea.gradle.project.SupportedModuleChecker;
import com.android.tools.idea.gradle.project.build.GradleBuildContext;
import com.android.tools.idea.gradle.project.build.JpsBuildContext;
import com.android.tools.idea.gradle.project.build.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.project.AndroidProjectBuildNotifications;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.RunConfigurationProducerService;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.AllInPackageGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestClassGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestMethodGradleConfigurationProducer;

public final class AndroidGradleProjectComponent
implements ProjectComponent {
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final AndroidProjectInfo myAndroidProjectInfo;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final LegacyAndroidProjects myLegacyAndroidProjects;
    @Nullable
    private Disposable myDisposable;
    private final Project myProject;

    @NotNull
    public static AndroidGradleProjectComponent getInstance(@NotNull Project project) {
        if (project == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(0);
        }
        AndroidGradleProjectComponent component = (AndroidGradleProjectComponent)project.getComponent(AndroidGradleProjectComponent.class);
        assert (component != null);
        AndroidGradleProjectComponent androidGradleProjectComponent = component;
        if (androidGradleProjectComponent == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(1);
        }
        return androidGradleProjectComponent;
    }

    public AndroidGradleProjectComponent(@NotNull Project project, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull AndroidProjectInfo androidProjectInfo, @NotNull GradleSyncInvoker gradleSyncInvoker, @NotNull GradleBuildInvoker gradleBuildInvoker, @NotNull CompilerManager compilerManager, @NotNull SupportedModuleChecker supportedModuleChecker, @NotNull IdeInfo ideInfo) {
        if (project == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(2);
        }
        if (gradleProjectInfo == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(3);
        }
        if (androidProjectInfo == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(4);
        }
        if (gradleSyncInvoker == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(5);
        }
        if (gradleBuildInvoker == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(6);
        }
        if (compilerManager == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(7);
        }
        if (supportedModuleChecker == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(8);
        }
        if (ideInfo == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(9);
        }
        this(project, gradleProjectInfo, androidProjectInfo, gradleBuildInvoker, compilerManager, ideInfo, new LegacyAndroidProjects(project));
    }

    @VisibleForTesting
    public AndroidGradleProjectComponent(@NotNull Project project, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull AndroidProjectInfo androidProjectInfo, @NotNull GradleBuildInvoker gradleBuildInvoker, @NotNull CompilerManager compilerManager, @NotNull IdeInfo ideInfo, @NotNull LegacyAndroidProjects legacyAndroidProjects) {
        if (project == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(10);
        }
        if (gradleProjectInfo == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(11);
        }
        if (androidProjectInfo == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(12);
        }
        if (gradleBuildInvoker == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(13);
        }
        if (compilerManager == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(14);
        }
        if (ideInfo == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(15);
        }
        if (legacyAndroidProjects == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(16);
        }
        this.myProject = project;
        this.myGradleProjectInfo = gradleProjectInfo;
        this.myAndroidProjectInfo = androidProjectInfo;
        this.myIdeInfo = ideInfo;
        this.myLegacyAndroidProjects = legacyAndroidProjects;
        compilerManager.addAfterTask(context -> {
            if (this.myGradleProjectInfo.isBuildWithGradle()) {
                PostProjectBuildTasksExecutor.getInstance(project).onBuildCompletion(context);
                JpsBuildContext newContext = new JpsBuildContext(context);
                AndroidProjectBuildNotifications.getInstance(this.myProject).notifyBuildComplete(newContext);
            }
            return true;
        });
        gradleBuildInvoker.add(result2 -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            PostProjectBuildTasksExecutor.getInstance(this.myProject).onBuildCompletion(result2);
            GradleBuildContext newContext = new GradleBuildContext(result2);
            AndroidProjectBuildNotifications.getInstance(this.myProject).notifyBuildComplete(newContext);
            if (AndroidGradleProjectComponent.isVfsRefreshAfterBuildRequired(this.myProject)) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    FileDocumentManager.getInstance().saveAllDocuments();
                    SaveAndSyncHandler.getInstance().refreshOpenFiles();
                    VirtualFileManager.getInstance().refreshWithoutFileWatcher(true);
                });
            }
        });
    }

    private static boolean isVfsRefreshAfterBuildRequired(@NotNull Project project) {
        if (project == null) {
            AndroidGradleProjectComponent.$$$reportNull$$$0(17);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module);
            if (androidModuleModel == null || !androidModuleModel.getFeatures().isVfsRefreshAfterBuildRequired()) continue;
            return true;
        }
        return false;
    }

    public void projectOpened() {
        if (this.myIdeInfo.isAndroidStudio() && this.myAndroidProjectInfo.isLegacyIdeaAndroidProject() && !this.myAndroidProjectInfo.isApkProject()) {
            this.myLegacyAndroidProjects.trackProject();
            if (!this.myGradleProjectInfo.isBuildWithGradle()) {
                this.myLegacyAndroidProjects.showMigrateToGradleWarning();
            }
        }
    }

    public void configureGradleProject() {
        if (this.myDisposable != null) {
            return;
        }
        this.myDisposable = Disposer.newDisposable();
        if (IdeInfo.getInstance().isAndroidStudio()) {
            this.myProject.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)Boolean.TRUE);
        }
        ArrayList<Class<TestMethodGradleConfigurationProducer>> runConfigurationProducerTypes = new ArrayList<Class<TestMethodGradleConfigurationProducer>>();
        runConfigurationProducerTypes.add(AllInPackageGradleConfigurationProducer.class);
        runConfigurationProducerTypes.add(TestClassGradleConfigurationProducer.class);
        runConfigurationProducerTypes.add(TestMethodGradleConfigurationProducer.class);
        RunConfigurationProducerService runConfigurationProducerManager = RunConfigurationProducerService.getInstance((Project)this.myProject);
        if (this.myIdeInfo.isAndroidStudio()) {
            for (Class clazz : runConfigurationProducerTypes) {
                runConfigurationProducerManager.getState().ignoredProducers.add(clazz.getName());
            }
        } else {
            for (Class clazz : runConfigurationProducerTypes) {
                runConfigurationProducerManager.getState().ignoredProducers.remove(clazz.getName());
            }
        }
    }

    public void projectClosed() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectInfo";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProjectInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleSyncInvoker";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleBuildInvoker";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedModuleChecker";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideInfo";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "legacyAndroidProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isVfsRefreshAfterBuildRequired";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

