/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.notification;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.sync.GradleFiles;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectSyncStatusNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    @NotNull
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.gradle.sync.status");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(3);
        }
        NotificationPanel oldPanel = (NotificationPanel)((Object)fileEditor.getUserData(this.getKey()));
        NotificationPanel.Type newPanelType = this.notificationPanelType(project);
        if (oldPanel != null) {
            if (oldPanel.type == newPanelType) {
                return oldPanel;
            }
            if (oldPanel instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)oldPanel));
            }
        }
        return newPanelType.create(project);
    }

    @VisibleForTesting
    @NotNull
    NotificationPanel.Type notificationPanelType(@NotNull Project project) {
        if (project == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(4);
        }
        if (!GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            NotificationPanel.Type type = NotificationPanel.Type.NONE;
            if (type == null) {
                ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(5);
            }
            return type;
        }
        NotificationPanel.Type type = this.notificationPanelType(GradleSyncState.getInstance(project));
        if (type == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(6);
        }
        return type;
    }

    @NotNull
    NotificationPanel.Type notificationPanelType(@NotNull GradleSyncState syncState) {
        if (syncState == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(7);
        }
        if (!syncState.areSyncNotificationsEnabled()) {
            NotificationPanel.Type type = NotificationPanel.Type.NONE;
            if (type == null) {
                ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(8);
            }
            return type;
        }
        if (syncState.isSyncInProgress()) {
            NotificationPanel.Type type = NotificationPanel.Type.IN_PROGRESS;
            if (type == null) {
                ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(9);
            }
            return type;
        }
        if (syncState.lastSyncFailed()) {
            NotificationPanel.Type type = NotificationPanel.Type.FAILED;
            if (type == null) {
                ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(10);
            }
            return type;
        }
        ThreeState gradleSyncNeeded = syncState.isSyncNeeded();
        if (gradleSyncNeeded == ThreeState.YES) {
            NotificationPanel.Type type = NotificationPanel.Type.SYNC_NEEDED;
            if (type == null) {
                ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(11);
            }
            return type;
        }
        NotificationPanel.Type type = NotificationPanel.Type.NONE;
        if (type == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(12);
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "notificationPanelType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notificationPanelType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SyncProblemNotificationPanel
    extends IndexingSensitiveNotificationPanel {
        SyncProblemNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text) {
            if (project == null) {
                SyncProblemNotificationPanel.$$$reportNull$$$0(0);
            }
            if (type == null) {
                SyncProblemNotificationPanel.$$$reportNull$$$0(1);
            }
            if (text == null) {
                SyncProblemNotificationPanel.$$$reportNull$$$0(2);
            }
            super(project, type, text);
            this.createActionLabel("Try Again", () -> GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_USER_REQUEST));
            this.createActionLabel("Open 'Build' View", () -> {
                ToolWindow tw = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.BUILD);
                if (tw != null && !tw.isActive()) {
                    tw.activate(null, false);
                }
            });
            this.createActionLabel("Show Log in " + ShowFilePathAction.getFileManagerName(), () -> {
                File logFile = new File(PathManager.getLogPath(), "idea.log");
                ShowFilePathAction.openFile((File)logFile);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$SyncProblemNotificationPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StaleGradleModelNotificationPanel
    extends IndexingSensitiveNotificationPanel {
        StaleGradleModelNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text) {
            if (project == null) {
                StaleGradleModelNotificationPanel.$$$reportNull$$$0(0);
            }
            if (type == null) {
                StaleGradleModelNotificationPanel.$$$reportNull$$$0(1);
            }
            if (text == null) {
                StaleGradleModelNotificationPanel.$$$reportNull$$$0(2);
            }
            super(project, type, text);
            this.createActionLabel("Sync Now", () -> GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_USER_REQUEST));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$StaleGradleModelNotificationPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class IndexingSensitiveNotificationPanel
    extends NotificationPanel
    implements Disposable {
        private final DumbService myDumbService;

        IndexingSensitiveNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text) {
            if (project == null) {
                IndexingSensitiveNotificationPanel.$$$reportNull$$$0(0);
            }
            if (type == null) {
                IndexingSensitiveNotificationPanel.$$$reportNull$$$0(1);
            }
            if (text == null) {
                IndexingSensitiveNotificationPanel.$$$reportNull$$$0(2);
            }
            this(project, type, text, DumbService.getInstance((Project)project));
        }

        @VisibleForTesting
        IndexingSensitiveNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text, @NotNull DumbService dumbService) {
            if (project == null) {
                IndexingSensitiveNotificationPanel.$$$reportNull$$$0(3);
            }
            if (type == null) {
                IndexingSensitiveNotificationPanel.$$$reportNull$$$0(4);
            }
            if (text == null) {
                IndexingSensitiveNotificationPanel.$$$reportNull$$$0(5);
            }
            if (dumbService == null) {
                IndexingSensitiveNotificationPanel.$$$reportNull$$$0(6);
            }
            super(type, text);
            this.myDumbService = dumbService;
            Disposer.register((Disposable)project, (Disposable)this);
            MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
            connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void enteredDumbMode() {
                    this.setVisible(false);
                }

                public void exitDumbMode() {
                    this.setVisible(true);
                }
            });
            this.setVisible(!this.myDumbService.isDumb());
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dumbService";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$IndexingSensitiveNotificationPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class NotificationPanel
    extends EditorNotificationPanel {
        @NotNull
        private final Type type;

        NotificationPanel(@NotNull Type type, @NotNull String text) {
            if (type == null) {
                NotificationPanel.$$$reportNull$$$0(0);
            }
            if (text == null) {
                NotificationPanel.$$$reportNull$$$0(1);
            }
            this.type = type;
            this.setText(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static enum Type {
            NONE{

                @Override
                @Nullable
                NotificationPanel create(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$1", "create"));
                }
            }
            ,
            IN_PROGRESS{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project) {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    NotificationPanel notificationPanel = new NotificationPanel(this, "Gradle project sync in progress...");
                    if (notificationPanel == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return notificationPanel;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "create";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "create";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }
            ,
            FAILED{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project) {
                    if (project == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    String text = "Gradle project sync failed. Basic functionality (e.g. editing, debugging) will not work properly.";
                    SyncProblemNotificationPanel syncProblemNotificationPanel = new SyncProblemNotificationPanel(project, this, text);
                    if (syncProblemNotificationPanel == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return syncProblemNotificationPanel;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$3";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$3";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "create";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "create";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }
            ,
            SYNC_NEEDED{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project) {
                    if (project == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    boolean buildFilesModified = GradleFiles.getInstance(project).areExternalBuildFilesModified();
                    String text = (buildFilesModified ? "External build files" : "Gradle files") + " have changed since last project sync. A project sync may be necessary for the IDE to work properly.";
                    StaleGradleModelNotificationPanel staleGradleModelNotificationPanel = new StaleGradleModelNotificationPanel(project, this, text);
                    if (staleGradleModelNotificationPanel == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return staleGradleModelNotificationPanel;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$4";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$4";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "create";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "create";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };


            @Nullable
            abstract NotificationPanel create(@NotNull Project var1);
        }
    }
}

