/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.parser;

import com.android.tools.idea.gradle.editor.entity.GradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorSourceBinding;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelParseContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleEditorModelUtil {
    public static final List<String> EXTRA_PROPERTIES_QUALIFIER = Collections.singletonList("ext");
    private static final Logger LOG = Logger.getInstance(GradleEditorModelUtil.class);

    private GradleEditorModelUtil() {
    }

    @Nullable
    public static GradleEditorSourceBinding buildSourceBinding(@NotNull GradleEditorModelParseContext.Assignment assignment, @NotNull Project project) {
        if (assignment == null) {
            GradleEditorModelUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleEditorModelUtil.$$$reportNull$$$0(1);
        }
        return GradleEditorModelUtil.buildSourceBinding(new GradleEditorModelParseContext.Location(assignment.lValueLocation.file, assignment.assignmentRange), project);
    }

    @Nullable
    public static GradleEditorSourceBinding buildSourceBinding(@NotNull GradleEditorModelParseContext.Location location, @NotNull Project project) {
        FileDocumentManager fileDocumentManager;
        Document document;
        if (location == null) {
            GradleEditorModelUtil.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GradleEditorModelUtil.$$$reportNull$$$0(3);
        }
        if ((document = (fileDocumentManager = FileDocumentManager.getInstance()).getDocument(location.file)) == null) {
            LOG.warn(String.format("Can't obtain a document for file %s for processing location '%s'", location.file, location));
            return null;
        }
        RangeMarker rangeMarker = document.createRangeMarker(location.range);
        return new GradleEditorSourceBinding(project, location.file, rangeMarker);
    }

    public static boolean isVariable(@NotNull String targetText, @NotNull String variableName) {
        String targetTextToUse;
        if (targetText == null) {
            GradleEditorModelUtil.$$$reportNull$$$0(4);
        }
        if (variableName == null) {
            GradleEditorModelUtil.$$$reportNull$$$0(5);
        }
        if ((targetTextToUse = GradleEditorModelUtil.unquote(targetText)).equals(variableName) && targetText.equals(targetTextToUse)) {
            return true;
        }
        if (targetTextToUse.equals("$" + variableName)) {
            return true;
        }
        return targetTextToUse.equals("${" + variableName + "}");
    }

    @NotNull
    public static String unquote(@NotNull String s) {
        if (s == null) {
            GradleEditorModelUtil.$$$reportNull$$$0(6);
        }
        String string = StringUtil.unquoteString((String)StringUtil.unquoteString((String)s, (char)'\''), (char)'\"');
        if (string == null) {
            GradleEditorModelUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static TextRange interestedRange(@NotNull PsiElement element) {
        if (element == null) {
            GradleEditorModelUtil.$$$reportNull$$$0(8);
        }
        String text = GradleEditorModelUtil.unquote(element.getText());
        int shift = element.getText().indexOf(text);
        TextRange result2 = element.getTextRange();
        if (shift > 0) {
            result2 = TextRange.create((int)(result2.getStartOffset() + shift), (int)(result2.getStartOffset() + shift + text.length()));
        }
        TextRange textRange = result2;
        if (textRange == null) {
            GradleEditorModelUtil.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    @NotNull
    public static EntityInfo collectInfo(@NotNull Collection<GradleEditorModelParseContext.Variable> variables, @NotNull GradleEditorModelParseContext context, @Nullable AssignmentFilter filter2) {
        if (variables == null) {
            GradleEditorModelUtil.$$$reportNull$$$0(10);
        }
        if (context == null) {
            GradleEditorModelUtil.$$$reportNull$$$0(11);
        }
        HashSet processed = Sets.newHashSet();
        Stack<GradleEditorModelParseContext.Variable> toProcess = new Stack<GradleEditorModelParseContext.Variable>();
        toProcess.addAll(variables);
        ArrayList sourceBindings = Lists.newArrayList();
        String value2 = "";
        boolean skipValue = false;
        ArrayList assignments = Lists.newArrayList();
        while (!toProcess.isEmpty()) {
            GradleEditorModelParseContext.Variable dependency = (GradleEditorModelParseContext.Variable)toProcess.pop();
            if (!processed.add(dependency)) continue;
            assignments.clear();
            assignments.addAll(context.getAssignments(dependency));
            if (dependency.qualifier.isEmpty()) {
                assignments.addAll(context.getAssignments(new GradleEditorModelParseContext.Variable(dependency.name, EXTRA_PROPERTIES_QUALIFIER)));
            }
            Iterator iterator = assignments.iterator();
            while (iterator.hasNext()) {
                GradleEditorModelParseContext.Assignment a;
                GradleEditorModelParseContext.Assignment assignmentToUse = a = (GradleEditorModelParseContext.Assignment)iterator.next();
                if (filter2 != null) {
                    assignmentToUse = filter2.check(a);
                }
                if (assignmentToUse == null) continue;
                Set dependencies = assignmentToUse.dependencies.keySet();
                if (assignmentToUse.value != null) {
                    sourceBindings.add(GradleEditorModelUtil.buildSourceBinding(assignmentToUse.value.location, context.getProject()));
                    if (value2.isEmpty()) {
                        if (dependencies.size() > 1 || assignmentToUse.rValueString != null && dependencies.size() == 1 && !GradleEditorModelUtil.isVariable(assignmentToUse.rValueString, ((GradleEditorModelParseContext.Variable)dependencies.iterator().next()).name)) {
                            skipValue = true;
                            value2 = "";
                        }
                        if (!skipValue) {
                            value2 = assignmentToUse.value.value;
                        }
                    } else {
                        skipValue = true;
                        value2 = "";
                    }
                }
                toProcess.addAll(dependencies);
            }
        }
        EntityInfo entityInfo = new EntityInfo(sourceBindings, value2);
        if (entityInfo == null) {
            GradleEditorModelUtil.$$$reportNull$$$0(12);
        }
        return entityInfo;
    }

    @Nullable
    public static String removeEntity(@NotNull GradleEditorEntity entity, boolean commit) {
        GradleEditorSourceBinding location;
        RangeMarker marker;
        if (entity == null) {
            GradleEditorModelUtil.$$$reportNull$$$0(13);
        }
        if (!(marker = (location = entity.getEntityLocation()).getRangeMarker()).isValid()) {
            return "source mapping is outdated for entity " + entity;
        }
        Document document = FileDocumentManager.getInstance().getDocument(location.getFile());
        if (document == null) {
            return "can't find a document for file " + location.getFile();
        }
        int startLine = document.getLineNumber(marker.getStartOffset());
        int endLine = document.getLineNumber(marker.getEndOffset());
        CharSequence text = document.getCharsSequence();
        String ws = " \t";
        int start = CharArrayUtil.shiftBackward((CharSequence)text, (int)document.getLineStartOffset(startLine), (int)(marker.getStartOffset() - 1), (String)ws);
        int end = CharArrayUtil.shiftForward((CharSequence)text, (int)marker.getEndOffset(), (int)document.getLineEndOffset(endLine), (String)ws);
        if (start == document.getLineStartOffset(startLine) && startLine > 0) {
            --start;
        } else if (end == document.getLineEndOffset(endLine) && endLine < document.getLineCount() - 1) {
            ++end;
        }
        document.deleteString(start, end);
        if (commit) {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)location.getProject());
            psiDocumentManager.commitDocument(document);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "unquote";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "interestedRange";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildSourceBinding";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isVariable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unquote";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "interestedRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeEntity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class EntityInfo {
        @NotNull
        public final List<GradleEditorSourceBinding> sourceBindings;
        @NotNull
        public final String value;

        public EntityInfo(@NotNull List<GradleEditorSourceBinding> sourceBindings, @NotNull String value2) {
            if (sourceBindings == null) {
                EntityInfo.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                EntityInfo.$$$reportNull$$$0(1);
            }
            this.sourceBindings = sourceBindings;
            this.value = value2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceBindings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/editor/parser/GradleEditorModelUtil$EntityInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface AssignmentFilter {
        @Nullable
        public GradleEditorModelParseContext.Assignment check(@NotNull GradleEditorModelParseContext.Assignment var1);
    }
}

