/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModelImpl;
import com.android.tools.idea.gradle.dsl.parser.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleDslFileCache {
    @NotNull
    private Project myProject;
    @NotNull
    private Map<String, GradleDslFile> myParsedBuildFiles;

    public GradleDslFileCache(@NotNull Project project) {
        if (project == null) {
            GradleDslFileCache.$$$reportNull$$$0(0);
        }
        this.myParsedBuildFiles = new HashMap<String, GradleDslFile>();
        this.myProject = project;
    }

    public void clearAllFiles() {
        this.myParsedBuildFiles.clear();
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file, @NotNull String name, @NotNull BuildModelContext context) {
        GradleDslFile dslFile;
        if (file == null) {
            GradleDslFileCache.$$$reportNull$$$0(1);
        }
        if (name == null) {
            GradleDslFileCache.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GradleDslFileCache.$$$reportNull$$$0(3);
        }
        if ((dslFile = this.myParsedBuildFiles.get(file.getUrl())) == null) {
            dslFile = GradleBuildModelImpl.parseBuildFile(file, this.myProject, name, context);
            this.myParsedBuildFiles.put(file.getUrl(), dslFile);
        } else if (!(dslFile instanceof GradleBuildFile)) {
            throw new IllegalStateException("Found wrong type for build file in cache!");
        }
        GradleBuildFile gradleBuildFile = (GradleBuildFile)dslFile;
        if (gradleBuildFile == null) {
            GradleDslFileCache.$$$reportNull$$$0(4);
        }
        return gradleBuildFile;
    }

    public void putBuildFile(@NotNull String name, @NotNull GradleDslFile buildFile) {
        if (name == null) {
            GradleDslFileCache.$$$reportNull$$$0(5);
        }
        if (buildFile == null) {
            GradleDslFileCache.$$$reportNull$$$0(6);
        }
        this.myParsedBuildFiles.put(name, buildFile);
    }

    @Nullable
    public GradleSettingsFile getSettingsFile(@NotNull Project project) {
        VirtualFile file;
        if (project == null) {
            GradleDslFileCache.$$$reportNull$$$0(7);
        }
        if ((file = GradleUtil.getGradleSettingsFile(Projects.getBaseDirPath((Project)project))) == null) {
            return null;
        }
        GradleDslFile dslFile = this.myParsedBuildFiles.get(file.getUrl());
        if (dslFile != null && !(dslFile instanceof GradleSettingsFile)) {
            throw new IllegalStateException("Found wrong type for settings file in cache!");
        }
        return (GradleSettingsFile)dslFile;
    }

    @Nullable
    public GradleSettingsFile getOrCreateSettingsFile(@NotNull Project project, @NotNull BuildModelContext context) {
        VirtualFile file;
        if (project == null) {
            GradleDslFileCache.$$$reportNull$$$0(8);
        }
        if (context == null) {
            GradleDslFileCache.$$$reportNull$$$0(9);
        }
        if ((file = GradleUtil.getGradleSettingsFile(Projects.getBaseDirPath((Project)project))) == null) {
            return null;
        }
        GradleDslFile dslFile = this.myParsedBuildFiles.get(file.getUrl());
        if (dslFile == null) {
            dslFile = new GradleSettingsFile(file, this.myProject, "settings", context);
            dslFile.parse();
            this.myParsedBuildFiles.put(file.getUrl(), dslFile);
        } else if (!(dslFile instanceof GradleSettingsFile)) {
            throw new IllegalStateException("Found wrong type for settings file in cache!");
        }
        return (GradleSettingsFile)dslFile;
    }

    @NotNull
    public List<GradleDslFile> getAllFiles() {
        ArrayList<GradleDslFile> arrayList = new ArrayList<GradleDslFile>(this.myParsedBuildFiles.values());
        if (arrayList == null) {
            GradleDslFileCache.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/files/GradleDslFileCache";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/files/GradleDslFileCache";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateBuildFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateBuildFile";
                break;
            }
            case 4: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putBuildFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateSettingsFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

