/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleNameElement {
    @NotNull
    public static final Pattern INDEX_PATTERN = Pattern.compile("\\[(.+?)\\]|(.+?)(?=\\[)");
    @NotNull
    private final Pattern SPACES;
    @Nullable
    private PsiElement myNameElement;
    @Nullable
    private String mySavedName;
    @Nullable
    private String myUnsavedName;
    @Nullable
    private String myFakeName;
    @Nullable
    private String myName;

    @NotNull
    public static GradleNameElement from(@NotNull PsiElement element) {
        if (element == null) {
            GradleNameElement.$$$reportNull$$$0(0);
        }
        GradleNameElement gradleNameElement = new GradleNameElement(element);
        if (gradleNameElement == null) {
            GradleNameElement.$$$reportNull$$$0(1);
        }
        return gradleNameElement;
    }

    @NotNull
    public static GradleNameElement empty() {
        GradleNameElement gradleNameElement = new GradleNameElement((PsiElement)null);
        if (gradleNameElement == null) {
            GradleNameElement.$$$reportNull$$$0(2);
        }
        return gradleNameElement;
    }

    @NotNull
    public static GradleNameElement create(@NotNull String name) {
        if (name == null) {
            GradleNameElement.$$$reportNull$$$0(3);
        }
        GradleNameElement gradleNameElement = new GradleNameElement(name, false);
        if (gradleNameElement == null) {
            GradleNameElement.$$$reportNull$$$0(4);
        }
        return gradleNameElement;
    }

    @NotNull
    public static GradleNameElement fake(@NotNull String name) {
        if (name == null) {
            GradleNameElement.$$$reportNull$$$0(5);
        }
        GradleNameElement gradleNameElement = new GradleNameElement(name, true);
        if (gradleNameElement == null) {
            GradleNameElement.$$$reportNull$$$0(6);
        }
        return gradleNameElement;
    }

    @NotNull
    public static GradleNameElement copy(@NotNull GradleNameElement element) {
        if (element == null) {
            GradleNameElement.$$$reportNull$$$0(7);
        }
        GradleNameElement gradleNameElement = new GradleNameElement(element);
        if (gradleNameElement == null) {
            GradleNameElement.$$$reportNull$$$0(8);
        }
        return gradleNameElement;
    }

    private GradleNameElement(@Nullable PsiElement element) {
        this.SPACES = Pattern.compile("\\s+");
        this.myName = null;
        this.setUpFrom(element);
    }

    private GradleNameElement(@NotNull String name, boolean isFake) {
        if (name == null) {
            GradleNameElement.$$$reportNull$$$0(9);
        }
        this.SPACES = Pattern.compile("\\s+");
        this.myName = null;
        if (isFake) {
            this.myFakeName = name;
        } else {
            this.myUnsavedName = name;
        }
    }

    private GradleNameElement(@NotNull GradleNameElement element) {
        if (element == null) {
            GradleNameElement.$$$reportNull$$$0(10);
        }
        this.SPACES = Pattern.compile("\\s+");
        this.myName = null;
        this.mySavedName = element.mySavedName;
        this.myUnsavedName = element.myUnsavedName;
        this.myFakeName = element.myFakeName;
    }

    public void commitNameChange(@Nullable PsiElement nameElement) {
        this.setUpFrom(nameElement);
    }

    @NotNull
    public String fullName() {
        List<String> parts = this.qualifyingParts();
        parts.add(this.name());
        String string = GradleNameElement.createNameFromParts(parts);
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public List<String> fullNameParts() {
        List list = Splitter.on((String)".").splitToList((CharSequence)this.fullName());
        if (list == null) {
            GradleNameElement.$$$reportNull$$$0(12);
        }
        return list;
    }

    public static String createNameFromParts(@NotNull List<String> parts) {
        if (parts == null) {
            GradleNameElement.$$$reportNull$$$0(13);
        }
        return String.join((CharSequence)".", parts);
    }

    @NotNull
    public List<String> qualifyingParts() {
        String name = this.findName();
        if (name == null) {
            ArrayList arrayList = Lists.newArrayList();
            if (arrayList == null) {
                GradleNameElement.$$$reportNull$$$0(14);
            }
            return arrayList;
        }
        List nameSegments = Splitter.on((char)'.').splitToList((CharSequence)name);
        List<String> list = nameSegments.subList(0, nameSegments.size() - 1).stream().map(GradleNameElement::convertNameToKey).collect(Collectors.toList());
        if (list == null) {
            GradleNameElement.$$$reportNull$$$0(15);
        }
        return list;
    }

    public boolean isQualified() {
        String name = this.findName();
        if (name == null) {
            return false;
        }
        return name.contains(".");
    }

    @NotNull
    public String name() {
        String name = this.findName();
        if (name == null) {
            if ("" == null) {
                GradleNameElement.$$$reportNull$$$0(16);
            }
            return "";
        }
        int lastDotIndex = name.lastIndexOf(46) + 1;
        String string = GradleNameElement.convertNameToKey(name.substring(lastDotIndex));
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Nullable
    public PsiElement getNamedPsiElement() {
        return this.myNameElement;
    }

    @Nullable
    public String getUnsavedName() {
        return this.myUnsavedName;
    }

    public void rename(@NotNull String newName2) {
        if (newName2 == null) {
            GradleNameElement.$$$reportNull$$$0(18);
        }
        if (!this.isFake()) {
            this.myUnsavedName = newName2;
        } else {
            this.myFakeName = newName2;
        }
        this.myName = null;
    }

    public boolean isEmpty() {
        String name = this.findName();
        return name == null || name.isEmpty();
    }

    public boolean isFake() {
        return this.myNameElement == null && this.myFakeName != null;
    }

    @NotNull
    public String toString() {
        String string = this.fullName();
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(19);
        }
        return string;
    }

    public boolean containsPropertyReference(@NotNull String propertyReference) {
        String indexName;
        String name;
        if (propertyReference == null) {
            GradleNameElement.$$$reportNull$$$0(20);
        }
        if (propertyReference.equals(name = this.name())) {
            return true;
        }
        Matcher matcher = INDEX_PATTERN.matcher(propertyReference);
        if (matcher.find() && matcher.groupCount() > 0 && (indexName = matcher.group(0)).equals(name)) {
            return true;
        }
        List<String> parts = Arrays.asList(propertyReference.split("\\."));
        if (!parts.isEmpty() && parts.get(0).equals(name)) {
            return true;
        }
        return parts.size() > 1 && parts.get(0).equals("ext") && parts.get(1).equals(name);
    }

    @Nullable
    private String findName() {
        if (this.myName != null) {
            return this.myName;
        }
        String name = null;
        if (this.myUnsavedName != null) {
            name = this.myUnsavedName;
        } else if (this.mySavedName != null) {
            name = this.mySavedName;
        }
        if (name == null && this.myFakeName != null) {
            name = this.myFakeName;
        }
        if (name != null) {
            name = this.SPACES.matcher(name).replaceAll("");
        }
        this.myName = name;
        return name;
    }

    @NotNull
    public static String convertNameToKey(@NotNull String str) {
        if (str == null) {
            GradleNameElement.$$$reportNull$$$0(21);
        }
        String string = StringUtil.unquoteString((String)str);
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(22);
        }
        return string;
    }

    private void setUpFrom(@Nullable PsiElement element) {
        this.myNameElement = element;
        if (this.myNameElement instanceof PsiNamedElement) {
            this.mySavedName = ((PsiNamedElement)this.myNameElement).getName();
        } else if (this.myNameElement != null) {
            this.mySavedName = this.myNameElement.getText();
        }
        this.myName = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleNameElement";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyReference";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleNameElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fake";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fullName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "fullNameParts";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifyingParts";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "convertNameToKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fake";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createNameFromParts";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "containsPropertyReference";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "convertNameToKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

