/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.ModificationAware;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradleDslElementImpl
implements GradleDslElement,
ModificationAware {
    @NotNull
    protected GradleNameElement myName;
    @Nullable
    protected GradleDslElement myParent;
    @NotNull
    protected List<GradlePropertiesDslElement> myHolders;
    @NotNull
    private final GradleDslFile myDslFile;
    @Nullable
    private PsiElement myPsiElement;
    @Nullable
    private GradleDslClosure myClosureElement;
    @Nullable
    private GradleDslClosure myUnsavedClosure;
    private long myLastCommittedModificationCount;
    private long myModificationCount;
    protected boolean myUseAssignment;
    @NotNull
    private PropertyType myElementType;
    @NotNull
    protected final List<GradleReferenceInjection> myDependencies;
    @NotNull
    protected final List<GradleReferenceInjection> myDependents;

    protected GradleDslElementImpl(@Nullable GradleDslElement parent, @Nullable PsiElement psiElement, @NotNull GradleNameElement name) {
        if (name == null) {
            GradleDslElementImpl.$$$reportNull$$$0(0);
        }
        this.myHolders = new ArrayList<GradlePropertiesDslElement>();
        this.myDependencies = new ArrayList<GradleReferenceInjection>();
        this.myDependents = new ArrayList<GradleReferenceInjection>();
        assert (parent != null || this instanceof GradleDslFile);
        this.myParent = parent;
        this.myPsiElement = psiElement;
        this.myName = name;
        this.myDslFile = parent == null ? (GradleDslFile)this : parent.getDslFile();
        this.myUseAssignment = false;
        this.myElementType = PropertyType.DERIVED;
    }

    @Override
    public void setParsedClosureElement(@NotNull GradleDslClosure closureElement) {
        if (closureElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(1);
        }
        this.myClosureElement = closureElement;
    }

    @Override
    public void setNewClosureElement(@Nullable GradleDslClosure closureElement) {
        this.myUnsavedClosure = closureElement;
        this.setModified();
    }

    @Override
    @Nullable
    public GradleDslClosure getUnsavedClosure() {
        return this.myUnsavedClosure;
    }

    @Override
    @Nullable
    public GradleDslClosure getClosureElement() {
        return this.myUnsavedClosure == null ? this.myClosureElement : this.myUnsavedClosure;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName.name();
        if (string == null) {
            GradleDslElementImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        if (this.myParent == null || this.myParent instanceof GradleDslFile) {
            String string = this.getName();
            if (string == null) {
                GradleDslElementImpl.$$$reportNull$$$0(3);
            }
            return string;
        }
        String ourName = this.getName();
        String string = this.myParent.getQualifiedName() + (ourName.isEmpty() ? "" : "." + this.getName());
        if (string == null) {
            GradleDslElementImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFullName() {
        String string = this.myName.fullName();
        if (string == null) {
            GradleDslElementImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public GradleNameElement getNameElement() {
        GradleNameElement gradleNameElement = this.myName;
        if (gradleNameElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(6);
        }
        return gradleNameElement;
    }

    @Override
    public void rename(@NotNull String newName2) {
        if (newName2 == null) {
            GradleDslElementImpl.$$$reportNull$$$0(7);
        }
        this.myName.rename(newName2);
        this.setModified();
        if (!(this instanceof GradleDslSimpleExpression)) {
            return;
        }
        List<GradleReferenceInjection> dependents = this.getDependents();
        this.unregisterAllDependants();
        this.reorder();
        dependents.forEach(e -> e.getOriginElement().resolve());
        this.getDslFile().getContext().getDependencyManager().resolveWith(this);
    }

    @Override
    @Nullable
    public GradleDslElement getParent() {
        return this.myParent;
    }

    @Override
    public void setParent(@NotNull GradleDslElement parent) {
        if (parent == null) {
            GradleDslElementImpl.$$$reportNull$$$0(8);
        }
        this.myParent = parent;
    }

    @Override
    @NotNull
    public List<GradlePropertiesDslElement> getHolders() {
        List<GradlePropertiesDslElement> list = this.myHolders;
        if (list == null) {
            GradleDslElementImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    public void addHolder(@NotNull GradlePropertiesDslElement holder) {
        if (holder == null) {
            GradleDslElementImpl.$$$reportNull$$$0(10);
        }
        this.myHolders.add(holder);
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        return this.myPsiElement;
    }

    @Override
    public void setPsiElement(@Nullable PsiElement psiElement) {
        this.myPsiElement = psiElement;
    }

    @Override
    public boolean shouldUseAssignment() {
        return this.myUseAssignment;
    }

    @Override
    public void setUseAssignment(boolean useAssignment) {
        this.myUseAssignment = useAssignment;
    }

    @Override
    @NotNull
    public PropertyType getElementType() {
        PropertyType propertyType = this.myElementType;
        if (propertyType == null) {
            GradleDslElementImpl.$$$reportNull$$$0(11);
        }
        return propertyType;
    }

    @Override
    public void setElementType(@NotNull PropertyType propertyType) {
        if (propertyType == null) {
            GradleDslElementImpl.$$$reportNull$$$0(12);
        }
        this.myElementType = propertyType;
    }

    @Override
    @NotNull
    public GradleDslFile getDslFile() {
        GradleDslFile gradleDslFile = this.myDslFile;
        if (gradleDslFile == null) {
            GradleDslElementImpl.$$$reportNull$$$0(13);
        }
        return gradleDslFile;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (GradleDslElement child : this.getChildren()) {
            resultBuilder.addAll(child.getResolvedVariables());
        }
        ImmutableList immutableList = resultBuilder.build();
        if (immutableList == null) {
            GradleDslElementImpl.$$$reportNull$$$0(14);
        }
        return immutableList;
    }

    @Override
    @Nullable
    public GradleDslElement requestAnchor(@NotNull GradleDslElement element) {
        if (element == null) {
            GradleDslElementImpl.$$$reportNull$$$0(15);
        }
        return null;
    }

    @Override
    @Nullable
    public GradleDslElement getAnchor() {
        return this.myParent == null ? null : this.myParent.requestAnchor(this);
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.myDslFile.getWriter().createDslElement(this);
    }

    @Override
    @Nullable
    public PsiElement move() {
        return this.myDslFile.getWriter().moveDslElement(this);
    }

    @Override
    public void delete() {
        for (GradleDslElement element : this.getChildren()) {
            element.delete();
        }
        this.getDslFile().getWriter().deleteDslElement(this);
    }

    @Override
    public void setModified() {
        this.modify();
        if (this.myParent != null) {
            this.myParent.setModified();
        }
    }

    @Override
    public boolean isModified() {
        return this.getLastCommittedModificationCount() != this.getModificationCount();
    }

    @Override
    public boolean isBlockElement() {
        return false;
    }

    @Override
    public boolean isInsignificantIfEmpty() {
        return true;
    }

    @Override
    @NotNull
    public abstract Collection<GradleDslElement> getChildren();

    @Override
    public final void applyChanges() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.apply();
        this.commit();
    }

    protected abstract void apply();

    @Override
    public final void resetState() {
        this.reset();
        this.commit();
    }

    protected abstract void reset();

    @Override
    @NotNull
    public List<GradleDslElement> getContainedElements(boolean includeProperties) {
        List<GradleDslElement> list = Collections.emptyList();
        if (list == null) {
            GradleDslElementImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Override
    @NotNull
    public Map<String, GradleDslElement> getInScopeElements() {
        LinkedHashMap<String, GradleDslElement> results = new LinkedHashMap<String, GradleDslElement>();
        if (PropertyUtil.isNonExpressionPropertiesElement(this)) {
            GradlePropertiesDslElement thisElement = (GradlePropertiesDslElement)this;
            results.putAll(thisElement.getVariableElements());
        }
        GradleDslElement currentElement = this;
        while (currentElement != null && currentElement.getParent() != null) {
            if (!PropertyUtil.isNonExpressionPropertiesElement(currentElement = currentElement.getParent())) continue;
            GradlePropertiesDslElement element = (GradlePropertiesDslElement)currentElement;
            results.putAll(element.getVariableElements());
        }
        if (currentElement instanceof GradleDslFile) {
            for (GradleDslFile file = (GradleDslFile)currentElement; file != null; file = file.getParentModuleDslFile()) {
                GradleDslFile propertiesFile;
                ExtDslElement ext = file.getPropertyElement("ext", ExtDslElement.class);
                if (ext != null) {
                    results.putAll(ext.getPropertyElements());
                }
                if ((propertiesFile = file.getSiblingDslFile()) == null) continue;
                results.putAll(propertiesFile.getPropertyElements());
            }
        }
        LinkedHashMap<String, GradleDslElement> linkedHashMap = results;
        if (linkedHashMap == null) {
            GradleDslElementImpl.$$$reportNull$$$0(17);
        }
        return linkedHashMap;
    }

    @Override
    @NotNull
    public <T extends BuildModelNotification> T notification(@NotNull NotificationTypeReference<T> type) {
        if (type == null) {
            GradleDslElementImpl.$$$reportNull$$$0(18);
        }
        T t = this.getDslFile().getContext().getNotificationForType(type);
        if (t == null) {
            GradleDslElementImpl.$$$reportNull$$$0(19);
        }
        return t;
    }

    @Override
    public void registerDependent(@NotNull GradleReferenceInjection injection) {
        if (injection == null) {
            GradleDslElementImpl.$$$reportNull$$$0(20);
        }
        assert (injection.isResolved() && injection.getToBeInjected() == this);
        this.myDependents.add(injection);
    }

    @Override
    public void unregisterDependent(@NotNull GradleReferenceInjection injection) {
        if (injection == null) {
            GradleDslElementImpl.$$$reportNull$$$0(21);
        }
        assert (injection.isResolved() && injection.getToBeInjected() == this);
        assert (this.myDependents.contains(injection));
        this.myDependents.remove(injection);
    }

    @Override
    public void unregisterAllDependants() {
        this.myDependents.forEach(e -> {
            e.resolveWith(null);
            this.getDslFile().getContext().getDependencyManager().registerUnresolvedReference((GradleReferenceInjection)e);
        });
        this.myDependents.clear();
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependents() {
        ArrayList<GradleReferenceInjection> arrayList = new ArrayList<GradleReferenceInjection>(this.myDependents);
        if (arrayList == null) {
            GradleDslElementImpl.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependencies() {
        ArrayList<GradleReferenceInjection> arrayList = new ArrayList<GradleReferenceInjection>(this.myDependencies);
        if (arrayList == null) {
            GradleDslElementImpl.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @Override
    public void updateDependenciesOnAddElement(@NotNull GradleDslElement newElement) {
        if (newElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(24);
        }
        newElement.resolve();
        newElement.getDslFile().getContext().getDependencyManager().resolveWith(newElement);
    }

    @Override
    public void updateDependenciesOnReplaceElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        if (oldElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(25);
        }
        if (newElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(26);
        }
        List<GradleReferenceInjection> injections = oldElement.getDependents();
        oldElement.unregisterAllDependants();
        injections.forEach(e -> e.resolveWith(newElement));
        injections.forEach(newElement::registerDependent);
        oldElement.getResolvedVariables().forEach(e -> {
            GradleDslElement toBeInjected = e.getToBeInjected();
            if (toBeInjected != null) {
                toBeInjected.unregisterDependent((GradleReferenceInjection)e);
            }
        });
    }

    @Override
    public void updateDependenciesOnRemoveElement(@NotNull GradleDslElement oldElement) {
        if (oldElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(27);
        }
        List<GradleReferenceInjection> dependents = oldElement.getDependents();
        oldElement.unregisterAllDependants();
        dependents.forEach(e -> e.getOriginElement().resolve());
        oldElement.getResolvedVariables().forEach(e -> {
            GradleDslElement toBeInjected = e.getToBeInjected();
            if (toBeInjected != null) {
                toBeInjected.unregisterDependent((GradleReferenceInjection)e);
            }
        });
    }

    @Override
    public void resolve() {
    }

    protected void reorder() {
        if (this.myParent instanceof ExtDslElement) {
            ((ExtDslElement)this.myParent).reorderAndMaybeGetNewIndex(this);
        }
    }

    @Override
    public long getModificationCount() {
        return this.myModificationCount;
    }

    public long getLastCommittedModificationCount() {
        return this.myLastCommittedModificationCount;
    }

    @Override
    public void modify() {
        ++this.myModificationCount;
        this.myDependents.forEach(e -> e.getOriginElement().modify());
    }

    public void commit() {
        this.myLastCommittedModificationCount = this.myModificationCount;
    }

    @Nullable
    public static String getPsiText(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(28);
        }
        return (String)ApplicationManager.getApplication().runReadAction(() -> psiElement.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closureElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElementImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElementImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHolders";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDslFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedVariables";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainedElements";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInScopeElements";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "notification";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependents";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setParsedClosureElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addHolder";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setElementType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "requestAnchor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "notification";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "registerDependent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "unregisterDependent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "updateDependenciesOnAddElement";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updateDependenciesOnReplaceElement";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updateDependenciesOnRemoveElement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getPsiText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

