/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.gradle.actions.CleanImportProjectAction;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.PathUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class ReImportGradleProjectAction
extends AndroidStudioGradleAction {
    private static final String DEFAULT_TITLE = "Re-Import Gradle Project";
    private static final Logger LOG = Logger.getInstance(CleanImportProjectAction.class);
    @NotNull
    private String myTitle;
    @NotNull
    private GradleProjectImporter myImporter;

    public ReImportGradleProjectAction() {
        this(DEFAULT_TITLE);
    }

    public ReImportGradleProjectAction(@NotNull String title) {
        if (title == null) {
            ReImportGradleProjectAction.$$$reportNull$$$0(0);
        }
        this(title, GradleProjectImporter.getInstance());
    }

    @VisibleForTesting
    ReImportGradleProjectAction(@NotNull String title, @NotNull GradleProjectImporter gradleImporter) {
        if (title == null) {
            ReImportGradleProjectAction.$$$reportNull$$$0(1);
        }
        if (gradleImporter == null) {
            ReImportGradleProjectAction.$$$reportNull$$$0(2);
        }
        super(title);
        this.myTitle = title;
        this.myImporter = gradleImporter;
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            ReImportGradleProjectAction.$$$reportNull$$$0(3);
        }
        if (project == null) {
            ReImportGradleProjectAction.$$$reportNull$$$0(4);
        }
        boolean enabled = !GradleSyncState.getInstance(project).isSyncInProgress();
        e.getPresentation().setEnabled(enabled);
    }

    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            ReImportGradleProjectAction.$$$reportNull$$$0(5);
        }
        if (project == null) {
            ReImportGradleProjectAction.$$$reportNull$$$0(6);
        }
        String projectName = project.getName();
        LOG.info(String.format("Re-importing project '%1$s'...", projectName));
        File projectDirPath = ReImportGradleProjectAction.close(project);
        try {
            LOG.info(String.format("About to import project '%1$s'.", projectName));
            this.myImporter.importProject(projectName, projectDirPath, null);
            LOG.info(String.format("Done importing project '%1$s'.", projectName));
        }
        catch (Exception error) {
            Messages.showErrorDialog((String)error.getMessage(), (String)this.myTitle);
            LOG.info(String.format("Failed to import project '%1$s'.", projectName));
        }
    }

    private static File close(@NotNull Project project) {
        if (project == null) {
            ReImportGradleProjectAction.$$$reportNull$$$0(7);
        }
        String projectName = project.getName();
        File projectDirPath = Projects.getBaseDirPath((Project)project);
        ProjectManagerEx.getInstanceEx().closeAndDispose(project);
        RecentProjectsManager.getInstance().removePath(PathUtil.toSystemIndependentName((String)projectDirPath.getPath()));
        WelcomeFrame.showIfNoProjectOpened();
        LOG.info(String.format("Closed project '%1$s'.", projectName));
        return projectDirPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleImporter";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/actions/ReImportGradleProjectAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doPerform";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "close";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

