/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.intellij.jarFinder.InternetAttachSourceProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryFilePaths {
    @NotNull
    public static LibraryFilePaths getInstance() {
        LibraryFilePaths libraryFilePaths = (LibraryFilePaths)ServiceManager.getService(LibraryFilePaths.class);
        if (libraryFilePaths == null) {
            LibraryFilePaths.$$$reportNull$$$0(0);
        }
        return libraryFilePaths;
    }

    @Nullable
    public File findSourceJarPath(@NotNull File libraryPath) {
        if (libraryPath == null) {
            LibraryFilePaths.$$$reportNull$$$0(1);
        }
        return LibraryFilePaths.findArtifactFilePathInRepository(libraryPath, "-sources.jar", true);
    }

    @Nullable
    public File findJavadocJarPath(@NotNull File libraryPath) {
        if (libraryPath == null) {
            LibraryFilePaths.$$$reportNull$$$0(2);
        }
        return LibraryFilePaths.findArtifactFilePathInRepository(libraryPath, "-javadoc.jar", true);
    }

    @Nullable
    public File findPomPathForLibrary(@NotNull File libraryPath) {
        if (libraryPath == null) {
            LibraryFilePaths.$$$reportNull$$$0(3);
        }
        return LibraryFilePaths.findArtifactFilePathInRepository(libraryPath, ".pom", false);
    }

    @Nullable
    private static File findArtifactFilePathInRepository(@NotNull File libraryPath, @NotNull String fileNameSuffix, boolean searchInIdeCache) {
        File librarySourceDirPath;
        File sourceJarPath;
        if (libraryPath == null) {
            LibraryFilePaths.$$$reportNull$$$0(4);
        }
        if (fileNameSuffix == null) {
            LibraryFilePaths.$$$reportNull$$$0(5);
        }
        if (!libraryPath.isFile()) {
            return null;
        }
        File parentPath = libraryPath.getParentFile();
        String name = FileUtilRt.getNameWithoutExtension((String)libraryPath.getName());
        String sourceFileName = name + fileNameSuffix;
        if (parentPath != null) {
            File sourceJar = LibraryFilePaths.findChildPath(parentPath, sourceFileName);
            if (sourceJar != null) {
                return sourceJar;
            }
            if ((parentPath = parentPath.getParentFile()) != null) {
                for (File child : FileUtil.notNullize((File[])parentPath.listFiles())) {
                    if (!child.isDirectory() || (sourceJar = LibraryFilePaths.findChildPath(child, sourceFileName)) == null) continue;
                    return sourceJar;
                }
            }
        }
        if (searchInIdeCache && (sourceJarPath = new File(librarySourceDirPath = InternetAttachSourceProvider.getLibrarySourceDir(), sourceFileName)).isFile()) {
            return sourceJarPath;
        }
        return null;
    }

    @Nullable
    private static File findChildPath(@NotNull File parentPath, @NotNull String childName) {
        if (parentPath == null) {
            LibraryFilePaths.$$$reportNull$$$0(6);
        }
        if (childName == null) {
            LibraryFilePaths.$$$reportNull$$$0(7);
        }
        for (File child : FileUtil.notNullize((File[])parentPath.listFiles())) {
            if (!childName.equals(child.getName())) continue;
            return child.isFile() ? child : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/LibraryFilePaths";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameSuffix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/LibraryFilePaths";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findSourceJarPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findJavadocJarPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPomPathForLibrary";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findArtifactFilePathInRepository";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findChildPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

