/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.tools.idea.fd.BuildCause;
import com.android.tools.idea.fd.BuildMode;
import com.android.tools.idea.fd.BuildSelection;
import com.android.tools.idea.fd.DeployType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunNotificationProvider {
    private static final Set<BuildCause> ourCausesThatDontNeedNotifications = ImmutableSet.of((Object)((Object)BuildCause.FIRST_INSTALLATION_TO_DEVICE), (Object)((Object)BuildCause.NO_DEVICE), (Object)((Object)BuildCause.APP_NOT_INSTALLED), (Object)((Object)BuildCause.USER_REQUESTED_COLDSWAP), (Object)((Object)BuildCause.USER_CHOSE_TO_COLDSWAP));
    private static final Map<BuildCause, String> ourFullBuildNotificationsByCause = new ImmutableMap.Builder().put((Object)BuildCause.MISMATCHING_TIMESTAMPS, (Object)AndroidBundle.message("instant.run.notification.fullbuild.mismatching.timestamps", new Object[0])).put((Object)BuildCause.API_TOO_LOW_FOR_INSTANT_RUN, (Object)AndroidBundle.message("instant.run.notification.ir.disabled.api.less.than.21", new Object[0])).put((Object)BuildCause.MANIFEST_RESOURCE_CHANGED, (Object)AndroidBundle.message("instant.run.notification.fullbuild.manifestresourcechanged", new Object[0])).put((Object)BuildCause.FREEZE_SWAP_REQUIRES_API21, (Object)AndroidBundle.message("instant.run.notification.fullbuild.api.less.than.21", new Object[0])).build();
    private final BuildSelection myBuildSelection;
    private final DeployType myDeployType;
    private final String myVerifierStatus;

    public InstantRunNotificationProvider(@Nullable BuildSelection buildSelection, @NotNull DeployType deployType, @NotNull String verifierStatus) {
        if (deployType == null) {
            InstantRunNotificationProvider.$$$reportNull$$$0(0);
        }
        if (verifierStatus == null) {
            InstantRunNotificationProvider.$$$reportNull$$$0(1);
        }
        this.myBuildSelection = buildSelection;
        this.myDeployType = deployType;
        this.myVerifierStatus = verifierStatus;
    }

    @Nullable
    public String getNotificationText() {
        if (this.myBuildSelection == null) {
            return null;
        }
        BuildCause buildCause = this.myBuildSelection.why;
        if (ourCausesThatDontNeedNotifications.contains((Object)buildCause)) {
            return null;
        }
        if (ourFullBuildNotificationsByCause.containsKey((Object)buildCause)) {
            return ourFullBuildNotificationsByCause.get((Object)buildCause);
        }
        if (buildCause == BuildCause.APP_NOT_RUNNING) {
            return this.myDeployType == DeployType.NO_CHANGES ? AndroidBundle.message("instant.run.notification.coldswap.nochanges", new Object[0]) : AndroidBundle.message("instant.run.notification.coldswap", new Object[0]);
        }
        if (buildCause == BuildCause.ANDROID_TV_UNSUPPORTED) {
            return AndroidBundle.message("instant.run.notification.coldswap.tv", new Object[0]);
        }
        switch (this.myDeployType) {
            case NO_CHANGES: {
                return buildCause.getBuildMode() == BuildMode.COLD ? null : AndroidBundle.message("instant.run.notification.nochanges", new Object[0]);
            }
            case RESTART: {
                return AndroidBundle.message("instant.run.notification.coldswap", new Object[0]);
            }
            case HOTSWAP: {
                return AndroidBundle.message("instant.run.notification.hotswap", InstantRunNotificationProvider.getRestartActivityShortcutText());
            }
            case WARMSWAP: {
                return AndroidBundle.message("instant.run.notification.warmswap", new Object[0]);
            }
            case SPLITAPK: {
                StringBuilder sb = new StringBuilder("Instant Run applied code changes and restarted the app.");
                if (buildCause.getBuildMode() == BuildMode.HOT) {
                    if (!this.myVerifierStatus.isEmpty()) {
                        sb.append(' ');
                        sb.append(StringUtil.capitalizeWords((String)StringUtil.toLowerCase((String)this.myVerifierStatus).replace('_', ' '), (boolean)true));
                        sb.append('.');
                    }
                } else if (buildCause.getBuildMode() == BuildMode.COLD) {
                    if (buildCause == BuildCause.APP_USES_MULTIPLE_PROCESSES) {
                        return AndroidBundle.message("instant.run.notification.coldswap.multiprocess", new Object[0]);
                    }
                    sb.append(' ').append((Object)buildCause).append('.');
                }
                return sb.toString();
            }
            case FULLAPK: {
                StringBuilder sb = new StringBuilder("Instant Run re-installed and restarted the app.");
                if (buildCause.getBuildMode() == BuildMode.HOT || buildCause.getBuildMode() == BuildMode.COLD) {
                    if (!this.myVerifierStatus.isEmpty()) {
                        sb.append(' ');
                        sb.append(StringUtil.capitalizeWords((String)StringUtil.toLowerCase((String)this.myVerifierStatus).replace('_', ' '), (boolean)true));
                        sb.append('.');
                    }
                } else if (buildCause.getBuildMode() == BuildMode.FULL) {
                    sb.append(' ').append((Object)buildCause).append('.');
                }
                return sb.toString();
            }
        }
        return null;
    }

    @NotNull
    private static String getRestartActivityShortcutText() {
        if (ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isUnitTestMode()) {
            if ("" == null) {
                InstantRunNotificationProvider.$$$reportNull$$$0(2);
            }
            return "";
        }
        Shortcut[] shortcuts = ActionManager.getInstance().getAction("Android.RestartActivity").getShortcutSet().getShortcuts();
        String string = shortcuts.length > 0 ? " (" + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + ") " : "";
        if (string == null) {
            InstantRunNotificationProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "verifierStatus";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fd/InstantRunNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fd/InstantRunNotificationProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestartActivityShortcutText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

