/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.ui;

import com.intellij.ui.tree.TreePathUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeUtil {
    @NotNull
    public static Stream<TreeNode> getChildren(@NotNull TreeNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(0);
        }
        final Enumeration<? extends TreeNode> e = node.children();
        Stream<TreeNode> stream = StreamSupport.stream(Spliterators.spliterator(new Iterator<TreeNode>(){

            @Override
            public TreeNode next() {
                return (TreeNode)e.nextElement();
            }

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }
        }, (long)node.getChildCount(), 16), false);
        if (stream == null) {
            TreeUtil.$$$reportNull$$$0(1);
        }
        return stream;
    }

    @Nullable
    public static <V extends DefaultMutableTreeNode> TreePath getCommonPath(@NotNull List<V> treeNodes) {
        if (treeNodes == null) {
            TreeUtil.$$$reportNull$$$0(2);
        }
        if (treeNodes.isEmpty()) {
            return null;
        }
        TreePath[] paths2 = (TreePath[])treeNodes.stream().map(DefaultMutableTreeNode::getPath).map(TreePath::new).toArray(TreePath[]::new);
        return TreePathUtil.findCommonAncestor((TreePath[])paths2);
    }

    public static int binarySearch(@NotNull TreeNode parent, @NotNull TreeNode key, @NotNull Comparator<TreeNode> comparator2) {
        if (parent == null) {
            TreeUtil.$$$reportNull$$$0(3);
        }
        if (key == null) {
            TreeUtil.$$$reportNull$$$0(4);
        }
        if (comparator2 == null) {
            TreeUtil.$$$reportNull$$$0(5);
        }
        return com.intellij.util.ui.tree.TreeUtil.indexedBinarySearch((TreeNode)parent, (TreeNode)key, comparator2);
    }

    @NotNull
    public static <T extends MutableTreeNode, U> List<T> updateChildrenNodes(@NotNull DefaultTreeModel treeModel, @NotNull T parentNode, @NotNull List<U> newEntries, @NotNull UpdateChildrenOps<T, U> ops) {
        if (treeModel == null) {
            TreeUtil.$$$reportNull$$$0(6);
        }
        if (parentNode == null) {
            TreeUtil.$$$reportNull$$$0(7);
        }
        if (newEntries == null) {
            TreeUtil.$$$reportNull$$$0(8);
        }
        if (ops == null) {
            TreeUtil.$$$reportNull$$$0(9);
        }
        if (newEntries.isEmpty()) {
            TreeUtil.removeAllChildren(parentNode);
            treeModel.nodeStructureChanged(parentNode);
            ArrayList arrayList = new ArrayList();
            if (arrayList == null) {
                TreeUtil.$$$reportNull$$$0(10);
            }
            return arrayList;
        }
        if (parentNode.getChildCount() == 0) {
            List<MutableTreeNode> nodes = newEntries.stream().map(ops::mapEntry).collect(Collectors.toList());
            TreeUtil.removeAllChildren(parentNode);
            TreeUtil.setAllowsChildren(parentNode);
            nodes.forEach(x -> parentNode.insert((MutableTreeNode)x, parentNode.getChildCount()));
            treeModel.nodeStructureChanged(parentNode);
            List<MutableTreeNode> list = nodes;
            if (list == null) {
                TreeUtil.$$$reportNull$$$0(11);
            }
            return list;
        }
        ArrayList<T> addedNodes = new ArrayList<T>();
        int childIndex = 0;
        int childCount = parentNode.getChildCount();
        int newEntryIndex = 0;
        int newEntryCount = newEntries.size();
        while (newEntryIndex < newEntries.size() || childIndex < parentNode.getChildCount()) {
            assert (childIndex == newEntryIndex);
            if (childIndex >= childCount) {
                T newEntryNode = ops.mapEntry(newEntries.get(newEntryIndex));
                addedNodes.add(newEntryNode);
                TreeUtil.setAllowsChildren(parentNode);
                treeModel.insertNodeInto((MutableTreeNode)newEntryNode, parentNode, childIndex);
                ++newEntryIndex;
                ++childIndex;
                ++childCount;
                continue;
            }
            if (newEntryIndex >= newEntryCount) {
                treeModel.removeNodeFromParent((MutableTreeNode)parentNode.getChildAt(childIndex));
                --childCount;
                continue;
            }
            T childNode = ops.getChildNode(parentNode, childIndex);
            if (childNode == null) {
                treeModel.removeNodeFromParent((MutableTreeNode)parentNode.getChildAt(childIndex));
                --childCount;
                continue;
            }
            int compareResult = ops.compareNodeWithEntry(childNode, newEntries.get(newEntryIndex));
            if (compareResult == 0) {
                ops.updateNode(childNode, newEntries.get(newEntryIndex));
                treeModel.nodeChanged((TreeNode)childNode);
                ++childIndex;
                ++newEntryIndex;
                continue;
            }
            if (compareResult < 0) {
                treeModel.removeNodeFromParent((MutableTreeNode)parentNode.getChildAt(childIndex));
                --childCount;
                continue;
            }
            assert (compareResult > 0);
            int nextIndex = TreeUtil.findIndexOfNextEntry(newEntries, newEntryIndex + 1, childNode, ops);
            assert (nextIndex >= newEntryIndex + 1);
            assert (nextIndex <= newEntries.size());
            while (newEntryIndex < nextIndex) {
                T newChildNode = ops.mapEntry(newEntries.get(newEntryIndex));
                addedNodes.add(newChildNode);
                treeModel.insertNodeInto((MutableTreeNode)newChildNode, parentNode, childIndex);
                ++childIndex;
                ++childCount;
                ++newEntryIndex;
            }
        }
        assert (childIndex == newEntryIndex);
        assert (childCount == newEntryCount);
        ArrayList<T> arrayList = addedNodes;
        if (arrayList == null) {
            TreeUtil.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static <T extends MutableTreeNode, U> int findIndexOfNextEntry(@NotNull List<U> entries, int beginIndex, @NotNull T treeNode, @NotNull UpdateChildrenOps<T, U> ops) {
        if (entries == null) {
            TreeUtil.$$$reportNull$$$0(13);
        }
        if (treeNode == null) {
            TreeUtil.$$$reportNull$$$0(14);
        }
        if (ops == null) {
            TreeUtil.$$$reportNull$$$0(15);
        }
        for (int i2 = beginIndex; i2 < entries.size(); ++i2) {
            if (ops.compareNodeWithEntry(treeNode, entries.get(i2)) > 0) continue;
            return i2;
        }
        return entries.size();
    }

    private static void removeAllChildren(@NotNull MutableTreeNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(16);
        }
        for (int i2 = node.getChildCount() - 1; i2 >= 0; --i2) {
            node.remove(i2);
        }
    }

    private static void setAllowsChildren(@NotNull MutableTreeNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(17);
        }
        if (node instanceof DefaultMutableTreeNode) {
            ((DefaultMutableTreeNode)node).setAllowsChildren(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/ui/TreeUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeNodes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEntries";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ops";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/ui/TreeUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "updateChildrenNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCommonPath";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "binarySearch";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateChildrenNodes";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findIndexOfNextEntry";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeAllChildren";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setAllowsChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface UpdateChildrenOps<T extends MutableTreeNode, U> {
        @Nullable
        public T getChildNode(@NotNull T var1, int var2);

        @NotNull
        public T mapEntry(@NotNull U var1);

        public int compareNodeWithEntry(@NotNull T var1, @NotNull U var2);

        public void updateNode(@NotNull T var1, @NotNull U var2);
    }
}

