/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.concurrent.FutureCallbackExecutor;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystem;
import com.android.tools.idea.explorer.fs.DeviceFileSystemService;
import com.android.tools.idea.explorer.fs.DeviceFileSystemServiceListener;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AdbDeviceFileSystemService
implements DeviceFileSystemService<AdbDeviceFileSystem> {
    public static Logger LOGGER = Logger.getInstance(AdbDeviceFileSystemService.class);
    @NotNull
    private final Function<Void, File> myAdbProvider;
    @NotNull
    private final FutureCallbackExecutor myEdtExecutor;
    @NotNull
    private final FutureCallbackExecutor myTaskExecutor;
    @NotNull
    private final List<AdbDeviceFileSystem> myDevices;
    @NotNull
    private final List<DeviceFileSystemServiceListener> myListeners;
    @NotNull
    private State myState;
    @Nullable
    private AndroidDebugBridge myBridge;
    @Nullable
    private DeviceChangeListener myDeviceChangeListener;
    @Nullable
    private DebugBridgeChangeListener myDebugBridgeChangeListener;
    @Nullable
    private File myAdb;

    public AdbDeviceFileSystemService(@NotNull Function<Void, File> adbProvider, @NotNull Executor edtExecutor, @NotNull Executor taskExecutor) {
        if (adbProvider == null) {
            AdbDeviceFileSystemService.$$$reportNull$$$0(0);
        }
        if (edtExecutor == null) {
            AdbDeviceFileSystemService.$$$reportNull$$$0(1);
        }
        if (taskExecutor == null) {
            AdbDeviceFileSystemService.$$$reportNull$$$0(2);
        }
        this.myDevices = new ArrayList<AdbDeviceFileSystem>();
        this.myListeners = new ArrayList<DeviceFileSystemServiceListener>();
        this.myState = State.Initial;
        this.myAdbProvider = adbProvider;
        this.myEdtExecutor = new FutureCallbackExecutor(edtExecutor);
        this.myTaskExecutor = new FutureCallbackExecutor(taskExecutor);
    }

    @NotNull
    List<AdbDeviceFileSystem> getDeviceList() {
        List<AdbDeviceFileSystem> list = this.myDevices;
        if (list == null) {
            AdbDeviceFileSystemService.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void addListener(@NotNull DeviceFileSystemServiceListener listener2) {
        if (listener2 == null) {
            AdbDeviceFileSystemService.$$$reportNull$$$0(4);
        }
        this.myListeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull DeviceFileSystemServiceListener listener2) {
        if (listener2 == null) {
            AdbDeviceFileSystemService.$$$reportNull$$$0(5);
        }
        this.myListeners.remove(listener2);
    }

    @NotNull
    public FutureCallbackExecutor getEdtExecutor() {
        FutureCallbackExecutor futureCallbackExecutor = this.myEdtExecutor;
        if (futureCallbackExecutor == null) {
            AdbDeviceFileSystemService.$$$reportNull$$$0(6);
        }
        return futureCallbackExecutor;
    }

    @NotNull
    public FutureCallbackExecutor getTaskExecutor() {
        FutureCallbackExecutor futureCallbackExecutor = this.myTaskExecutor;
        if (futureCallbackExecutor == null) {
            AdbDeviceFileSystemService.$$$reportNull$$$0(7);
        }
        return futureCallbackExecutor;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> start() {
        this.checkState(State.Initial);
        File adb = this.myAdbProvider.apply(null);
        if (adb == null) {
            LOGGER.error("ADB not found");
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new FileNotFoundException("Android Debug Bridge not found."));
            if (listenableFuture == null) {
                AdbDeviceFileSystemService.$$$reportNull$$$0(8);
            }
            return listenableFuture;
        }
        this.myAdb = adb;
        this.myDeviceChangeListener = new DeviceChangeListener();
        this.myDebugBridgeChangeListener = new DebugBridgeChangeListener();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this.myDebugBridgeChangeListener);
        ListenableFuture<Void> listenableFuture = this.startDebugBridge();
        if (listenableFuture == null) {
            AdbDeviceFileSystemService.$$$reportNull$$$0(9);
        }
        return listenableFuture;
    }

    @NotNull
    private ListenableFuture<Void> startDebugBridge() {
        assert (this.myAdb != null);
        this.myState = State.SetupRunning;
        final SettableFuture futureResult = SettableFuture.create();
        ListenableFuture<AndroidDebugBridge> future2 = AdbService.getInstance().getDebugBridge(this.myAdb);
        this.myEdtExecutor.addCallback(future2, (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

            public void onSuccess(@Nullable AndroidDebugBridge bridge) {
                LOGGER.info("Successfully obtained debug bridge");
                AdbDeviceFileSystemService.this.myState = State.SetupDone;
                futureResult.set(null);
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                LOGGER.warn("Unable to obtain debug bridge", t);
                AdbDeviceFileSystemService.this.myState = State.Initial;
                if (t.getMessage() != null) {
                    futureResult.setException(t);
                } else {
                    futureResult.setException((Throwable)new RuntimeException(AdbService.getDebugBridgeDiagnosticErrorMessage(t, AdbDeviceFileSystemService.this.myAdb), t));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/adbimpl/AdbDeviceFileSystemService$1", "onFailure"));
            }
        });
        SettableFuture settableFuture = futureResult;
        if (settableFuture == null) {
            AdbDeviceFileSystemService.$$$reportNull$$$0(10);
        }
        return settableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> restart() {
        if (this.myState == State.Initial) {
            ListenableFuture<Void> listenableFuture = this.start();
            if (listenableFuture == null) {
                AdbDeviceFileSystemService.$$$reportNull$$$0(11);
            }
            return listenableFuture;
        }
        this.checkState(State.SetupDone);
        final SettableFuture futureResult = SettableFuture.create();
        this.getTaskExecutor().execute(() -> {
            try {
                AdbService.getInstance().terminateDdmlib();
            }
            catch (Throwable t) {
                futureResult.setException(t);
                return;
            }
            this.getEdtExecutor().execute(() -> {
                ListenableFuture<Void> futureStart = this.startDebugBridge();
                this.getEdtExecutor().addCallback(futureStart, (FutureCallback)new FutureCallback<Void>(){

                    public void onSuccess(@Nullable Void result2) {
                        futureResult.set(null);
                    }

                    public void onFailure(@NotNull Throwable t) {
                        if (t == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        futureResult.setException(t);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/adbimpl/AdbDeviceFileSystemService$2", "onFailure"));
                    }
                });
            });
        });
        SettableFuture settableFuture = futureResult;
        if (settableFuture == null) {
            AdbDeviceFileSystemService.$$$reportNull$$$0(12);
        }
        return settableFuture;
    }

    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this.myDebugBridgeChangeListener);
        this.myBridge = null;
        this.myDevices.clear();
    }

    @Override
    @NotNull
    public ListenableFuture<List<AdbDeviceFileSystem>> getDevices() {
        this.checkState(State.SetupDone);
        ListenableFuture listenableFuture = Futures.immediateFuture(this.myDevices);
        if (listenableFuture == null) {
            AdbDeviceFileSystemService.$$$reportNull$$$0(13);
        }
        return listenableFuture;
    }

    private void checkState(State state) {
        if (this.myState != state) {
            throw new IllegalStateException();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adbProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtExecutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutor";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceFileSystemService";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceFileSystemService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceList";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdtExecutor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskExecutor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "start";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "startDebugBridge";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "restart";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DeviceChangeListener
    implements AndroidDebugBridge.IDeviceChangeListener {
        private DeviceChangeListener() {
        }

        public void deviceConnected(IDevice device) {
            LOGGER.info(String.format("Device connected: %s", device));
            AdbDeviceFileSystemService.this.myEdtExecutor.execute(() -> {
                AdbDeviceFileSystem deviceFileSystem = this.findDevice(device);
                if (deviceFileSystem == null) {
                    AdbDeviceFileSystem newDevice = new AdbDeviceFileSystem(AdbDeviceFileSystemService.this, device);
                    AdbDeviceFileSystemService.this.myDevices.add(newDevice);
                    AdbDeviceFileSystemService.this.myListeners.forEach(x -> x.deviceAdded(newDevice));
                }
            });
        }

        public void deviceDisconnected(IDevice device) {
            LOGGER.info(String.format("Device disconnected: %s", device));
            AdbDeviceFileSystemService.this.myEdtExecutor.execute(() -> {
                AdbDeviceFileSystem deviceFileSystem = this.findDevice(device);
                if (deviceFileSystem != null) {
                    AdbDeviceFileSystemService.this.myListeners.forEach(x -> x.deviceRemoved(deviceFileSystem));
                    AdbDeviceFileSystemService.this.myDevices.remove(deviceFileSystem);
                }
            });
        }

        public void deviceChanged(IDevice device, int changeMask) {
            LOGGER.info(String.format("Device changed: %s", device));
            AdbDeviceFileSystemService.this.myEdtExecutor.execute(() -> {
                AdbDeviceFileSystem deviceFileSystem = this.findDevice(device);
                if (deviceFileSystem != null) {
                    AdbDeviceFileSystemService.this.myListeners.forEach(x -> x.deviceUpdated(deviceFileSystem));
                }
            });
        }

        @Nullable
        private AdbDeviceFileSystem findDevice(IDevice device) {
            return AdbDeviceFileSystemService.this.myDevices.stream().filter(system -> system.isDevice(device)).findFirst().orElse(null);
        }
    }

    private class DebugBridgeChangeListener
    implements AndroidDebugBridge.IDebugBridgeChangeListener {
        private DebugBridgeChangeListener() {
        }

        public void bridgeChanged(@Nullable AndroidDebugBridge bridge) {
            LOGGER.info("Debug bridge changed");
            AdbDeviceFileSystemService.this.myEdtExecutor.execute(() -> {
                if (AdbDeviceFileSystemService.this.myBridge != null) {
                    AdbDeviceFileSystemService.this.myDevices.clear();
                    AdbDeviceFileSystemService.this.myListeners.forEach(DeviceFileSystemServiceListener::serviceRestarted);
                    AdbDeviceFileSystemService.this.myBridge = null;
                }
                if (bridge != null) {
                    AdbDeviceFileSystemService.this.myBridge = bridge;
                    if (AdbDeviceFileSystemService.this.myBridge.hasInitialDeviceList()) {
                        Arrays.stream(AdbDeviceFileSystemService.this.myBridge.getDevices()).map(d -> new AdbDeviceFileSystem(AdbDeviceFileSystemService.this, (IDevice)d)).forEach(AdbDeviceFileSystemService.this.myDevices::add);
                    }
                }
            });
        }
    }

    public static enum State {
        Initial,
        SetupRunning,
        SetupDone;

    }
}

