/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.idea.concurrent.FutureCallbackExecutor;
import com.android.tools.idea.device.fs.DeviceFileId;
import com.android.tools.idea.explorer.DeviceExplorerFileManager;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.fs.FileTransferProgress;
import com.android.tools.idea.explorer.options.DeviceFileExplorerSettings;
import com.android.utils.FileUtils;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceExplorerFileManagerImpl
implements DeviceExplorerFileManager {
    private static final Logger LOGGER = Logger.getInstance(DeviceExplorerFileManagerImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<VirtualFile> myTemporaryEditorFiles;
    @NotNull
    private final FutureCallbackExecutor myEdtExecutor;
    @NotNull
    private Supplier<Path> myDefaultDownloadPath;

    public DeviceExplorerFileManagerImpl(@NotNull Project project, @NotNull Executor edtExecutor) {
        if (project == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(0);
        }
        if (edtExecutor == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(1);
        }
        this(project, edtExecutor, () -> Paths.get(DeviceFileExplorerSettings.getInstance().getDownloadLocation(), new String[0]));
    }

    public DeviceExplorerFileManagerImpl(@NotNull Project project, @NotNull Executor edtExecutor, @NotNull Supplier<Path> downloadPathSupplier) {
        if (project == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(2);
        }
        if (edtExecutor == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(3);
        }
        if (downloadPathSupplier == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(4);
        }
        this.myTemporaryEditorFiles = new ArrayList<VirtualFile>();
        this.myProject = project;
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileEditorManagerAdapter());
        this.myEdtExecutor = new FutureCallbackExecutor(edtExecutor);
        this.myDefaultDownloadPath = downloadPathSupplier;
    }

    @NotNull
    public Path getDefaultLocalPathForDevice(@NotNull DeviceFileSystem device) {
        if (device == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(5);
        }
        Path rootPath = this.getDefaultDownloadPath();
        Path path = rootPath.resolve(DeviceExplorerFileManagerImpl.mapName(device.getName()));
        if (path == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(6);
        }
        return path;
    }

    @Override
    @NotNull
    public Path getDefaultLocalPathForEntry(@NotNull DeviceFileEntry entry) {
        if (entry == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(7);
        }
        Path devicePath = this.getDefaultLocalPathForDevice(entry.getFileSystem());
        Path relativePath = DeviceExplorerFileManagerImpl.getEntryPath(entry);
        Path path = devicePath.resolve(relativePath);
        if (path == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(8);
        }
        return path;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> downloadFileEntry(@NotNull DeviceFileEntry entry, final @NotNull Path localPath, @NotNull FileTransferProgress progress) {
        if (entry == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(9);
        }
        if (localPath == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(10);
        }
        if (progress == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(11);
        }
        final SettableFuture futureResult = SettableFuture.create();
        try {
            FileUtils.mkdirs((File)localPath.getParent().toFile());
            FileUtils.deleteIfExists((File)localPath.toFile());
        }
        catch (IOException e) {
            futureResult.setException((Throwable)e);
            SettableFuture settableFuture = futureResult;
            if (settableFuture == null) {
                DeviceExplorerFileManagerImpl.$$$reportNull$$$0(12);
            }
            return settableFuture;
        }
        ListenableFuture<Void> result2 = entry.downloadFile(localPath, progress);
        this.myEdtExecutor.addCallback(result2, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result2) {
                futureResult.set(null);
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                futureResult.setException(t);
                DeviceExplorerFileManagerImpl.deleteTemporaryFile(localPath);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/DeviceExplorerFileManagerImpl$1", "onFailure"));
            }
        });
        SettableFuture settableFuture = futureResult;
        if (settableFuture == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(13);
        }
        return settableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> openFileInEditor(@NotNull DeviceFileEntry entry, @NotNull Path localPath, boolean focusEditor) {
        if (entry == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(14);
        }
        if (localPath == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(15);
        }
        ListenableFuture<Void> listenableFuture = this.openFileInEditorWorker(entry, localPath, focusEditor);
        if (listenableFuture == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(16);
        }
        return listenableFuture;
    }

    @NotNull
    private Path getDefaultDownloadPath() {
        Path path = this.myDefaultDownloadPath.get();
        if (path == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(17);
        }
        return path;
    }

    @NotNull
    private static Path mapName(String name) {
        Path path = Paths.get(PathUtilRt.suggestFileName((String)name, (boolean)true, (boolean)true), new String[0]);
        if (path == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(18);
        }
        return path;
    }

    @NotNull
    private static Path getEntryPath(@NotNull DeviceFileEntry file) {
        if (file == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(19);
        }
        ArrayList<Path> names = new ArrayList<Path>();
        for (DeviceFileEntry entry = file; entry != null; entry = entry.getParent()) {
            names.add(DeviceExplorerFileManagerImpl.mapName(entry.getName()));
        }
        Collections.reverse(names);
        Optional path = names.stream().reduce(Path::resolve);
        assert (path.isPresent());
        Path path2 = (Path)path.get();
        if (path2 == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(20);
        }
        return path2;
    }

    private ListenableFuture<Void> openFileInEditorWorker(@NotNull DeviceFileEntry entry, @NotNull Path localPath, boolean focusEditor) {
        if (entry == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(21);
        }
        if (localPath == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(22);
        }
        SettableFuture futureFile = SettableFuture.create();
        TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> {
            VirtualFile localFile = VfsUtil.findFileByIoFile((File)localPath.toFile(), (boolean)true);
            if (localFile == null) {
                futureFile.setException((Throwable)new RuntimeException(String.format("Unable to locate file \"%s\"", localPath)));
            } else {
                futureFile.set((Object)localFile);
            }
        });
        return this.myEdtExecutor.transform((ListenableFuture)futureFile, file -> {
            DeviceFileId fileInfo = new DeviceFileId(entry.getFileSystem().getName(), entry.getFullPath());
            file.putUserData(DeviceFileId.KEY, (Object)fileInfo);
            FileType type = FileTypeChooser.getKnownFileTypeOrAssociate((VirtualFile)file, (Project)this.myProject);
            if (type == null) {
                throw new CancellationException("Operation cancelled by user");
            }
            FileEditor[] editors = FileEditorManager.getInstance((Project)this.myProject).openFile(file, focusEditor);
            if (editors.length == 0) {
                throw new RuntimeException(String.format("Unable to open file \"%s\" in editor", localPath));
            }
            this.myTemporaryEditorFiles.add((VirtualFile)file);
            return null;
        });
    }

    private static void deleteTemporaryFile(@NotNull Path localPath) {
        if (localPath == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(23);
        }
        try {
            Files.deleteIfExists(localPath);
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Error deleting device file from local file system \"%s\"", localPath), (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtExecutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadPathSupplier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/DeviceExplorerFileManagerImpl";
                break;
            }
            case 7: 
            case 9: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 10: 
            case 15: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/DeviceExplorerFileManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLocalPathForDevice";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLocalPathForEntry";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadFileEntry";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileInEditor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDownloadPath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "mapName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultLocalPathForDevice";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultLocalPathForEntry";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "downloadFileEntry";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "openFileInEditor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getEntryPath";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "openFileInEditorWorker";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "deleteTemporaryFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFileEditorManagerAdapter
    implements FileEditorManagerListener {
        private MyFileEditorManagerAdapter() {
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                MyFileEditorManagerAdapter.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MyFileEditorManagerAdapter.$$$reportNull$$$0(1);
            }
            if (DeviceExplorerFileManagerImpl.this.myTemporaryEditorFiles.contains(file)) {
                DeviceExplorerFileManagerImpl.this.myTemporaryEditorFiles.remove(file);
                Path localPath = Paths.get(file.getPath(), new String[0]);
                DeviceExplorerFileManagerImpl.deleteTemporaryFile(localPath);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/explorer/DeviceExplorerFileManagerImpl$MyFileEditorManagerAdapter";
            objectArray[2] = "fileClosed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

