/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl;

import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.BlockGraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.ConditionCheckNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.GraphNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.GraphNodeUtil;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.LoopBranchingNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.GraphNodeImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.Param;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.Value;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoopBranchingNodeImpl
extends GraphNodeImpl
implements LoopBranchingNode {
    protected int mLoopType;
    protected BlockGraph mLoopBody;
    protected GraphNode mConditionCheckExitNode;
    protected GraphNode mPostLoopEntryNode;
    protected GraphNode mPostLoopExitNode;
    protected GraphNode mConditionCheckEntryNode;
    protected Param mForeachLoopParam;
    protected Value mForeachLoopValue;
    public ArrayList<GraphNode> breakNodeList;
    public ArrayList<GraphNode> continueNodeList;

    @Override
    public GraphNode getConditionCheckNode() {
        return this.mConditionCheckEntryNode;
    }

    @Override
    public GraphNode getPostCode() {
        return this.mPostLoopEntryNode;
    }

    @Override
    public BlockGraph getLoopBlock() {
        return this.mLoopBody;
    }

    @Override
    @Nullable
    public Param getForeachIteratorParam() {
        return this.mForeachLoopParam;
    }

    public void setForeachIteratorParam(@NotNull Param param) {
        if (param == null) {
            LoopBranchingNodeImpl.$$$reportNull$$$0(0);
        }
        this.mForeachLoopParam = param;
    }

    @Override
    @Nullable
    public Value getForeachIteratorValue() {
        return this.mForeachLoopValue;
    }

    public void setForeachIteratorValue(@NotNull Value value2) {
        if (value2 == null) {
            LoopBranchingNodeImpl.$$$reportNull$$$0(1);
        }
        this.mForeachLoopValue = value2;
    }

    @Override
    public int getLoopType() {
        return this.mLoopType;
    }

    public LoopBranchingNodeImpl(BlockGraph parentGraph, int loopType) {
        super(parentGraph);
        this.mLoopType = loopType;
        this.breakNodeList = Lists.newArrayList();
        this.continueNodeList = Lists.newArrayList();
    }

    public void setConditionCheckEntry(GraphNode checkEntry) {
        this.mConditionCheckEntryNode = checkEntry;
    }

    public void setConditionCheckExitNode(GraphNode checkExit) {
        this.mConditionCheckExitNode = checkExit;
    }

    public void setPostLoopEntryNode(GraphNode postLoopEntry) {
        this.mPostLoopEntryNode = postLoopEntry;
    }

    public void setPostLoopExitNode(GraphNode postLoopExit) {
        this.mPostLoopExitNode = postLoopExit;
    }

    public void setLoopBody(BlockGraph loopBody) {
        this.mLoopBody = loopBody;
    }

    public void addBreak(GraphNode breakNode) {
        this.breakNodeList.add(breakNode);
    }

    public void addContinue(GraphNode continueNode) {
        this.continueNodeList.add(continueNode);
    }

    public void processBreaks() {
        if (this.mLoopType == 3) {
            GraphNode bodyExit = this.mLoopBody.getExitNode();
            for (GraphNode breakNode : this.breakNodeList) {
                GraphNodeUtil.connectGraphNode(breakNode, bodyExit);
            }
            this.breakNodeList.clear();
        } else {
            if (this.mConditionCheckExitNode == null) {
                return;
            }
            GraphNode falseBranch = ((ConditionCheckNode)this.mConditionCheckExitNode).getFalseBranch();
            for (GraphNode breakNode : this.breakNodeList) {
                GraphNodeUtil.connectGraphNode(breakNode, falseBranch);
            }
            this.breakNodeList.clear();
        }
    }

    public void processContinues() {
        if (this.mLoopType == 3) {
            for (GraphNode continueNode : this.continueNodeList) {
                GraphNodeUtil.connectGraphNode(continueNode, this);
            }
        } else {
            if (this.mConditionCheckEntryNode == null) {
                return;
            }
            for (GraphNode continueNode : this.continueNodeList) {
                GraphNodeUtil.connectGraphNode(continueNode, this.mConditionCheckEntryNode);
            }
            this.continueNodeList.clear();
        }
    }

    public void connectSpecialNodes() {
        this.processBreaks();
        this.processContinues();
    }

    @Override
    public String getSimpleName() {
        String loopTypeName = "";
        switch (this.mLoopType) {
            case 0: {
                loopTypeName = "[FOR LOOP]";
                break;
            }
            case 1: {
                loopTypeName = "[WHILE LOOP]";
                break;
            }
            case 2: {
                loopTypeName = "[DOWHILE LOOP]";
            }
            case 3: {
                loopTypeName = "[FOREACH LOOP]";
                break;
            }
        }
        return String.format("%s", loopTypeName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/experimental/codeanalysis/datastructs/graph/node/impl/LoopBranchingNodeImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setForeachIteratorParam";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setForeachIteratorValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

