/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.preview;

import com.android.tools.idea.editors.theme.preview.ToolbarComponentDefinition;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Color;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class ThemePreviewBuilder {
    public static final String BUILDER_URI = "http://schemas.android.com/tools/preview/builder";
    public static final String BUILDER_NS_NAME = "builder";
    public static final String BUILDER_ATTR_GROUP = "group";
    static final String THEME_PREVIEW_LAYOUT = "com.android.tools.idea.editors.theme.widgets.ThemePreviewLayout";
    private static final Map<String, String> NAMESPACE_TO_URI = ImmutableMap.of((Object)"android", (Object)"http://schemas.android.com/apk/res/android", (Object)"app", (Object)"http://schemas.android.com/apk/res-auto", (Object)"builder", (Object)"http://schemas.android.com/tools/preview/builder");
    private final ArrayList<Predicate<ComponentDefinition>> myComponentFilters = new ArrayList();
    public static final List<ComponentDefinition> AVAILABLE_BASE_COMPONENTS = ImmutableList.of((Object)ToolbarComponentDefinition.getFrameworkToolbar(), (Object)new ComponentDefinition("Normal", ComponentGroup.RAISED_BUTTON, "Button"), (Object)new ComponentDefinition("Disabled", ComponentGroup.RAISED_BUTTON, "Button").set("enabled", "false"), (Object)new ComponentDefinition("Normal", ComponentGroup.FLAT_BUTTON, "Button").set(null, "style", "?android:attr/borderlessButtonStyle"), (Object)new ComponentDefinition("Disabled", ComponentGroup.FLAT_BUTTON, "Button").set(null, "style", "?android:attr/borderlessButtonStyle").set("enabled", "false"), (Object)new ComponentDefinition("Radio button", ComponentGroup.RADIO_BUTTON, "RadioButton").setText(""), (Object)new ComponentDefinition("Pressed Radio button", ComponentGroup.RADIO_BUTTON, "RadioButton").set("checked", "true").setText(""), (Object)new ComponentDefinition("Checkbox", ComponentGroup.CHECKBOX, "CheckBox").setText(""), (Object)new ComponentDefinition("Pressed Checkbox", ComponentGroup.CHECKBOX, "CheckBox").set("checked", "true").setText(""), (Object)new ComponentDefinition("Switch", ComponentGroup.SWITCH, "Switch").setApiLevel(14).setText(""), (Object)new ComponentDefinition("On Switch", ComponentGroup.SWITCH, "Switch").setApiLevel(14).set("checked", "true").setText(""), (Object)new ComponentDefinition("Large text", ComponentGroup.TEXT, "TextView").set("textAppearance", "?android:attr/textAppearanceLarge"), (Object[])new ComponentDefinition[]{new ComponentDefinition("Medium text", ComponentGroup.TEXT, "TextView").set("textAppearance", "?android:attr/textAppearanceMedium"), new ComponentDefinition("Small text", ComponentGroup.TEXT, "TextView").set("textAppearance", "?android:attr/textAppearanceSmall"), new ComponentDefinition("Status bar", ComponentGroup.STATUS_BAR, "com.android.layoutlib.bridge.bars.StatusBar").set("layout_width", "match_parent"), new ComponentDefinition("ProgressBar", ComponentGroup.INDETERMINATE_PROGRESSBAR, "ProgressBar").set("progress", "50").set("layout_width", "match_parent"), new ComponentDefinition("ProgressBar", ComponentGroup.HORIZONTAL_PROGRESSBAR, "ProgressBar").set("progress", "50").set("layout_width", "match_parent").set(null, "style", "?android:attr/progressBarStyleHorizontal"), new ComponentDefinition("SeekBar", ComponentGroup.SLIDERS, "SeekBar").set("progress", "50").set("layout_width", "match_parent")});
    private static final int GROUP_TITLE_FONT_SIZE = 11;
    private final List<ComponentDefinition> myComponents = new ArrayList<ComponentDefinition>();
    private String myGroupHeaderColor = "@android:color/darker_gray";
    private String myBackgroundColor = "@android:color/darker_gray";
    private PrintStream myDebugPrintStream;

    @NotNull
    private static Element buildGridLayoutElement(@NotNull Document document, int maxColumns, int minColumnWidth, int maxColumnWidth, int itemHorizontalMargin, int itemVerticalMargin) {
        if (document == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(0);
        }
        Element layout2 = document.createElement(THEME_PREVIEW_LAYOUT);
        ThemePreviewBuilder.setAttribute(layout2, "layout_width", "wrap_content");
        ThemePreviewBuilder.setAttribute(layout2, "layout_height", "wrap_content");
        layout2.setAttribute("max_columns", Integer.toString(maxColumns));
        if (minColumnWidth >= 0) {
            layout2.setAttribute("min_column_width", Integer.toString(minColumnWidth));
        }
        if (maxColumnWidth >= 0) {
            layout2.setAttribute("max_column_width", Integer.toString(maxColumnWidth));
        }
        if (itemHorizontalMargin >= 0) {
            layout2.setAttribute("item_horizontal_margin", Integer.toString(itemHorizontalMargin));
        }
        if (itemVerticalMargin >= 0) {
            layout2.setAttribute("item_vertical_margin", Integer.toString(itemVerticalMargin));
        }
        Element element = layout2;
        if (element == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(1);
        }
        return element;
    }

    @NotNull
    private static Element buildElementGroup(@NotNull Document document, @NotNull ComponentGroup group, @NotNull String groupColor, @NotNull List<ComponentDefinition> components, boolean supressErrors) {
        if (document == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(2);
        }
        if (group == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(3);
        }
        if (groupColor == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(4);
        }
        if (components == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(5);
        }
        Element componentGrouper = document.createElement("FrameLayout");
        ThemePreviewBuilder.setAttribute(componentGrouper, "layout_width", "match_parent");
        ThemePreviewBuilder.setAttribute(componentGrouper, "layout_height", "match_parent");
        ThemePreviewBuilder.setAttribute(componentGrouper, "background", "?android:attr/colorBackground");
        ThemePreviewBuilder.setAttribute(componentGrouper, "paddingTop", ThemePreviewBuilder.toDp(5));
        ThemePreviewBuilder.setAttribute(componentGrouper, "paddingRight", ThemePreviewBuilder.toDp(10));
        ThemePreviewBuilder.setAttribute(componentGrouper, "paddingLeft", ThemePreviewBuilder.toDp(10));
        ThemePreviewBuilder.setAttribute(componentGrouper, "paddingBottom", ThemePreviewBuilder.toDp(10));
        componentGrouper.setAttributeNS(BUILDER_URI, BUILDER_ATTR_GROUP, group.name());
        Element elementGroup = document.createElement("LinearLayout");
        ThemePreviewBuilder.setAttribute(elementGroup, "layout_width", "match_parent");
        ThemePreviewBuilder.setAttribute(elementGroup, "layout_height", "match_parent");
        ThemePreviewBuilder.setAttribute(elementGroup, "orientation", group.orientation);
        ThemePreviewBuilder.setAttribute(elementGroup, "layout_marginTop", ThemePreviewBuilder.toDp(30));
        ThemePreviewBuilder.setAttribute(elementGroup, "layout_marginBottom", ThemePreviewBuilder.toDp(30));
        ThemePreviewBuilder.setAttribute(elementGroup, "gravity", "center");
        elementGroup.setAttributeNS(BUILDER_URI, BUILDER_ATTR_GROUP, group.name());
        Element groupTitle = document.createElement("TextView");
        ThemePreviewBuilder.setAttribute(groupTitle, "layout_width", "match_parent");
        ThemePreviewBuilder.setAttribute(groupTitle, "layout_height", "wrap_content");
        ThemePreviewBuilder.setAttribute(groupTitle, "textSize", ThemePreviewBuilder.toSp(11));
        ThemePreviewBuilder.setAttribute(groupTitle, "textColor", groupColor);
        ThemePreviewBuilder.setAttribute(groupTitle, "text", group.name);
        ThemePreviewBuilder.setAttribute(groupTitle, "layout_gravity", "bottom");
        groupTitle.setAttributeNS(BUILDER_URI, BUILDER_ATTR_GROUP, group.name());
        for (ComponentDefinition definition : components) {
            elementGroup.appendChild(definition.build(document));
        }
        componentGrouper.appendChild(elementGroup);
        componentGrouper.appendChild(groupTitle);
        Element element = componentGrouper;
        if (element == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(6);
        }
        return element;
    }

    @NotNull
    private List<ComponentDefinition> getComponentsByGroup(final @NotNull ComponentGroup group) {
        if (group == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(7);
        }
        ImmutableList immutableList = ImmutableList.copyOf((Iterable)Iterables.filter(this.myComponents, (Predicate)new Predicate<ComponentDefinition>(){

            public boolean apply(ComponentDefinition input) {
                if (group != input.group) {
                    return false;
                }
                for (Predicate filter2 : ThemePreviewBuilder.this.myComponentFilters) {
                    if (filter2.apply((Object)input)) continue;
                    return false;
                }
                return true;
            }
        }));
        if (immutableList == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    private static void printDebug(@NotNull PrintStream out, @NotNull Document document) {
        if (out == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(9);
        }
        if (document == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(10);
        }
        try {
            DOMImplementationRegistry reg = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)reg.getDOMImplementation("LS"));
            LSSerializer serializer = impl.createLSSerializer();
            LSOutput lsOutput = impl.createLSOutput();
            lsOutput.setEncoding("UTF-8");
            lsOutput.setByteStream(out);
            serializer.write(document, lsOutput);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace(out);
        }
        catch (InstantiationException e) {
            e.printStackTrace(out);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace(out);
        }
    }

    private static String toDp(int n) {
        return String.format("%ddp", n);
    }

    private static String toSp(int n) {
        return String.format("%dsp", n);
    }

    private static void setAttribute(Element element, String name, String value2) {
        element.setAttributeNS("http://schemas.android.com/apk/res/android", name, value2);
    }

    private static void setAttributeIfAbsent(Element element, String name, String value2) {
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", name)) {
            ThemePreviewBuilder.setAttribute(element, name, value2);
        }
    }

    @NotNull
    public ThemePreviewBuilder addComponentFilter(@NotNull Predicate<ComponentDefinition> filter2) {
        if (filter2 == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(11);
        }
        this.myComponentFilters.add(filter2);
        ThemePreviewBuilder themePreviewBuilder = this;
        if (themePreviewBuilder == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(12);
        }
        return themePreviewBuilder;
    }

    @NotNull
    public ThemePreviewBuilder addAllComponents(@NotNull List<ComponentDefinition> definitions) {
        if (definitions == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(13);
        }
        this.myComponents.addAll(definitions);
        ThemePreviewBuilder themePreviewBuilder = this;
        if (themePreviewBuilder == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(14);
        }
        return themePreviewBuilder;
    }

    @NotNull
    public ThemePreviewBuilder addComponent(@NotNull ComponentDefinition definition) {
        if (definition == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(15);
        }
        this.addAllComponents((List<ComponentDefinition>)ImmutableList.of((Object)definition));
        ThemePreviewBuilder themePreviewBuilder = this;
        if (themePreviewBuilder == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(16);
        }
        return themePreviewBuilder;
    }

    @NotNull
    public ThemePreviewBuilder addNavigationBar(boolean supportsThemePreviewNavigationBar) {
        String navigationBarClass = supportsThemePreviewNavigationBar ? "com.android.layoutlib.bridge.bars.ThemePreviewNavigationBar" : "com.android.layoutlib.bridge.bars.NavigationBar";
        ComponentDefinition navigationBar = new ComponentDefinition("Navigation bar", ComponentGroup.NAVIGATION_BAR, navigationBarClass).set("layout_height", "@android:dimen/navigation_bar_height").set("layout_width", "match_parent");
        ThemePreviewBuilder themePreviewBuilder = this.addComponent(navigationBar);
        if (themePreviewBuilder == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(17);
        }
        return themePreviewBuilder;
    }

    @NotNull
    public ThemePreviewBuilder setGroupHeaderColor(@NotNull String color) {
        if (color == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(18);
        }
        this.myGroupHeaderColor = color;
        ThemePreviewBuilder themePreviewBuilder = this;
        if (themePreviewBuilder == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(19);
        }
        return themePreviewBuilder;
    }

    @NotNull
    public ThemePreviewBuilder setGroupHeaderColor(@NotNull Color color) {
        if (color == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(20);
        }
        this.setGroupHeaderColor('#' + Integer.toHexString(color.getRGB()));
        ThemePreviewBuilder themePreviewBuilder = this;
        if (themePreviewBuilder == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(21);
        }
        return themePreviewBuilder;
    }

    public ThemePreviewBuilder setBackgroundColor(@NotNull String color) {
        if (color == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(22);
        }
        this.myBackgroundColor = color;
        return this;
    }

    public ThemePreviewBuilder setBackgroundColor(@NotNull Color color) {
        if (color == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(23);
        }
        this.setBackgroundColor('#' + Integer.toHexString(color.getRGB()));
        return this;
    }

    public ThemePreviewBuilder setDebug(@NotNull PrintStream printStream) {
        if (printStream == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(24);
        }
        this.myDebugPrintStream = printStream;
        return this;
    }

    @NotNull
    public Document build() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element backgroundLayout = document.createElement("LinearLayout");
        ThemePreviewBuilder.setAttribute(backgroundLayout, "layout_width", "match_parent");
        ThemePreviewBuilder.setAttribute(backgroundLayout, "layout_height", "match_parent");
        ThemePreviewBuilder.setAttribute(backgroundLayout, "paddingTop", ThemePreviewBuilder.toDp(20));
        ThemePreviewBuilder.setAttribute(backgroundLayout, "paddingBottom", ThemePreviewBuilder.toDp(20));
        ThemePreviewBuilder.setAttribute(backgroundLayout, "orientation", "vertical");
        ThemePreviewBuilder.setAttribute(backgroundLayout, "gravity", "center_horizontal");
        ThemePreviewBuilder.setAttribute(backgroundLayout, "background", this.myBackgroundColor);
        Element layout2 = ThemePreviewBuilder.buildGridLayoutElement(document, 3, 270, 270, 25, 15);
        backgroundLayout.appendChild(layout2);
        document.appendChild(backgroundLayout);
        for (ComponentGroup group : ComponentGroup.values()) {
            List<ComponentDefinition> components = this.getComponentsByGroup(group);
            if (components.isEmpty()) continue;
            Element elementGroup = ThemePreviewBuilder.buildElementGroup(document, group, this.myGroupHeaderColor, components, group == ComponentGroup.CUSTOM);
            layout2.appendChild(elementGroup);
        }
        if (this.myDebugPrintStream != null) {
            ThemePreviewBuilder.printDebug(this.myDebugPrintStream, document);
        }
        Document document2 = document;
        if (document2 == null) {
            ThemePreviewBuilder.$$$reportNull$$$0(25);
        }
        return document2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = BUILDER_ATTR_GROUP;
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupColor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitions";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGridLayoutElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildElementGroup";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentsByGroup";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addComponentFilter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllComponents";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addComponent";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "addNavigationBar";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "setGroupHeaderColor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildGridLayoutElement";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 25: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildElementGroup";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getComponentsByGroup";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "printDebug";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addComponentFilter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addAllComponents";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setGroupHeaderColor";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setBackgroundColor";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setDebug";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SearchFilter
    implements Predicate<ComponentDefinition> {
        private final boolean myCaseSensitive;
        private final String mySearchTerm;

        public SearchFilter(@NotNull String searchTerm, boolean caseSensitive) {
            if (searchTerm == null) {
                SearchFilter.$$$reportNull$$$0(0);
            }
            this.myCaseSensitive = caseSensitive;
            this.mySearchTerm = caseSensitive ? searchTerm : StringUtil.toLowerCase((String)searchTerm);
        }

        public SearchFilter(@NotNull String searchTerm) {
            if (searchTerm == null) {
                SearchFilter.$$$reportNull$$$0(1);
            }
            this(searchTerm, false);
        }

        public boolean apply(ComponentDefinition input) {
            if (Strings.isNullOrEmpty((String)this.mySearchTerm)) {
                return true;
            }
            StringBuilder searchString = new StringBuilder(input.name);
            if (input.aliases != null) {
                searchString.append(' ').append(Joiner.on((char)' ').join(input.aliases));
            }
            searchString.append(' ').append(input.description).append(' ').append(input.group.name);
            return this.myCaseSensitive ? searchString.toString().contains(this.mySearchTerm) : StringUtil.toLowerCase((String)searchString.toString()).contains(this.mySearchTerm);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchTerm", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$SearchFilter", "<init>"));
        }
    }

    public static class ApiLevelFilter
    implements Predicate<ComponentDefinition> {
        private final int myApiLevel;

        public ApiLevelFilter(int apiLevel) {
            this.myApiLevel = apiLevel;
        }

        public boolean apply(ComponentDefinition input) {
            return input.apiLevel <= this.myApiLevel;
        }
    }

    public static class ComponentDefinition {
        private static final AtomicInteger ourCounter = new AtomicInteger(0);
        final String name;
        final ComponentGroup group;
        private final int id;
        final String description;
        final HashMap<String, String> attributes = new HashMap();
        private final int weight;
        int apiLevel;
        List<String> aliases;

        public ComponentDefinition(String description, ComponentGroup group, String name, int weight) {
            this.id = ourCounter.incrementAndGet();
            this.description = description;
            this.name = name;
            this.group = group;
            this.weight = weight;
        }

        public ComponentDefinition(String description, ComponentGroup group, String name) {
            this(description, group, name, 0);
        }

        @NotNull
        public ComponentDefinition set(@Nullable String ns, @NotNull String key, @NotNull String value2) {
            if (key == null) {
                ComponentDefinition.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                ComponentDefinition.$$$reportNull$$$0(1);
            }
            String prefix = ns != null ? ns + ":" : "";
            this.attributes.put(prefix + key, value2);
            ComponentDefinition componentDefinition = this;
            if (componentDefinition == null) {
                ComponentDefinition.$$$reportNull$$$0(2);
            }
            return componentDefinition;
        }

        @NotNull
        public ComponentDefinition set(@NotNull String key, @NotNull String value2) {
            if (key == null) {
                ComponentDefinition.$$$reportNull$$$0(3);
            }
            if (value2 == null) {
                ComponentDefinition.$$$reportNull$$$0(4);
            }
            this.set("android", key, value2);
            ComponentDefinition componentDefinition = this;
            if (componentDefinition == null) {
                ComponentDefinition.$$$reportNull$$$0(5);
            }
            return componentDefinition;
        }

        @NotNull
        public ComponentDefinition setApiLevel(int apiLevel) {
            this.apiLevel = apiLevel;
            ComponentDefinition componentDefinition = this;
            if (componentDefinition == null) {
                ComponentDefinition.$$$reportNull$$$0(6);
            }
            return componentDefinition;
        }

        String getId() {
            return "@+id/widget" + this.id;
        }

        @NotNull
        public ComponentDefinition setText(@NotNull String text) {
            if (text == null) {
                ComponentDefinition.$$$reportNull$$$0(7);
            }
            this.set("text", text);
            ComponentDefinition componentDefinition = this;
            if (componentDefinition == null) {
                ComponentDefinition.$$$reportNull$$$0(8);
            }
            return componentDefinition;
        }

        public ComponentDefinition addAlias(@NotNull String text) {
            if (text == null) {
                ComponentDefinition.$$$reportNull$$$0(9);
            }
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>();
            }
            this.aliases.add(text);
            return this;
        }

        Element build(@NotNull Document document) {
            if (document == null) {
                ComponentDefinition.$$$reportNull$$$0(10);
            }
            Element component = document.createElement(this.name);
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                List keyComponents = Splitter.on((String)":").limit(2).splitToList((CharSequence)entry.getKey());
                if (keyComponents.size() != 1) {
                    component.setAttributeNS((String)NAMESPACE_TO_URI.get(keyComponents.get(0)), (String)keyComponents.get(1), entry.getValue());
                    continue;
                }
                component.setAttribute(entry.getKey(), entry.getValue());
            }
            ThemePreviewBuilder.setAttributeIfAbsent(component, "id", this.getId());
            ThemePreviewBuilder.setAttributeIfAbsent(component, "text", this.description);
            ThemePreviewBuilder.setAttributeIfAbsent(component, "layout_width", "wrap_content");
            ThemePreviewBuilder.setAttributeIfAbsent(component, "layout_height", "wrap_content");
            if (this.weight != 0) {
                ThemePreviewBuilder.setAttributeIfAbsent(component, "layout_weight", Integer.toString(this.weight));
            }
            ThemePreviewBuilder.setAttributeIfAbsent(component, "layout_gravity", "center");
            if (!(component.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_margin") || component.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_marginLeft") || component.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_marginRight") || component.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_marginTop") || component.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_marginBottom") || component.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_marginStart") || component.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_marginEnd"))) {
                ThemePreviewBuilder.setAttribute(component, "layout_marginStart", ThemePreviewBuilder.toDp(12));
                ThemePreviewBuilder.setAttribute(component, "layout_marginLeft", ThemePreviewBuilder.toDp(12));
                ThemePreviewBuilder.setAttribute(component, "layout_marginEnd", ThemePreviewBuilder.toDp(12));
                ThemePreviewBuilder.setAttribute(component, "layout_marginRight", ThemePreviewBuilder.toDp(12));
            }
            component.setAttributeNS(ThemePreviewBuilder.BUILDER_URI, ThemePreviewBuilder.BUILDER_ATTR_GROUP, this.group.name());
            return component;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComponentDefinition that = (ComponentDefinition)o;
            return Objects.equal((Object)((Object)this.group), (Object)((Object)that.group)) && Objects.equal((Object)this.name, (Object)that.name);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.group, this.name});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$ComponentDefinition";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$ComponentDefinition";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "set";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setApiLevel";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "set";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 8: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setText";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addAlias";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ComponentGroup {
        TOOLBAR("App bar", "vertical"),
        RAISED_BUTTON("Raised button", "vertical"),
        FLAT_BUTTON("Flat button", "vertical"),
        FAB_BUTTON("Fab button", "horizontal"),
        HORIZONTAL_PROGRESSBAR("Horizontal Progressbar", "horizontal"),
        INDETERMINATE_PROGRESSBAR("Progressbar (indeterminate)", "horizontal"),
        SLIDERS("Seekbar", "horizontal"),
        RADIO_BUTTON("Radiobutton", "horizontal"),
        CHECKBOX("Checkbox", "horizontal"),
        SWITCH("Switch", "horizontal"),
        TEXT("TextView", "vertical"),
        NAVIGATION_BAR("Navigation bar", "horizontal"),
        STATUS_BAR("Status bar", "horizontal"),
        CUSTOM("Custom", "vertical");

        final String name;
        final String orientation;

        private ComponentGroup(String name, String orientation) {
            if (name == null) {
                ComponentGroup.$$$reportNull$$$0(0);
            }
            if (orientation == null) {
                ComponentGroup.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.orientation = orientation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "orientation";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$ComponentGroup";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

