/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.datamodels;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeEditorVirtualFile;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorStyle {
    private static final Logger LOG = Logger.getInstance(ThemeEditorStyle.class);
    @NotNull
    private final ConfigurationManager myManager;
    @NotNull
    private final ResourceReference myStyleReference;

    @Deprecated
    public ThemeEditorStyle(@NotNull ConfigurationManager manager, @NotNull String qualifiedName) {
        if (manager == null) {
            ThemeEditorStyle.$$$reportNull$$$0(0);
        }
        if (qualifiedName == null) {
            ThemeEditorStyle.$$$reportNull$$$0(1);
        }
        this(manager, ResolutionUtils.getStyleReference(qualifiedName));
    }

    public ThemeEditorStyle(@NotNull ConfigurationManager manager, @NotNull ResourceReference styleReference) {
        if (manager == null) {
            ThemeEditorStyle.$$$reportNull$$$0(2);
        }
        if (styleReference == null) {
            ThemeEditorStyle.$$$reportNull$$$0(3);
        }
        this.myManager = manager;
        this.myStyleReference = styleReference;
    }

    @NotNull
    public final ResourceReference getStyleReference() {
        ResourceReference resourceReference = this.myStyleReference;
        if (resourceReference == null) {
            ThemeEditorStyle.$$$reportNull$$$0(4);
        }
        return resourceReference;
    }

    @NotNull
    public String getQualifiedName() {
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getOrCreateInstance(this.myManager.getModule());
        if (repositoryManager == null || repositoryManager.getNamespace().equals((Object)this.myStyleReference.getNamespace())) {
            String string = this.myStyleReference.getName();
            if (string == null) {
                ThemeEditorStyle.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = this.myStyleReference.getQualifiedName();
        if (string == null) {
            ThemeEditorStyle.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myStyleReference.getName();
        if (string == null) {
            ThemeEditorStyle.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isFramework() {
        return this.myStyleReference.getNamespace().equals((Object)ResourceNamespace.ANDROID);
    }

    public boolean isProjectStyle() {
        if (this.isFramework()) {
            return false;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getOrCreateInstance(this.myManager.getModule());
        assert (repositoryManager != null);
        LocalResourceRepository repository = repositoryManager.getProjectResources(true);
        return repository.hasResources(this.myStyleReference.getNamespace(), this.myStyleReference.getResourceType(), this.myStyleReference.getName());
    }

    @NotNull
    protected Collection<ResourceItem> getStyleResourceItems() {
        assert (!this.isFramework());
        Module module = this.myManager.getModule();
        if (this.isProjectStyle()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            assert (facet != null) : module.getName() + " module doesn't have AndroidFacet";
            HashMap resourceItems = new HashMap();
            ThemeEditorUtils.acceptResourceResolverVisitor(facet, (resources, moduleName, variantName, isSourceSelected) -> {
                if (!isSourceSelected) {
                    return;
                }
                List items2 = resources.getResources(this.myStyleReference.getNamespace(), this.myStyleReference.getResourceType(), this.myStyleReference.getName());
                for (ResourceItem item : items2) {
                    String key = item.getConfiguration().toShortDisplayString() + "/" + item.getName();
                    resourceItems.put(key, item);
                }
            });
            ImmutableList immutableList = ImmutableList.copyOf(resourceItems.values());
            if (immutableList == null) {
                ThemeEditorStyle.$$$reportNull$$$0(8);
            }
            return immutableList;
        }
        LocalResourceRepository resources2 = ResourceRepositoryManager.getAppResources(module);
        assert (resources2 != null);
        List list = resources2.getResources(this.myStyleReference.getNamespace(), this.myStyleReference.getResourceType(), this.myStyleReference.getName());
        if (list == null) {
            ThemeEditorStyle.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public Collection<FolderConfiguration> getFolders() {
        if (this.isFramework()) {
            ImmutableList immutableList = ImmutableList.of((Object)new FolderConfiguration());
            if (immutableList == null) {
                ThemeEditorStyle.$$$reportNull$$$0(10);
            }
            return immutableList;
        }
        ImmutableList.Builder result2 = ImmutableList.builder();
        for (ResourceItem styleItem : this.getStyleResourceItems()) {
            result2.add((Object)styleItem.getConfiguration());
        }
        ImmutableList immutableList = result2.build();
        if (immutableList == null) {
            ThemeEditorStyle.$$$reportNull$$$0(11);
        }
        return immutableList;
    }

    @NotNull
    public Collection<StyleItemResourceValue> getValues(@NotNull FolderConfiguration configuration) {
        if (configuration == null) {
            ThemeEditorStyle.$$$reportNull$$$0(12);
        }
        if (this.isFramework()) {
            IAndroidTarget target = this.myManager.getHighestApiTarget();
            assert (target != null);
            ResourceRepository frameworkResources = this.myManager.getResolverCache().getFrameworkResources(new FolderConfiguration(), target);
            if (frameworkResources != null) {
                List styleItems = frameworkResources.getResources(ResourceNamespace.ANDROID, ResourceType.STYLE, this.getName());
                for (ResourceItem item : styleItems) {
                    StyleResourceValue style;
                    if (!item.getConfiguration().equals((Object)configuration) || (style = (StyleResourceValue)item.getResourceValue()) == null) continue;
                    Collection collection = style.getDefinedItems();
                    if (collection == null) {
                        ThemeEditorStyle.$$$reportNull$$$0(13);
                    }
                    return collection;
                }
            }
            throw new IllegalArgumentException("bad folder config " + configuration);
        }
        for (ResourceItem styleItem : this.getStyleResourceItems()) {
            StyleResourceValue style;
            if (!configuration.equals((Object)styleItem.getConfiguration()) || (style = (StyleResourceValue)styleItem.getResourceValue()) == null) continue;
            Collection collection = style.getDefinedItems();
            if (collection == null) {
                ThemeEditorStyle.$$$reportNull$$$0(14);
            }
            return collection;
        }
        throw new IllegalArgumentException("bad folder config " + configuration);
    }

    @Nullable
    public String getParentName(@NotNull FolderConfiguration configuration) {
        if (configuration == null) {
            ThemeEditorStyle.$$$reportNull$$$0(15);
        }
        if (this.isFramework()) {
            IAndroidTarget target = this.myManager.getHighestApiTarget();
            assert (target != null);
            ResourceRepository frameworkResources = this.myManager.getResolverCache().getFrameworkResources(new FolderConfiguration(), target);
            if (frameworkResources != null) {
                List styleItems = frameworkResources.getResources(ResourceNamespace.ANDROID, ResourceType.STYLE, this.getName());
                for (ResourceItem item : styleItems) {
                    StyleResourceValue style;
                    if (!item.getConfiguration().equals((Object)configuration) || (style = (StyleResourceValue)item.getResourceValue()) == null) continue;
                    return ResolutionUtils.getParentQualifiedName(style);
                }
            }
            throw new IllegalArgumentException("bad folder config " + configuration);
        }
        for (ResourceItem styleItem : this.getStyleResourceItems()) {
            if (!configuration.equals((Object)styleItem.getConfiguration())) continue;
            StyleResourceValue style = (StyleResourceValue)styleItem.getResourceValue();
            assert (style != null);
            return ResolutionUtils.getParentQualifiedName(style);
        }
        throw new IllegalArgumentException("bad folder config " + configuration);
    }

    @Nullable
    private XmlTag findXmlTagFromConfiguration(@NotNull FolderConfiguration configuration) {
        if (configuration == null) {
            ThemeEditorStyle.$$$reportNull$$$0(16);
        }
        for (ResourceItem item : this.getStyleResourceItems()) {
            if (!item.getConfiguration().equals((Object)configuration)) continue;
            return LocalResourceRepository.getItemTag(this.myManager.getProject(), item);
        }
        return null;
    }

    @NotNull
    private ImmutableCollection<FolderConfiguration> findToBeCopied(int desiredApi) {
        HashMap<FolderConfiguration, VersionQualifier> bestVersionCopyFrom = new HashMap<FolderConfiguration, VersionQualifier>();
        for (ResourceItem styleItem : this.getStyleResourceItems()) {
            FolderConfiguration configuration = FolderConfiguration.copyOf((FolderConfiguration)styleItem.getConfiguration());
            int styleItemVersion = ThemeEditorUtils.getVersionFromConfiguration(configuration);
            configuration.setVersionQualifier(null);
            if (styleItemVersion > desiredApi || bestVersionCopyFrom.containsKey(configuration) && ((VersionQualifier)bestVersionCopyFrom.get(configuration)).getVersion() >= styleItemVersion) continue;
            bestVersionCopyFrom.put(configuration, new VersionQualifier(styleItemVersion));
        }
        ImmutableList.Builder toBeCopied = ImmutableList.builder();
        for (FolderConfiguration key : bestVersionCopyFrom.keySet()) {
            FolderConfiguration configuration = FolderConfiguration.copyOf((FolderConfiguration)key);
            VersionQualifier version2 = (VersionQualifier)bestVersionCopyFrom.get(key);
            if (version2.getVersion() != -1) {
                configuration.setVersionQualifier(version2);
            }
            if (version2.getVersion() >= desiredApi) continue;
            toBeCopied.add((Object)configuration);
        }
        ImmutableList immutableList = toBeCopied.build();
        if (immutableList == null) {
            ThemeEditorStyle.$$$reportNull$$$0(17);
        }
        return immutableList;
    }

    private void setValue(@NotNull FolderConfiguration configuration, @NotNull String attribute, @NotNull String value2) {
        if (configuration == null) {
            ThemeEditorStyle.$$$reportNull$$$0(18);
        }
        if (attribute == null) {
            ThemeEditorStyle.$$$reportNull$$$0(19);
        }
        if (value2 == null) {
            ThemeEditorStyle.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XmlTag styleTag = this.findXmlTagFromConfiguration(configuration);
        assert (styleTag != null);
        XmlTag tag = this.getValueTag(styleTag, attribute);
        if (tag != null) {
            tag.getValue().setEscapedText(value2);
        } else {
            XmlTag child = styleTag.createChildTag("item", styleTag.getNamespace(), value2, false);
            child.setAttribute("name", attribute);
            styleTag.addSubTag(child, false);
        }
    }

    public void setValue(final @NotNull String attribute, final @NotNull String value2) {
        int minSdk;
        if (attribute == null) {
            ThemeEditorStyle.$$$reportNull$$$0(21);
        }
        if (value2 == null) {
            ThemeEditorStyle.$$$reportNull$$$0(22);
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        final Project project = this.myManager.getProject();
        int maxApi = Math.max(ResolutionUtils.getOriginalApiLevel(value2, this.myManager.getProject()), ResolutionUtils.getOriginalApiLevel(attribute, project));
        final int desiredApi = maxApi <= (minSdk = ThemeEditorUtils.getMinApiLevel(this.myManager.getModule())) ? -1 : maxApi;
        new WriteCommandAction.Simple(project, "Setting value of " + attribute, new PsiFile[0]){

            protected void run() {
                AndroidFacet facet;
                CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{ThemeEditorVirtualFile.getThemeEditorFile(project)});
                ImmutableCollection toBeCopied = ThemeEditorStyle.this.findToBeCopied(desiredApi);
                for (FolderConfiguration configuration : toBeCopied) {
                    XmlTag styleTag = ThemeEditorStyle.this.findXmlTagFromConfiguration(configuration);
                    assert (styleTag != null);
                    ThemeEditorUtils.copyTheme(desiredApi, styleTag);
                }
                if (!toBeCopied.isEmpty() && (facet = AndroidFacet.getInstance(ThemeEditorStyle.this.myManager.getModule())) != null) {
                    ResourceRepositoryManager.getOrCreateInstance(facet).resetAllCaches();
                    FileDocumentManager.getInstance().saveAllDocuments();
                }
                Collection<ResourceItem> styleItems = ThemeEditorStyle.this.getStyleResourceItems();
                for (ResourceItem style : styleItems) {
                    FolderConfiguration configuration = style.getConfiguration();
                    int version2 = ThemeEditorUtils.getVersionFromConfiguration(configuration);
                    if (version2 < desiredApi) continue;
                    ThemeEditorStyle.this.setValue(configuration, attribute, value2);
                }
            }
        }.execute();
    }

    private void setParent(@NotNull FolderConfiguration configuration, @NotNull String newParent) {
        if (configuration == null) {
            ThemeEditorStyle.$$$reportNull$$$0(23);
        }
        if (newParent == null) {
            ThemeEditorStyle.$$$reportNull$$$0(24);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XmlTag styleTag = this.findXmlTagFromConfiguration(configuration);
        assert (styleTag != null);
        styleTag.setAttribute("parent", newParent);
    }

    public void setParent(final @NotNull String qualifiedThemeName) {
        int minSdk;
        Project project;
        if (qualifiedThemeName == null) {
            ThemeEditorStyle.$$$reportNull$$$0(25);
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        assert (!qualifiedThemeName.startsWith("@android:style/"));
        assert (!qualifiedThemeName.startsWith("@style/"));
        String newParentResourceUrl = ResolutionUtils.getStyleResourceUrl(qualifiedThemeName);
        int parentApi = ResolutionUtils.getOriginalApiLevel(newParentResourceUrl, project = this.myManager.getProject());
        final int desiredApi = parentApi <= (minSdk = ThemeEditorUtils.getMinApiLevel(this.myManager.getModule())) ? -1 : parentApi;
        new WriteCommandAction.Simple(project, "Updating Parent to " + qualifiedThemeName, new PsiFile[0]){

            protected void run() {
                AndroidFacet facet;
                CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{ThemeEditorVirtualFile.getThemeEditorFile(project)});
                ImmutableCollection toBeCopied = ThemeEditorStyle.this.findToBeCopied(desiredApi);
                for (FolderConfiguration configuration : toBeCopied) {
                    XmlTag styleTag = ThemeEditorStyle.this.findXmlTagFromConfiguration(configuration);
                    assert (styleTag != null);
                    ThemeEditorUtils.copyTheme(desiredApi, styleTag);
                }
                if (!toBeCopied.isEmpty() && (facet = AndroidFacet.getInstance(ThemeEditorStyle.this.myManager.getModule())) != null) {
                    ResourceRepositoryManager.getOrCreateInstance(facet).resetAllCaches();
                    FileDocumentManager.getInstance().saveAllDocuments();
                }
                Collection<ResourceItem> styleItems = ThemeEditorStyle.this.getStyleResourceItems();
                for (ResourceItem style : styleItems) {
                    FolderConfiguration configuration = style.getConfiguration();
                    int version2 = ThemeEditorUtils.getVersionFromConfiguration(configuration);
                    if (version2 < desiredApi) continue;
                    ThemeEditorStyle.this.setParent(configuration, qualifiedThemeName);
                }
            }
        }.execute();
    }

    @Nullable
    private XmlTag getValueTag(@NotNull XmlTag sourceTag, final @NotNull String attribute) {
        if (sourceTag == null) {
            ThemeEditorStyle.$$$reportNull$$$0(26);
        }
        if (attribute == null) {
            ThemeEditorStyle.$$$reportNull$$$0(27);
        }
        if (!this.isProjectStyle()) {
            return null;
        }
        final Ref resultXmlTag = new Ref();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        sourceTag.acceptChildren(new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                if (!(element instanceof XmlTag)) {
                    return;
                }
                XmlTag tag = (XmlTag)element;
                if ("item".equals(tag.getName()) && attribute.equals(tag.getAttributeValue("name"))) {
                    resultXmlTag.set((Object)tag);
                }
            }
        });
        return (XmlTag)resultXmlTag.get();
    }

    public void removeAttribute(@NotNull String attribute) {
        if (attribute == null) {
            ThemeEditorStyle.$$$reportNull$$$0(28);
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        final Project project = this.myManager.getProject();
        HashSet<PsiFile> toBeEdited = new HashSet<PsiFile>();
        final HashSet<XmlTag> toBeRemoved = new HashSet<XmlTag>();
        for (ResourceItem resourceItem : this.getStyleResourceItems()) {
            XmlTag sourceXml = LocalResourceRepository.getItemTag(project, resourceItem);
            assert (sourceXml != null);
            XmlTag tag = this.getValueTag(sourceXml, attribute);
            if (tag == null) continue;
            toBeEdited.add(tag.getContainingFile());
            toBeRemoved.add(tag);
        }
        new WriteCommandAction.Simple(project, "Removing " + attribute, toBeEdited.toArray(PsiFile.EMPTY_ARRAY)){

            protected void run() {
                CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{ThemeEditorVirtualFile.getThemeEditorFile(project)});
                for (XmlTag tag : toBeRemoved) {
                    tag.delete();
                }
            }
        }.execute();
    }

    @Nullable
    public PsiElement getNamePsiElement() {
        Collection<ResourceItem> resources = this.getStyleResourceItems();
        if (resources.isEmpty()) {
            return null;
        }
        XmlTag sourceXml = LocalResourceRepository.getItemTag(this.myManager.getProject(), resources.iterator().next());
        assert (sourceXml != null);
        XmlAttribute nameAttribute = sourceXml.getAttribute("name");
        if (nameAttribute == null) {
            return null;
        }
        XmlAttributeValue attributeValue = nameAttribute.getValueElement();
        if (attributeValue == null) {
            return null;
        }
        return new ValueResourceElementWrapper(attributeValue);
    }

    public boolean isPublic() {
        if (!this.isFramework()) {
            return true;
        }
        IAndroidTarget target = this.myManager.getTarget();
        if (target == null) {
            LOG.error("Unable to get IAndroidTarget.");
            return false;
        }
        AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, this.myManager.getModule());
        if (androidTargetData == null) {
            LOG.error("Unable to get AndroidTargetData.");
            return false;
        }
        return androidTargetData.isResourcePublic(ResourceType.STYLE.getName(), this.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleReference";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 19: 
            case 21: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedThemeName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyleReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyleResourceItems";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolders";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findToBeCopied";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getParentName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findXmlTagFromConfiguration";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getValueTag";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

