/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemesListModel;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.model.MergedManifest;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleListCellRenderer
extends ColoredListCellRenderer {
    private final ThemeEditorContext myContext;

    public StyleListCellRenderer(@NotNull ThemeEditorContext context, @Nullable JComboBox comboBox) {
        if (context == null) {
            StyleListCellRenderer.$$$reportNull$$$0(0);
        }
        this.myContext = context;
    }

    public Component getListCellRendererComponent(JList list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
        if (value2 instanceof JSeparator) {
            return (JSeparator)value2;
        }
        return super.getListCellRendererComponent(list, value2, index, isSelected, cellHasFocus);
    }

    protected void customizeCellRenderer(@NotNull JList list, Object value2, int index, boolean selected, boolean hasFocus) {
        if (list == null) {
            StyleListCellRenderer.$$$reportNull$$$0(1);
        }
        if (!(value2 instanceof String)) {
            return;
        }
        String stringValue = (String)value2;
        if (ThemesListModel.isSpecialOption(stringValue) || "[no parent]".equals(stringValue)) {
            this.append(stringValue, SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
            return;
        }
        ConfiguredThemeEditorStyle style = this.myContext.getThemeResolver().getTheme(stringValue);
        if (style == null) {
            this.append(stringValue, SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
            return;
        }
        ConfiguredThemeEditorStyle parent = style.getParent();
        String styleName = style.getName();
        String parentName = parent != null ? parent.getName() : null;
        String defaultAppThemeResourceUrl = null;
        AndroidFacet facet = AndroidFacet.getInstance(this.myContext.getCurrentContextModule());
        if (facet != null) {
            MergedManifest info = MergedManifest.get(facet);
            defaultAppThemeResourceUrl = info.getManifestTheme();
        }
        if (!style.isProjectStyle()) {
            String simplifiedName = ThemeEditorUtils.simplifyThemeName(style);
            String qualifiedStyleName = (style.isFramework() ? "android:" : "") + styleName;
            if (StringUtil.isEmpty((String)simplifiedName)) {
                this.append(qualifiedStyleName, SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
            } else {
                this.append(simplifiedName, SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
                this.append(" [" + qualifiedStyleName + "]", SimpleTextAttributes.GRAY_ATTRIBUTES, false);
            }
        } else if (!selected && parentName != null && styleName.startsWith(parentName + ".")) {
            this.append(parentName + ".", SimpleTextAttributes.GRAY_ATTRIBUTES, false);
            this.append(styleName.substring(parentName.length() + 1), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
        } else {
            this.append(styleName, SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
        }
        if (style.getStyleResourceUrl().equals(defaultAppThemeResourceUrl)) {
            this.append("  -  Default", new SimpleTextAttributes(0, (Color)new JBColor(-11751600, -5908825)), true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/editors/theme/attributes/editors/StyleListCellRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

