/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ColorPalette;
import com.android.tools.idea.editors.theme.attributes.AttributesTableModel;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.res.ResourceHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jetbrains.annotations.NotNull;

public class AttributesModelColorPaletteModel
implements ColorPalette.ColorPaletteModel,
TableModelListener {
    private final ResourceResolver myResourceResolver;
    private final AttributesTableModel myModel;
    private final Project myProject;
    private List<Color> myColorList;
    private final Multimap<Color, EditedStyleItem> myColorReferences;

    public AttributesModelColorPaletteModel(@NotNull Configuration configuration, @NotNull AttributesTableModel model) {
        if (configuration == null) {
            AttributesModelColorPaletteModel.$$$reportNull$$$0(0);
        }
        if (model == null) {
            AttributesModelColorPaletteModel.$$$reportNull$$$0(1);
        }
        this.myColorReferences = HashMultimap.create();
        this.myResourceResolver = configuration.getResourceResolver();
        this.myProject = configuration.getModule().getProject();
        this.myModel = model;
        this.myModel.addTableModelListener(this);
        this.loadColors();
    }

    @Override
    public int getCount() {
        return this.myColorList.size();
    }

    @Override
    @NotNull
    public Color getColorAt(int i2) {
        Color color = this.myColorList.get(i2);
        if (color == null) {
            AttributesModelColorPaletteModel.$$$reportNull$$$0(2);
        }
        return color;
    }

    @Override
    public int indexOf(@NotNull Color c) {
        if (c == null) {
            AttributesModelColorPaletteModel.$$$reportNull$$$0(3);
        }
        return this.myColorList.indexOf(c);
    }

    @Override
    @NotNull
    public String getToolTipAt(int i2) {
        StringBuilder tooltip = new StringBuilder("This color is used in:\n\n");
        for (EditedStyleItem item : this.myColorReferences.get((Object)this.myColorList.get(i2))) {
            tooltip.append(item.getAttrName()).append('\n');
        }
        String string = tooltip.toString();
        if (string == null) {
            AttributesModelColorPaletteModel.$$$reportNull$$$0(4);
        }
        return string;
    }

    private void loadColors() {
        if (this.myResourceResolver == null) {
            this.myColorList = Collections.emptyList();
            return;
        }
        int rows = this.myModel.getRowCount();
        HashMultiset colorSet = HashMultiset.create();
        for (int i2 = 0; i2 < rows; ++i2) {
            if (this.myModel.getCellClass(i2, 0) != Color.class) continue;
            EditedStyleItem item = (EditedStyleItem)this.myModel.getValueAt(i2, 0);
            for (Color color : ResourceHelper.resolveMultipleColors((RenderResources)this.myResourceResolver, (ResourceValue)item.getSelectedValue(), this.myProject)) {
                this.myColorReferences.put((Object)color, (Object)item);
                colorSet.add((Object)color);
            }
        }
        this.myColorList = ImmutableList.copyOf((Collection)Multisets.copyHighestCountFirst((Multiset)colorSet).elementSet());
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.loadColors();
    }

    public List<EditedStyleItem> getReferences(Color color) {
        return ImmutableList.copyOf((Collection)this.myColorReferences.get((Object)color));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/attributes/AttributesModelColorPaletteModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/attributes/AttributesModelColorPaletteModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorAt";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTipAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

