/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.resources.ResourceFolderType;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.editors.theme.ThemeEditor;
import com.android.tools.idea.editors.theme.ThemeEditorState;
import com.android.tools.idea.editors.theme.ThemeEditorVirtualFile;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorProvider
implements FileEditorProvider,
DumbAware {
    private static final String THEME_NAME = "theme-name";
    private static final String STYLE_NAME = "style-name";
    private static final String MODULE_NAME = "module-name";
    private static final String PROPORTION = "proportion";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ThemeEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ThemeEditorProvider.$$$reportNull$$$0(1);
        }
        if (!((Boolean)StudioFlags.THEME_EDITOR_ENABLED.get()).booleanValue()) {
            return false;
        }
        return file instanceof ThemeEditorVirtualFile;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ThemeEditorProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ThemeEditorProvider.$$$reportNull$$$0(3);
        }
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.THEME_EDITOR).setKind(AndroidStudioEvent.EventKind.THEME_EDITOR_OPEN), project));
        ThemeEditor themeEditor = new ThemeEditor(project, file);
        if (themeEditor == null) {
            ThemeEditorProvider.$$$reportNull$$$0(4);
        }
        return themeEditor;
    }

    public void disposeEditor(@NotNull FileEditor editor2) {
        if (editor2 == null) {
            ThemeEditorProvider.$$$reportNull$$$0(5);
        }
        Disposer.dispose((Disposable)editor2);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        if (sourceElement == null) {
            ThemeEditorProvider.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ThemeEditorProvider.$$$reportNull$$$0(7);
        }
        if (file == null) {
            ThemeEditorProvider.$$$reportNull$$$0(8);
        }
        String themeName = sourceElement.getAttributeValue(THEME_NAME);
        String styleName = sourceElement.getAttributeValue(STYLE_NAME);
        String moduleName = sourceElement.getAttributeValue(MODULE_NAME);
        Float proportion = null;
        try {
            String proportionString = sourceElement.getAttributeValue(PROPORTION);
            if (proportionString != null) {
                proportion = Float.valueOf(Float.parseFloat(proportionString));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ThemeEditorState themeEditorState = new ThemeEditorState(themeName, styleName, proportion, moduleName);
        if (themeEditorState == null) {
            ThemeEditorProvider.$$$reportNull$$$0(9);
        }
        return themeEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state == null) {
            ThemeEditorProvider.$$$reportNull$$$0(10);
        }
        if (project == null) {
            ThemeEditorProvider.$$$reportNull$$$0(11);
        }
        if (targetElement == null) {
            ThemeEditorProvider.$$$reportNull$$$0(12);
        }
        if (!(state instanceof ThemeEditorState)) {
            return;
        }
        ThemeEditorState editorState = (ThemeEditorState)state;
        ThemeEditorProvider.setAttributeIfNotNull(targetElement, THEME_NAME, editorState.getThemeName());
        ThemeEditorProvider.setAttributeIfNotNull(targetElement, STYLE_NAME, editorState.getSubStyleName());
        ThemeEditorProvider.setAttributeIfNotNull(targetElement, MODULE_NAME, editorState.getModuleName());
        targetElement.setAttribute(PROPORTION, Float.toString(editorState.getProportion()));
    }

    private static void setAttributeIfNotNull(@NotNull Element targetElement, String paramName, String paramValue) {
        if (targetElement == null) {
            ThemeEditorProvider.$$$reportNull$$$0(13);
        }
        if (paramValue != null) {
            targetElement.setAttribute(paramName, paramValue);
        }
    }

    @NotNull
    public String getEditorTypeId() {
        if ("themeEditor" == null) {
            ThemeEditorProvider.$$$reportNull$$$0(14);
        }
        return "themeEditor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            ThemeEditorProvider.$$$reportNull$$$0(15);
        }
        return fileEditorPolicy;
    }

    public static boolean isAndroidTheme(@Nullable PsiFile file) {
        if (ResourceHelper.getFolderType(file) != ResourceFolderType.VALUES || !(file instanceof XmlFile)) {
            return false;
        }
        String name = file.getName();
        if (name.equals("strings.xml")) {
            return false;
        }
        if (name.equals("styles.xml")) {
            return true;
        }
        XmlTag rootTag = ((XmlFile)file).getRootTag();
        if (rootTag == null || !rootTag.getName().equals("resources")) {
            return false;
        }
        for (XmlTag child : rootTag.getSubTags()) {
            if (!child.getName().equals("style")) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ThemeEditorProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ThemeEditorProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readState";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorTypeId";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "disposeEditor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setAttributeIfNotNull";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

