/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ThemeSelectionDialog;
import com.android.tools.idea.configurations.ThemeSelectionPanel;
import com.android.tools.idea.editors.theme.ParentThemesListModel;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.attributes.editors.StyleListCellRenderer;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewStyleDialog
extends DialogWrapper {
    private final IdeResourceNameValidator myResourceNameValidator;
    private JPanel contentPane;
    private JTextField myStyleNameTextField;
    private JLabel myMessageLabel;
    private JLabel myParentStyleLabel;
    private JLabel myStyleNameLabel;
    private JComboBox myParentStyleComboBox;
    private final String myEmptyStyleValidationText;
    @Nullable
    private ThemeSelectionPanel.ThemeChangedListener myThemeChangedListener;
    private static final String[] COMMON_THEME_NAMES = new String[]{"Material", "Holo", "Leanback", "Micro", "DeviceDefault", "AppCompat"};

    public NewStyleDialog(boolean isTheme, @NotNull ThemeEditorContext context, @Nullable String defaultParentName, @Nullable String currentThemeName, @Nullable String message) {
        if (context == null) {
            NewStyleDialog.$$$reportNull$$$0(0);
        }
        super(true);
        this.$$$setupUI$$$();
        if (!Strings.isNullOrEmpty((String)message)) {
            this.myMessageLabel.setText(message);
            this.myMessageLabel.setVisible(true);
        } else {
            this.myMessageLabel.setVisible(false);
        }
        Configuration configuration = context.getConfiguration();
        this.myResourceNameValidator = IdeResourceNameValidator.forResourceName(ResourceType.STYLE, (ResourceRepository)ResourceRepositoryManager.getAppResources(configuration.getModule()));
        String styleTypeString = isTheme ? "theme" : "style";
        this.setTitle("New " + StringUtil.capitalize((String)styleTypeString));
        this.myStyleNameLabel.setText(String.format("New %1$s name:", styleTypeString));
        this.myParentStyleLabel.setText(String.format("Parent %1$s name:", styleTypeString));
        this.myEmptyStyleValidationText = String.format("You must specify a %1$s name", styleTypeString);
        this.myStyleNameTextField.setText(NewStyleDialog.getNewStyleNameSuggestion(defaultParentName, currentThemeName));
        ThemeResolver themeResolver = context.getThemeResolver();
        ImmutableList<String> defaultThemeNames = ThemeEditorUtils.getDefaultThemeNames(themeResolver);
        this.myParentStyleComboBox.setRenderer(new StyleListCellRenderer(context, this.myParentStyleComboBox));
        ParentThemesListModel parentThemesListModel = new ParentThemesListModel((List<String>)defaultThemeNames, defaultParentName);
        this.myParentStyleComboBox.setModel(parentThemesListModel);
        this.myParentStyleComboBox.addActionListener(e -> {
            String selectedValue = (String)this.myParentStyleComboBox.getSelectedItem();
            if ("Show all themes".equals(selectedValue)) {
                this.myParentStyleComboBox.hidePopup();
                ThemeSelectionDialog dialog = new ThemeSelectionDialog(configuration);
                if (this.myThemeChangedListener != null) {
                    dialog.setThemeChangedListener(this.myThemeChangedListener);
                }
                dialog.show();
                String string = selectedValue = dialog.isOK() ? dialog.getTheme() : null;
            }
            if (selectedValue == null) {
                selectedValue = (String)parentThemesListModel.getElementAt(0);
            } else if (!defaultThemeNames.contains((Object)selectedValue)) {
                parentThemesListModel.removeElement(selectedValue);
                parentThemesListModel.insertElementAt(selectedValue, 0);
            }
            this.myParentStyleComboBox.setSelectedItem(selectedValue);
            this.myStyleNameTextField.setText(NewStyleDialog.getNewStyleNameSuggestion(selectedValue, currentThemeName));
            if (this.myThemeChangedListener != null) {
                this.myThemeChangedListener.themeChanged(selectedValue);
            }
        });
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myStyleNameTextField;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String newStyleName = this.myStyleNameTextField.getText();
        if (Strings.isNullOrEmpty((String)newStyleName)) {
            return new ValidationInfo(this.myEmptyStyleValidationText, (JComponent)this.myStyleNameTextField);
        }
        if (!this.myResourceNameValidator.checkInput(newStyleName)) {
            return new ValidationInfo(this.myResourceNameValidator.getErrorText(newStyleName), (JComponent)this.myStyleNameTextField);
        }
        return super.doValidate();
    }

    public void show() {
        if (this.myThemeChangedListener != null) {
            this.myThemeChangedListener.themeChanged((String)this.myParentStyleComboBox.getSelectedItem());
        }
        super.show();
    }

    public String getStyleName() {
        return this.myStyleNameTextField.getText();
    }

    public String getStyleParentName() {
        return (String)this.myParentStyleComboBox.getSelectedItem();
    }

    @NotNull
    static String getNewStyleNameSuggestion(@Nullable String parentQualifiedName, @Nullable String currentThemeName) {
        if (Strings.isNullOrEmpty((String)parentQualifiedName) || Strings.isNullOrEmpty((String)currentThemeName)) {
            if ("" == null) {
                NewStyleDialog.$$$reportNull$$$0(1);
            }
            return "";
        }
        String parentStyleName = ResolutionUtils.getNameFromQualifiedName(parentQualifiedName);
        if (parentStyleName.equals(currentThemeName)) {
            if ("" == null) {
                NewStyleDialog.$$$reportNull$$$0(2);
            }
            return "";
        }
        currentThemeName = currentThemeName.replace("Theme.", "");
        for (String themeName : COMMON_THEME_NAMES) {
            if (!parentStyleName.matches(".*\\b" + themeName + "\\b.*")) continue;
            String string = parentStyleName.replaceFirst("\\b" + themeName + "\\b", currentThemeName);
            if (string == null) {
                NewStyleDialog.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = parentStyleName + '.' + currentThemeName;
        if (string == null) {
            NewStyleDialog.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setThemeChangedListener(@NotNull ThemeSelectionPanel.ThemeChangedListener themeChangedListener) {
        if (themeChangedListener == null) {
            NewStyleDialog.$$$reportNull$$$0(5);
        }
        this.myThemeChangedListener = themeChangedListener;
    }

    public void enableParentChoice(boolean enable) {
        this.myParentStyleComboBox.setEnabled(enable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/NewStyleDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeChangedListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/NewStyleDialog";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewStyleNameSuggestion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setThemeChangedListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JComboBox jComboBox;
        JLabel jLabel2;
        JTextField jTextField;
        JLabel jLabel3;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myStyleNameLabel = jLabel3 = new JLabel();
        jLabel3.setText("New style name:");
        jLabel3.setDisplayedMnemonic('N');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStyleNameTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myParentStyleLabel = jLabel2 = new JLabel();
        jLabel2.setText("Parent style name:");
        jLabel2.setDisplayedMnemonic('P');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myParentStyleComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 1, 6, 1, null, new Dimension(400, -1), null));
        this.myMessageLabel = jLabel = new JLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jLabel.getFont());
        if (font != null) {
            jLabel.setFont(font);
        }
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 6, 0, null, null, null));
        jLabel3.setLabelFor(jTextField);
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

