/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.StateList;
import com.android.tools.idea.res.StateListState;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ColorUtils {
    private static final Logger LOG = Logger.getInstance(ColorUtils.class);
    @NotNull
    private static final ImmutableSetMultimap<String, String> CONTRAST_MAP;
    @NotNull
    private static final ImmutableSet<String> BACKGROUND_ATTRIBUTES;
    private static final double THRESHOLD = 4.5;
    private static final String DISABLED_PREFIX = "Disabled";

    @NotNull
    public static ImmutableSet<StyleItemResourceValue> getContrastItems(@NotNull ThemeEditorContext context, @NotNull String styleAttributeName) {
        ImmutableSet contrastColorSet;
        if (context == null) {
            ColorUtils.$$$reportNull$$$0(0);
        }
        if (styleAttributeName == null) {
            ColorUtils.$$$reportNull$$$0(1);
        }
        if ((contrastColorSet = CONTRAST_MAP.get((Object)styleAttributeName)) == null) {
            ImmutableSet immutableSet = ImmutableSet.of();
            if (immutableSet == null) {
                ColorUtils.$$$reportNull$$$0(2);
            }
            return immutableSet;
        }
        ImmutableSet.Builder contrastItemsBuilder = ImmutableSet.builder();
        ConfiguredThemeEditorStyle currentTheme = context.getCurrentTheme();
        assert (currentTheme != null);
        for (String contrastColor : contrastColorSet) {
            StyleItemResourceValue contrastItem = ThemeEditorUtils.resolveItemFromParents(currentTheme, contrastColor, false);
            if (contrastItem == null) {
                contrastItem = ThemeEditorUtils.resolveItemFromParents(currentTheme, contrastColor, true);
            }
            if (contrastItem == null) continue;
            contrastItemsBuilder.add((Object)contrastItem);
        }
        ImmutableSet immutableSet = contrastItemsBuilder.build();
        if (immutableSet == null) {
            ColorUtils.$$$reportNull$$$0(3);
        }
        return immutableSet;
    }

    @NotNull
    public static ImmutableMap<String, Color> getContrastColorsWithDescription(@NotNull ThemeEditorContext context, @NotNull String styleAttributeName) {
        if (context == null) {
            ColorUtils.$$$reportNull$$$0(4);
        }
        if (styleAttributeName == null) {
            ColorUtils.$$$reportNull$$$0(5);
        }
        ImmutableMap.Builder contrastColorsBuilder = ImmutableMap.builder();
        ResourceResolver styleResourceResolver = context.getResourceResolver();
        assert (styleResourceResolver != null);
        Project project = context.getProject();
        ImmutableSet<StyleItemResourceValue> contrastItems = ColorUtils.getContrastItems(context, styleAttributeName);
        for (StyleItemResourceValue contrastItem : contrastItems) {
            StateList stateList = ResourceHelper.resolveStateList((RenderResources)styleResourceResolver, (ResourceValue)contrastItem, project);
            if (stateList != null) {
                ImmutableList<StateListState> disabledStates = stateList.getDisabledStates();
                for (StateListState stateListState : stateList.getStates()) {
                    Color stateListColor = ResourceHelper.resolveColor((RenderResources)styleResourceResolver, styleResourceResolver.findResValue(stateListState.getValue(), false), project);
                    if (stateListColor == null) continue;
                    try {
                        stateListColor = ResourceHelper.makeColorWithAlpha((RenderResources)styleResourceResolver, stateListColor, stateListState.getAlpha());
                    }
                    catch (NumberFormatException e) {
                        LOG.warn(String.format("The alpha attribute in %1$s/%2$s does not resolve to a floating point number", stateList.getDirName(), stateList.getFileName()));
                    }
                    String disabledPrefix = disabledStates.contains(stateListState) ? DISABLED_PREFIX : "";
                    contrastColorsBuilder.put((Object)(disabledPrefix + ThemeEditorUtils.generateWordEnumeration(stateListState.getAttributesNames(false)) + " <b>" + contrastItem.getAttrName() + "</b>"), (Object)stateListColor);
                }
                continue;
            }
            Color resolvedColor = ResourceHelper.resolveColor((RenderResources)styleResourceResolver, (ResourceValue)contrastItem, project);
            if (resolvedColor == null) continue;
            contrastColorsBuilder.put((Object)("<b>" + contrastItem.getAttrName() + "</b>"), (Object)resolvedColor);
        }
        ImmutableMap immutableMap = contrastColorsBuilder.build();
        if (immutableMap == null) {
            ColorUtils.$$$reportNull$$$0(6);
        }
        return immutableMap;
    }

    @NotNull
    public static String getContrastWarningMessage(@NotNull Map<String, Color> contrastColorsWithDescription, @NotNull Color color, boolean isBackground) {
        if (contrastColorsWithDescription == null) {
            ColorUtils.$$$reportNull$$$0(7);
        }
        if (color == null) {
            ColorUtils.$$$reportNull$$$0(8);
        }
        ImmutableSet.Builder lowContrastColorsBuilder = ImmutableSet.builder();
        for (Map.Entry<String, Color> contrastColor : contrastColorsWithDescription.entrySet()) {
            Color backgroundColor;
            String colorDescription = contrastColor.getKey();
            if (colorDescription.startsWith(DISABLED_PREFIX)) continue;
            Color otherColor = contrastColor.getValue();
            if (isBackground) {
                backgroundColor = ColorUtils.worstContrastColor(otherColor, color);
                color = ColorUtils.alphaBlending(color, backgroundColor);
                otherColor = ColorUtils.alphaBlending(otherColor, color);
            } else {
                backgroundColor = ColorUtils.worstContrastColor(color, otherColor);
                otherColor = ColorUtils.alphaBlending(otherColor, backgroundColor);
                color = ColorUtils.alphaBlending(color, otherColor);
            }
            if (!(ColorUtils.calculateContrastRatio(color, otherColor) < 4.5)) continue;
            lowContrastColorsBuilder.add((Object)colorDescription);
        }
        ImmutableSet lowContrastColors = lowContrastColorsBuilder.build();
        if (!lowContrastColors.isEmpty()) {
            String string = "<html>Not enough contrast with " + ThemeEditorUtils.generateWordEnumeration((Collection<String>)lowContrastColors);
            if (string == null) {
                ColorUtils.$$$reportNull$$$0(9);
            }
            return string;
        }
        if ("" == null) {
            ColorUtils.$$$reportNull$$$0(10);
        }
        return "";
    }

    @NotNull
    public static Color worstContrastColor(@NotNull Color foreground, @NotNull Color background) {
        if (foreground == null) {
            ColorUtils.$$$reportNull$$$0(11);
        }
        if (background == null) {
            ColorUtils.$$$reportNull$$$0(12);
        }
        int backgroundAlpha = background.getAlpha();
        int r = ColorUtils.worstContrastComponent(foreground.getRed(), background.getRed(), backgroundAlpha);
        int g = ColorUtils.worstContrastComponent(foreground.getGreen(), background.getGreen(), backgroundAlpha);
        int b = ColorUtils.worstContrastComponent(foreground.getBlue(), background.getBlue(), backgroundAlpha);
        Color color = new Color(r, g, b);
        if (color == null) {
            ColorUtils.$$$reportNull$$$0(13);
        }
        return color;
    }

    private static int worstContrastComponent(int foregroundComponent, int backgroundComponent, int backgroundAlpha) {
        if (backgroundAlpha == 255) {
            return 0;
        }
        int component = (255 * foregroundComponent - backgroundAlpha * backgroundComponent) / (255 - backgroundAlpha);
        return ResourceHelper.clamp(component, 0, 255);
    }

    @NotNull
    public static Color alphaBlending(@NotNull Color foreground, @NotNull Color background) {
        if (foreground == null) {
            ColorUtils.$$$reportNull$$$0(14);
        }
        if (background == null) {
            ColorUtils.$$$reportNull$$$0(15);
        }
        float foregroundAlpha = (float)foreground.getAlpha() / 255.0f;
        float backgroundAlpha = (float)background.getAlpha() / 255.0f;
        float a = foregroundAlpha + backgroundAlpha * (1.0f - foregroundAlpha);
        float r = ColorUtils.alphaBlendingComponent(foreground.getRed(), foregroundAlpha, background.getRed(), backgroundAlpha);
        float g = ColorUtils.alphaBlendingComponent(foreground.getGreen(), foregroundAlpha, background.getGreen(), backgroundAlpha);
        float b = ColorUtils.alphaBlendingComponent(foreground.getBlue(), foregroundAlpha, background.getBlue(), backgroundAlpha);
        Color color = new Color(r, g, b, a);
        if (color == null) {
            ColorUtils.$$$reportNull$$$0(16);
        }
        return color;
    }

    private static float alphaBlendingComponent(int foregroundComponent, float foregroundAlpha, int backgroundComponent, float backgroundAlpha) {
        float alpha = foregroundAlpha + backgroundAlpha * (1.0f - foregroundAlpha);
        if ((double)Math.abs(alpha) < 0.001) {
            return 1.0f;
        }
        return (foregroundAlpha * (float)foregroundComponent + backgroundAlpha * (float)backgroundComponent * (1.0f - foregroundAlpha)) / (255.0f * alpha);
    }

    public static boolean isBackgroundAttribute(String text) {
        return BACKGROUND_ATTRIBUTES.contains((Object)text);
    }

    public static double calculateContrastRatio(@NotNull Color color1, @NotNull Color color2) {
        if (color1 == null) {
            ColorUtils.$$$reportNull$$$0(17);
        }
        if (color2 == null) {
            ColorUtils.$$$reportNull$$$0(18);
        }
        double color1Luminance = ColorUtils.calculateColorLuminance(color1);
        double color2Luminance = ColorUtils.calculateColorLuminance(color2);
        return (Math.max(color1Luminance, color2Luminance) + 0.05) / (Math.min(color2Luminance, color1Luminance) + 0.05);
    }

    private static double calculateColorLuminance(@NotNull Color color) {
        if (color == null) {
            ColorUtils.$$$reportNull$$$0(19);
        }
        return ColorUtils.calculateLuminanceContribution((double)color.getRed() / 255.0) * 0.2126 + ColorUtils.calculateLuminanceContribution((double)color.getGreen() / 255.0) * 0.7152 + ColorUtils.calculateLuminanceContribution((double)color.getBlue() / 255.0) * 0.0722;
    }

    private static double calculateLuminanceContribution(double colorValue) {
        if (colorValue <= 0.03928) {
            return colorValue / 12.92;
        }
        return Math.pow((colorValue + 0.055) / 1.055, 2.4);
    }

    static {
        Pair[] contrastPairs = new Pair[]{Pair.of((Object)"textColor", (Object)"colorBackground"), Pair.of((Object)"textColor", (Object)"colorPrimary"), Pair.of((Object)"textColorPrimary", (Object)"colorButtonNormal"), Pair.of((Object)"textColorPrimary", (Object)"colorPrimary"), Pair.of((Object)"textColorPrimary", (Object)"colorBackground")};
        ImmutableSetMultimap.Builder contrastMapBuilder = ImmutableSetMultimap.builder();
        ImmutableSet.Builder backgroundAttributesBuilder = ImmutableSet.builder();
        for (Pair pair : contrastPairs) {
            contrastMapBuilder.put(pair.getFirst(), pair.getSecond());
            contrastMapBuilder.put(pair.getSecond(), pair.getFirst());
            backgroundAttributesBuilder.add(pair.getSecond());
        }
        CONTRAST_MAP = contrastMapBuilder.build();
        BACKGROUND_ATTRIBUTES = backgroundAttributesBuilder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleAttributeName";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ColorUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contrastColorsWithDescription";
                break;
            }
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreground";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color1";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ColorUtils";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContrastItems";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContrastColorsWithDescription";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContrastWarningMessage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "worstContrastColor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "alphaBlending";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContrastItems";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContrastColorsWithDescription";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContrastWarningMessage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "worstContrastColor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "alphaBlending";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "calculateContrastRatio";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "calculateColorLuminance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

