/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.adtui.util.GraphicsUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ColorPalette
extends JComponent
implements Scrollable,
ItemSelectable {
    private int myColorBoxSize;
    private int myColorBoxPadding;
    private boolean myShowCheckeredBackground;
    private ColorPaletteModel myColorListModel;
    private final Border mySelectedBorder;
    private int mySelectedItem;

    public ColorPalette(@NotNull ColorPaletteModel colorListModel) {
        if (colorListModel == null) {
            ColorPalette.$$$reportNull$$$0(0);
        }
        this.myColorBoxSize = JBUIScale.scale((int)50);
        this.myColorBoxPadding = this.myColorBoxSize / 10;
        this.myShowCheckeredBackground = false;
        this.mySelectedBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
        this.mySelectedItem = -1;
        this.myColorListModel = colorListModel;
        this.setToolTipText("");
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int selected = ColorPalette.this.itemAtPoint(e.getPoint());
                if (selected == ColorPalette.this.mySelectedItem) {
                    return;
                }
                if (ColorPalette.this.mySelectedItem != -1) {
                    ColorPalette.this.itemStateChanged(ColorPalette.this.mySelectedItem, 2);
                }
                if (selected != -1) {
                    ColorPalette.this.mySelectedItem = selected;
                    ColorPalette.this.itemStateChanged(ColorPalette.this.mySelectedItem, 1);
                    ColorPalette.this.repaint();
                } else {
                    ColorPalette.this.clearSelection();
                }
            }
        });
    }

    public ColorPalette() {
        this(new StaticColorPaletteModel(Collections.emptyList()));
    }

    public void setModel(@NotNull ColorPaletteModel colorListModel) {
        if (colorListModel == null) {
            ColorPalette.$$$reportNull$$$0(1);
        }
        this.myColorListModel = colorListModel;
        this.revalidate();
    }

    @NotNull
    public ColorPaletteModel getModel() {
        ColorPaletteModel colorPaletteModel = this.myColorListModel;
        if (colorPaletteModel == null) {
            ColorPalette.$$$reportNull$$$0(2);
        }
        return colorPaletteModel;
    }

    public void setColorBoxSize(int colorSize) {
        this.myColorBoxSize = colorSize;
        this.revalidate();
    }

    public void setColorBoxPadding(int padding) {
        this.myColorBoxPadding = padding;
        this.revalidate();
    }

    public void setShowCheckeredBackground(boolean showCheckeredBackground) {
        this.myShowCheckeredBackground = showCheckeredBackground;
    }

    @Override
    public Dimension getMinimumSize() {
        int minSize = this.myColorBoxSize + this.myColorBoxPadding * 2;
        return new Dimension(minSize, minSize);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet() || this.myColorListModel.getCount() < 1) {
            return super.getPreferredSize();
        }
        int minSize = this.myColorBoxSize + this.myColorBoxPadding * 2;
        return new Dimension(this.myColorListModel.getCount() * (this.myColorBoxSize + this.myColorBoxPadding) + this.myColorBoxPadding, minSize);
    }

    private int itemAtPoint(@NotNull Point p) {
        if (p == null) {
            ColorPalette.$$$reportNull$$$0(3);
        }
        if (p.y <= this.myColorBoxPadding || p.y > this.myColorBoxPadding + this.myColorBoxSize) {
            return -1;
        }
        if (p.x <= this.myColorBoxPadding) {
            return -1;
        }
        int position = (p.x - this.myColorBoxPadding) / (this.myColorBoxSize + this.myColorBoxPadding);
        int maxBoxX = position * (this.myColorBoxSize + this.myColorBoxPadding) + this.myColorBoxSize;
        if (p.x - this.myColorBoxPadding > maxBoxX) {
            return -1;
        }
        return position;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int position = this.itemAtPoint(event.getPoint());
        if (position == -1) {
            return "";
        }
        return this.myColorListModel.getToolTipAt(position);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myColorListModel.getCount() < 1) {
            return;
        }
        if (this.myShowCheckeredBackground) {
            GraphicsUtil.paintCheckeredBackground((Graphics)g, (Shape)new Rectangle(this.getSize()));
        }
        int width = this.getWidth();
        for (int i2 = 0; i2 < this.myColorListModel.getCount(); ++i2) {
            g.setColor(this.myColorListModel.getColorAt(i2));
            int x = i2 * (this.myColorBoxSize + this.myColorBoxPadding) + this.myColorBoxPadding;
            g.fillRect(x, this.myColorBoxPadding, this.myColorBoxSize, this.myColorBoxSize);
            if (this.mySelectedItem == i2 && this.mySelectedBorder != null) {
                g.setXORMode(Color.WHITE);
                this.mySelectedBorder.paintBorder(this, g, x, this.myColorBoxPadding, this.myColorBoxSize, this.myColorBoxSize);
                g.setPaintMode();
            }
            if (x > width) break;
        }
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.mySelectedItem == -1) {
            return null;
        }
        return new Color[]{this.myColorListModel.getColorAt(this.mySelectedItem)};
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.listenerList.add(ItemListener.class, l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.listenerList.remove(ItemListener.class, l);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension preferredSize = this.getPreferredSize();
        return new Dimension(preferredSize.width, preferredSize.height + UIUtil.getScrollBarWidth());
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.myColorBoxSize + this.myColorBoxPadding;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void clearSelection() {
        this.mySelectedItem = -1;
        this.repaint();
    }

    private void itemStateChanged(int position, int stateChange) {
        ItemListener[] listeners = this.getItemListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        ItemEvent itemEvent = new ItemEvent(this, 701, this.myColorListModel.getColorAt(position), stateChange);
        for (ItemListener itemListener : listeners) {
            itemListener.itemStateChanged(itemEvent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorListModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ColorPalette";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ColorPalette";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "itemAtPoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class StaticColorPaletteModel
    implements ColorPaletteModel {
        private final List<Color> myColorList;

        public StaticColorPaletteModel(@NotNull List<Color> colorList) {
            if (colorList == null) {
                StaticColorPaletteModel.$$$reportNull$$$0(0);
            }
            this.myColorList = ImmutableList.copyOf(colorList);
        }

        @Override
        public int getCount() {
            return this.myColorList.size();
        }

        @Override
        @NotNull
        public Color getColorAt(int i2) {
            Color color = this.myColorList.get(i2);
            if (color == null) {
                StaticColorPaletteModel.$$$reportNull$$$0(1);
            }
            return color;
        }

        @Override
        public int indexOf(@NotNull Color c) {
            if (c == null) {
                StaticColorPaletteModel.$$$reportNull$$$0(2);
            }
            return this.myColorList.indexOf(c);
        }

        @Override
        @NotNull
        public String getToolTipAt(int i2) {
            String string = this.myColorList.get(i2).toString();
            if (string == null) {
                StaticColorPaletteModel.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorList";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/editors/theme/ColorPalette$StaticColorPaletteModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/editors/theme/ColorPalette$StaticColorPaletteModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColorAt";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolTipAt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "indexOf";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ColorPaletteModel {
        public int getCount();

        @NotNull
        public Color getColorAt(int var1);

        public int indexOf(@NotNull Color var1);

        @NotNull
        public String getToolTipAt(int var1);
    }
}

