/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.sqlite;

import com.android.tools.idea.device.fs.DeviceFileId;
import com.android.tools.idea.editors.sqlite.SqliteEditorPanel;
import com.android.tools.idea.editors.sqlite.SqliteEditorState;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u000bH\u0002J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\"\u001a\u00020\u000bH\u0016J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u001aH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/editors/sqlite/SqliteEditor;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "sqliteFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "panel", "Lcom/android/tools/idea/editors/sqlite/SqliteEditorPanel;", "addPropertyChangeListener", "", "listener", "Ljava/beans/PropertyChangeListener;", "deselectNotify", "dispose", "getBackgroundHighlighter", "Lcom/intellij/codeHighlighting/BackgroundEditorHighlighter;", "getComponent", "Ljavax/swing/JComponent;", "getCurrentLocation", "Lcom/intellij/openapi/fileEditor/FileEditorLocation;", "getName", "", "getPreferredFocusedComponent", "getState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "level", "Lcom/intellij/openapi/fileEditor/FileEditorStateLevel;", "isModified", "", "isValid", "refreshPanel", "removePropertyChangeListener", "selectNotify", "setState", "state", "intellij.android.debuggers"})
public final class SqliteEditor
extends UserDataHolderBase
implements FileEditor {
    private final SqliteEditorPanel panel;
    private final Project project;
    private final VirtualFile sqliteFile;

    private final void refreshPanel() {
        DeviceFileId deviceEntry = (DeviceFileId)this.sqliteFile.getUserData(DeviceFileId.KEY);
        JTextField jTextField = this.panel.localPathText;
        Intrinsics.checkExpressionValueIsNotNull((Object)jTextField, (String)"panel.localPathText");
        jTextField.setText(FileUtil.toSystemDependentName((String)this.sqliteFile.getPath()));
        JTextField jTextField2 = this.panel.deviceIdText;
        Intrinsics.checkExpressionValueIsNotNull((Object)jTextField2, (String)"panel.deviceIdText");
        Object object = deviceEntry;
        if (object == null || (object = ((DeviceFileId)object).getDeviceId()) == null) {
            object = "N/A";
        }
        jTextField2.setText((String)object);
        JTextField jTextField3 = this.panel.devicePathText;
        Intrinsics.checkExpressionValueIsNotNull((Object)jTextField3, (String)"panel.devicePathText");
        Object object2 = deviceEntry;
        if (object2 == null || (object2 = ((DeviceFileId)object2).getDevicePath()) == null) {
            object2 = "N/A";
        }
        jTextField3.setText((String)object2);
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.panel.mainPanel;
        Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"panel.mainPanel");
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        String string = this.sqliteFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sqliteFile.name");
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (state instanceof SqliteEditorState) {
            this.sqliteFile.putUserData(DeviceFileId.KEY, (Object)((SqliteEditorState)state).getDeviceFileId());
            this.refreshPanel();
        }
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
        DeviceFileId fileId = (DeviceFileId)this.sqliteFile.getUserData(DeviceFileId.KEY);
        if (fileId == null) {
            fileId = DeviceFileId.UNKNOWN;
        }
        return new SqliteEditorState(fileId);
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return this.sqliteFile.isValid() && !this.project.isDisposed();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public SqliteEditor(@NotNull Project project, @NotNull VirtualFile sqliteFile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)sqliteFile, (String)"sqliteFile");
        this.project = project;
        this.sqliteFile = sqliteFile;
        this.panel = new SqliteEditorPanel();
        this.refreshPanel();
    }
}

