/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.draw9patch.graphics.GraphicsUtilities;
import com.android.draw9patch.ui.ImageEditorPanel;
import com.android.draw9patch.ui.ImageViewer;
import com.intellij.AppTopics;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.GuiUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NinePatchEditor
implements FileEditor,
ImageViewer.PatchUpdateListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.editors.NinePatchEditor");
    private static final String NAME = "9-Patch";
    private final UserDataHolderBase myUserDataHolder;
    private final Project myProject;
    private VirtualFile myFile;
    private BufferedImage myBufferedImage;
    private ImageEditorPanel myImageEditorPanel;
    private boolean myDirtyFlag;

    public NinePatchEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            NinePatchEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            NinePatchEditor.$$$reportNull$$$0(1);
        }
        this.myUserDataHolder = new UserDataHolderBase();
        this.myProject = project;
        FileDocumentManagerListener saveListener = new FileDocumentManagerListener(){

            public void beforeAllDocumentsSaving() {
                NinePatchEditor.this.saveFile();
            }
        };
        project.getMessageBus().connect((Disposable)this).subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)saveListener);
        this.myFile = file;
        try {
            this.myBufferedImage = this.loadImage(file);
            this.myImageEditorPanel = new ImageEditorPanel(null, this.myBufferedImage, this.myFile.getName());
            this.myImageEditorPanel.getViewer().addPatchUpdateListener((ImageViewer.PatchUpdateListener)this);
        }
        catch (IOException e) {
            LOG.error("Unexpected exception while reading 9-patch file", (Throwable)e);
        }
    }

    private BufferedImage loadImage(VirtualFile file) throws IOException {
        this.myBufferedImage = ImageIO.read(file.getInputStream());
        if (this.myBufferedImage == null) {
            throw new IOException("Unable to parse file: " + file.getCanonicalPath());
        }
        return GraphicsUtilities.toCompatibleImage((BufferedImage)this.myBufferedImage);
    }

    private void saveFile() {
        GuiUtils.invokeLaterIfNeeded(() -> {
            try {
                this.saveFileFromEDT();
            }
            catch (IOException e) {
                LOG.error("Unexpected exception while saving 9-patch file", (Throwable)e);
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    private void saveFileFromEDT() throws IOException {
        if (!this.myDirtyFlag) {
            return;
        }
        new WriteCommandAction.Simple(this.myProject, "Update N-patch", new PsiFile[]{PsiManager.getInstance((Project)this.myProject).findFile(this.myFile)}){

            protected void run() throws Throwable {
                ByteArrayOutputStream stream = new ByteArrayOutputStream((int)NinePatchEditor.this.myFile.getLength());
                ImageIO.write((RenderedImage)NinePatchEditor.this.myBufferedImage, "PNG", stream);
                NinePatchEditor.this.myFile.setBinaryContent(stream.toByteArray());
            }
        }.execute();
        this.myDirtyFlag = false;
    }

    @NotNull
    public JComponent getComponent() {
        Object object = this.myImageEditorPanel != null ? this.myImageEditorPanel : new JLabel("Unexpected error while loading 9-patch file. See Event Log for details.");
        if (object == null) {
            NinePatchEditor.$$$reportNull$$$0(2);
        }
        return object;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myImageEditorPanel;
    }

    @NotNull
    public String getName() {
        if (NAME == null) {
            NinePatchEditor.$$$reportNull$$$0(3);
        }
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            NinePatchEditor.$$$reportNull$$$0(4);
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            NinePatchEditor.$$$reportNull$$$0(5);
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            NinePatchEditor.$$$reportNull$$$0(6);
        }
    }

    public boolean isModified() {
        return this.myDirtyFlag;
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            NinePatchEditor.$$$reportNull$$$0(7);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            NinePatchEditor.$$$reportNull$$$0(8);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        this.saveFile();
        if (this.myImageEditorPanel != null) {
            this.myImageEditorPanel.getViewer().removePatchUpdateListener((ImageViewer.PatchUpdateListener)this);
            this.myImageEditorPanel.dispose();
            this.myImageEditorPanel = null;
        }
    }

    public void patchesUpdated() {
        this.myDirtyFlag = true;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            NinePatchEditor.$$$reportNull$$$0(9);
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            NinePatchEditor.$$$reportNull$$$0(10);
        }
        this.myUserDataHolder.putUserData(key, value2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/NinePatchEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/NinePatchEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

