/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.idea.diagnostics.crash.BaseStudioReport;
import com.google.common.base.Charsets;
import com.intellij.diagnostic.ThreadDumper;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class StudioHistogramReport
extends BaseStudioReport {
    private static final String EXCEPTION_TYPE = "com.android.OutOfMemory";
    private static final String EMPTY_OOM_STACKTRACE = "com.android.OutOfMemory: \n\tat " + StudioHistogramReport.class.getName() + ".missingEdtStack(Unknown source)";
    private String threadDump;
    private String histogram;

    public StudioHistogramReport(String version2, String threadDump, String histogram, Map<String, String> productData) {
        super(version2, productData, "Histogram");
        this.threadDump = threadDump;
        this.histogram = histogram;
    }

    @Override
    protected void serializeTo(MultipartEntityBuilder builder) {
        super.serializeTo(builder);
        String edtStack = ThreadDumper.getEdtStackForCrash((String)this.threadDump, (String)EXCEPTION_TYPE);
        builder.addTextBody("exception_info", edtStack != null ? edtStack : EMPTY_OOM_STACKTRACE);
        builder.addTextBody("histogram", this.histogram, ContentType.create((String)"text/plain", (Charset)Charsets.UTF_8));
        builder.addTextBody("threadDump", this.threadDump, ContentType.create((String)"text/plain", (Charset)Charsets.UTF_8));
    }

    public static final class Builder
    extends CrashReport.BaseBuilder<StudioHistogramReport, Builder> {
        private String histogram;
        private String threadDump;

        protected Builder getThis() {
            return this;
        }

        public Builder setHistogram(String histogram) {
            this.histogram = histogram;
            return this;
        }

        public Builder setThreadDump(String threadDump) {
            this.threadDump = threadDump;
            return this;
        }

        public StudioHistogramReport build() {
            return new StudioHistogramReport(this.getVersion(), this.threadDump, this.histogram, this.getProductData());
        }
    }
}

