/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.DiagnosticReport;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;

public class StudioReportDatabase {
    private final Object myDbLock;
    @GuardedBy(value="myDbLock")
    private final Path myDb;
    private static final long MAX_SUPPORTED_FORMAT_VERSION = 1L;

    public StudioReportDatabase(@NotNull File databaseFile) {
        if (databaseFile == null) {
            StudioReportDatabase.$$$reportNull$$$0(0);
        }
        this.myDbLock = new Object();
        this.myDb = databaseFile.toPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<DiagnosticReport> reapReportDetails() {
        Object result2;
        Object object = this.myDbLock;
        synchronized (object) {
            try (FileReader reader = new FileReader(this.myDb.toFile());){
                result2 = DiagnosticReport.Companion.readDiagnosticReports(reader);
            }
            catch (Exception e) {
                result2 = ImmutableList.of();
            }
            try {
                Files.write(this.myDb, new byte[0], StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                result2 = ImmutableList.of();
            }
        }
        ImmutableList immutableList = result2;
        if (immutableList == null) {
            StudioReportDatabase.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendReport(DiagnosticReport report) throws IOException {
        try (StringWriter sw = new StringWriter();){
            report.serializeReport(sw);
            String content = sw.toString() + "\n";
            Object object = this.myDbLock;
            synchronized (object) {
                Files.write(this.myDb, content.getBytes(Charsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/diagnostics/StudioReportDatabase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/diagnostics/StudioReportDatabase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "reapReportDetails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

