/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.util.ListenerCollection;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import java.util.concurrent.TimeUnit;

public class LastActionTracker
implements Disposable,
AnActionListener {
    private final ListenerCollection<Listener> myListeners = ListenerCollection.createWithDirectExecutor();
    private String myCurrentActionId = "(no action)";
    private long myCurrentActionStartNano;

    public LastActionTracker() {
        ActionManager.getInstance().addAnActionListener((AnActionListener)this);
    }

    public void registerActionDurationListener(Listener listener2) {
        this.myListeners.add(listener2);
    }

    public String getCurrentActionId() {
        return this.myCurrentActionId;
    }

    public long getCurrentDurationMs() {
        if (this.myCurrentActionStartNano != 0L) {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.myCurrentActionStartNano);
        }
        return 0L;
    }

    public void unregisterActionDurationListener(Listener listener2) {
        this.myListeners.remove(listener2);
    }

    public void dispose() {
        ActionManager.getInstance().removeAnActionListener((AnActionListener)this);
    }

    public void beforeActionPerformed(AnAction action2, DataContext dataContext, AnActionEvent event) {
        String actionId;
        this.myCurrentActionId = actionId = LastActionTracker.getActionId(action2);
        this.myCurrentActionStartNano = System.nanoTime();
        this.myListeners.forEach(l -> l.actionStarted(actionId));
    }

    private static String getActionId(AnAction action2) {
        if (action2 == null) {
            return "<null>";
        }
        return action2.getClass().getName() + " (" + ActionManager.getInstance().getId(action2) + ")";
    }

    public void afterActionPerformed(AnAction action2, DataContext dataContext, AnActionEvent event) {
        String actionId = LastActionTracker.getActionId(action2);
        this.myListeners.forEach(l -> l.actionFinished(actionId, this.getCurrentDurationMs()));
        this.myCurrentActionId = "(no action)";
        this.myCurrentActionStartNano = 0L;
    }

    public static interface Listener {
        public void actionStarted(String var1);

        public void actionFinished(String var1, long var2);
    }
}

