/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.ddmlib.BitmapDecoder;
import com.android.tools.idea.debug.BitmapEvaluatorProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.tree.render.CustomPopupFullValueEvaluator;
import com.intellij.openapi.ui.Messages;
import com.sun.jdi.Value;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.intellij.images.editor.impl.ImageEditorManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BitmapPopupEvaluator
extends CustomPopupFullValueEvaluator<BufferedImage> {
    @Nullable
    private String myError;

    BitmapPopupEvaluator(@NotNull EvaluationContextImpl evaluationContext) {
        if (evaluationContext == null) {
            BitmapPopupEvaluator.$$$reportNull$$$0(0);
        }
        super("\u2026 View Bitmap", evaluationContext);
    }

    @Nullable
    public BufferedImage getImage(EvaluationContextImpl evaluationContext, Value value2) {
        try {
            return BitmapDecoder.getBitmap((BitmapDecoder.BitmapDataProvider)new BitmapEvaluatorProvider(value2, evaluationContext));
        }
        catch (EvaluateException e) {
            this.myError = "Error while evaluating expression: " + e.getMessage();
            return null;
        }
        catch (Exception e) {
            this.myError = "Unexpected error: " + e.getMessage();
            return null;
        }
    }

    protected JComponent createComponent(BufferedImage image) {
        if (image == null) {
            String message = this.myError == null ? "Unexpected error while obtaining image" : this.myError;
            return new JLabel(message, Messages.getErrorIcon(), 0);
        }
        return ImageEditorManagerImpl.createImageEditorUI((BufferedImage)image);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/android/tools/idea/debug/BitmapPopupEvaluator", "<init>"));
    }
}

