/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.screenshot;

import com.android.ddmlib.IDevice;
import com.android.resources.ScreenOrientation;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.ddms.screenshot.ScreenshotTask;
import com.android.tools.idea.device.DeviceArtDescriptor;
import com.android.tools.idea.device.DeviceArtPainter;
import com.android.tools.idea.help.StudioHelpManagerImpl;
import com.android.tools.pixelprobe.color.Colors;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Deflater;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.ImageFileEditor;
import org.intellij.images.editor.ImageZoomModel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;

public class ScreenshotViewer
extends DialogWrapper
implements DataProvider {
    @NonNls
    private static final String SCREENSHOT_VIEWER_DIMENSIONS_KEY = "ScreenshotViewer.Dimensions";
    @NonNls
    private static final String SCREENSHOT_SAVE_PATH_KEY = "ScreenshotViewer.SavePath";
    private static final int ROTATE_AMOUNT = 90;
    private final Project myProject;
    private final IDevice myDevice;
    private final VirtualFile myBackingVirtualFile;
    private final ImageFileEditor myImageFileEditor;
    private final FileEditorProvider myProvider;
    private final List<DeviceArtDescriptor> myDeviceArtDescriptors;
    private JPanel myPanel;
    private JButton myRefreshButton;
    private JButton myRotateRightButton;
    private JButton myRotateLeftButton;
    private JScrollPane myScrollPane;
    private JCheckBox myFrameScreenshotCheckBox;
    private JComboBox<String> myDeviceArtCombo;
    private JCheckBox myDropShadowCheckBox;
    private JCheckBox myScreenGlareCheckBox;
    private JButton myCopyButton;
    private int myRotationAngle;
    private AtomicReference<BufferedImage> mySourceImageRef;
    private AtomicReference<BufferedImage> myDisplayedImageRef;
    private File myScreenshotFile;

    public ScreenshotViewer(@NotNull Project project, @NotNull BufferedImage image, @NotNull File backingFile, @Nullable IDevice device, @Nullable String deviceModel) {
        if (project == null) {
            ScreenshotViewer.$$$reportNull$$$0(0);
        }
        if (image == null) {
            ScreenshotViewer.$$$reportNull$$$0(1);
        }
        if (backingFile == null) {
            ScreenshotViewer.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.myRotationAngle = 0;
        this.$$$setupUI$$$();
        this.mySourceImageRef = new AtomicReference();
        this.myDisplayedImageRef = new AtomicReference();
        this.myProject = project;
        this.myDevice = device;
        this.mySourceImageRef.set(image);
        this.myDisplayedImageRef.set(image);
        this.myBackingVirtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(backingFile);
        assert (this.myBackingVirtualFile != null);
        this.myRefreshButton.setIcon(AllIcons.Actions.Refresh);
        this.myRefreshButton.setEnabled(device != null);
        this.myProvider = this.getImageFileEditorProvider();
        this.myImageFileEditor = (ImageFileEditor)this.myProvider.createEditor(this.myProject, this.myBackingVirtualFile);
        this.myScrollPane.getViewport().add(this.myImageFileEditor.getComponent());
        this.myScrollPane.getViewport().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ScreenshotViewer.this.updateZoom();
            }
        });
        ActionListener l = actionEvent -> {
            if (actionEvent.getSource() == this.myRefreshButton) {
                this.doRefreshScreenshot();
            } else if (actionEvent.getSource() == this.myRotateRightButton) {
                this.doRotateScreenshot(90);
            } else if (actionEvent.getSource() == this.myRotateLeftButton) {
                this.doRotateScreenshot(270);
            } else if (actionEvent.getSource() == this.myFrameScreenshotCheckBox || actionEvent.getSource() == this.myDeviceArtCombo || actionEvent.getSource() == this.myDropShadowCheckBox || actionEvent.getSource() == this.myScreenGlareCheckBox) {
                this.doFrameScreenshot();
            } else if (actionEvent.getSource() == this.myCopyButton) {
                CopyPasteManager.getInstance().setContents((Transferable)new ImageTransferable(this.myImageFileEditor.getImageEditor().getDocument().getValue()));
                Notifications.Bus.notify((Notification)new Notification(AndroidBundle.message("android.ddms.actions.screenshot", new Object[0]), AndroidBundle.message("android.ddms.actions.screenshot", new Object[0]), AndroidBundle.message("android.ddms.actions.screenshot.copied.to.clipboard", new Object[0]), NotificationType.INFORMATION), (Project)this.myProject);
            }
        };
        this.myRefreshButton.addActionListener(l);
        this.myRotateRightButton.addActionListener(l);
        this.myRotateLeftButton.addActionListener(l);
        this.myFrameScreenshotCheckBox.addActionListener(l);
        this.myDeviceArtCombo.addActionListener(l);
        this.myDropShadowCheckBox.addActionListener(l);
        this.myScreenGlareCheckBox.addActionListener(l);
        this.myCopyButton.addActionListener(l);
        this.myDeviceArtDescriptors = ScreenshotViewer.getDescriptorsToFrame(image);
        String[] titles = new String[this.myDeviceArtDescriptors.size()];
        for (int i2 = 0; i2 < this.myDeviceArtDescriptors.size(); ++i2) {
            titles[i2] = this.myDeviceArtDescriptors.get(i2).getName();
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(titles);
        this.myDeviceArtCombo.setModel(model);
        this.myDeviceArtCombo.setSelectedIndex(ScreenshotViewer.getDefaultDescriptor(this.myDeviceArtDescriptors, image, deviceModel));
        this.setModal(false);
        this.setTitle(AndroidBundle.message("android.ddms.actions.screenshot", new Object[0]));
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myImageFileEditor.getComponent();
    }

    private static List<DeviceArtDescriptor> getDescriptorsToFrame(BufferedImage image) {
        double imgAspectRatio = (double)image.getWidth() / (double)image.getHeight();
        ScreenOrientation orientation = imgAspectRatio >= 0.99999 ? ScreenOrientation.LANDSCAPE : ScreenOrientation.PORTRAIT;
        List allDescriptors = DeviceArtDescriptor.getDescriptors(null);
        return ContainerUtil.filter((Collection)allDescriptors, descriptor -> descriptor.canFrameImage(image, orientation));
    }

    private static int getDefaultDescriptor(List<DeviceArtDescriptor> deviceArtDescriptors, BufferedImage image, @Nullable String deviceModel) {
        int index = -1;
        if (deviceModel != null) {
            index = ScreenshotViewer.findDescriptorIndexForProduct(deviceArtDescriptors, deviceModel);
        }
        if (index < 0) {
            String defaultDevice = Math.min(image.getWidth(), image.getHeight()) > 1280 ? "Generic Tablet" : "Generic Phone";
            index = ScreenshotViewer.findDescriptorIndexForProduct(deviceArtDescriptors, defaultDevice);
        }
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    private static int findDescriptorIndexForProduct(List<DeviceArtDescriptor> descriptors, String deviceModel) {
        for (int i2 = 0; i2 < descriptors.size(); ++i2) {
            DeviceArtDescriptor d = descriptors.get(i2);
            if (!d.getName().equalsIgnoreCase(deviceModel)) continue;
            return i2;
        }
        return -1;
    }

    protected void dispose() {
        this.myProvider.disposeEditor((FileEditor)this.myImageFileEditor);
        super.dispose();
    }

    private void doRefreshScreenshot() {
        assert (this.myDevice != null);
        new ScreenshotTask(this.myProject, this.myDevice){

            public void onSuccess() {
                String msg = this.getError();
                if (msg != null) {
                    Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)AndroidBundle.message("android.ddms.actions.screenshot", new Object[0]));
                    return;
                }
                BufferedImage image = this.getScreenshot();
                ScreenshotViewer.this.mySourceImageRef.set(image);
                ScreenshotViewer.this.processScreenshot(ScreenshotViewer.this.myFrameScreenshotCheckBox.isSelected(), ScreenshotViewer.this.myRotationAngle);
            }
        }.queue();
    }

    private void doRotateScreenshot(int change) {
        this.myRotationAngle = (this.myRotationAngle + change) % 360;
        this.processScreenshot(this.myFrameScreenshotCheckBox.isSelected(), change);
    }

    private void doFrameScreenshot() {
        boolean shouldFrame = this.myFrameScreenshotCheckBox.isSelected();
        this.myDeviceArtCombo.setEnabled(shouldFrame);
        this.myDropShadowCheckBox.setEnabled(shouldFrame);
        this.myScreenGlareCheckBox.setEnabled(shouldFrame);
        if (shouldFrame) {
            this.processScreenshot(true, 0);
        } else {
            this.myDisplayedImageRef.set(this.mySourceImageRef.get());
            this.updateEditorImage();
        }
    }

    private void updateZoom() {
        if (!this.myScrollPane.getViewport().isShowing()) {
            return;
        }
        ImageEditor imageEditor = this.myImageFileEditor.getImageEditor();
        int viewHeight = this.myScrollPane.getViewport().getHeight();
        int viewWidth = this.myScrollPane.getViewport().getWidth();
        Image deviceImage = imageEditor.getDocument().getRenderer();
        int imageHeight = deviceImage.getHeight(null);
        int imageWidth = deviceImage.getWidth(null);
        ImageZoomModel zoomModel = imageEditor.getZoomModel();
        zoomModel.setZoomFactor(ImageUtils.calcFullyDisplayZoomFactor((double)viewHeight, (double)viewWidth, (double)imageHeight, (double)imageWidth));
    }

    private void processScreenshot(boolean addFrame, int rotateByAngle) {
        DeviceArtDescriptor spec = addFrame ? this.myDeviceArtDescriptors.get(this.myDeviceArtCombo.getSelectedIndex()) : null;
        boolean shadow = addFrame && this.myDropShadowCheckBox.isSelected();
        boolean reflection = addFrame && this.myScreenGlareCheckBox.isSelected();
        new ImageProcessorTask(this.myProject, this.mySourceImageRef.get(), rotateByAngle, spec, shadow, reflection, this.myBackingVirtualFile){

            public void onSuccess() {
                ScreenshotViewer.this.mySourceImageRef.set(this.getRotatedImage());
                ScreenshotViewer.this.myDisplayedImageRef.set(this.getProcessedImage());
                ScreenshotViewer.this.updateEditorImage();
            }
        }.queue();
    }

    void updateEditorImage() {
        BufferedImage image = this.myDisplayedImageRef.get();
        ImageEditor imageEditor = this.myImageFileEditor.getImageEditor();
        imageEditor.getDocument().setValue(image);
        this.pack();
        IdeFocusManager.getInstance((Project)this.myProject).requestFocusInProject((Component)this.getPreferredFocusedComponent(), this.myProject);
    }

    private FileEditorProvider getImageFileEditorProvider() {
        FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders(this.myProject, this.myBackingVirtualFile);
        assert (providers.length > 0);
        for (FileEditorProvider p : providers) {
            if (!p.getEditorTypeId().equals("images")) continue;
            return p;
        }
        return providers[0];
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @NonNls
    @Nullable
    protected String getDimensionServiceKey() {
        return SCREENSHOT_VIEWER_DIMENSIONS_KEY;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            ScreenshotViewer.$$$reportNull$$$0(3);
        }
        return PlatformDataKeys.FILE_EDITOR.getName().equals(dataId) ? this.myImageFileEditor : null;
    }

    @Nullable
    protected String getHelpId() {
        return StudioHelpManagerImpl.STUDIO_HELP_PREFIX + "r/studio-ui/am-screenshot.html";
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.getOKAction().putValue("Name", AndroidBundle.message("android.ddms.screenshot.save.ok.button.text", new Object[0]));
    }

    protected void doOKAction() {
        VirtualFile baseDir;
        FileSaverDescriptor descriptor = new FileSaverDescriptor(AndroidBundle.message("android.ddms.screenshot.save.title", new Object[0]), "", new String[]{"png"});
        FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, this.myProject);
        VirtualFileWrapper fileWrapper = saveFileDialog.save(baseDir = this.loadScreenshotPath(), this.getDefaultFileName());
        if (fileWrapper == null) {
            return;
        }
        this.myScreenshotFile = fileWrapper.getFile();
        try {
            ScreenshotViewer.writePng(this.myDisplayedImageRef.get(), this.myScreenshotFile);
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)AndroidBundle.message("android.ddms.screenshot.save.error", e), (String)AndroidBundle.message("android.ddms.actions.screenshot", new Object[0]));
            return;
        }
        VirtualFile virtualFile = fileWrapper.getVirtualFile();
        if (virtualFile != null) {
            PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
            properties.setValue(SCREENSHOT_SAVE_PATH_KEY, virtualFile.getParent().getPath());
        }
        super.doOKAction();
    }

    private static void writePng(BufferedImage image, File outFile) throws IOException {
        ImageWriter pngWriter = ScreenshotViewer.getWriter(image, "png");
        if (pngWriter == null) {
            throw new IOException("Failed to find png writer");
        }
        outFile.delete();
        ImageOutputStream outputStream = ImageIO.createImageOutputStream(outFile);
        pngWriter.setOutput(outputStream);
        if (image.getColorModel().getColorSpace() instanceof ICC_ColorSpace) {
            ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(image);
            ImageWriteParam writeParams = pngWriter.getDefaultWriteParam();
            IIOMetadata metadata = pngWriter.getDefaultImageMetadata(type, writeParams);
            ICC_ColorSpace colorSpace = (ICC_ColorSpace)image.getColorModel().getColorSpace();
            byte[] data = ScreenshotViewer.deflate(colorSpace.getProfile().getData());
            Node node = metadata.getAsTree("javax_imageio_png_1.0");
            IIOMetadataNode iccp = new IIOMetadataNode("iCCP");
            iccp.setUserObject(data);
            iccp.setAttribute("profileName", Colors.getIccProfileDescription((ICC_Profile)colorSpace.getProfile()));
            iccp.setAttribute("compressionMethod", "deflate");
            node.appendChild(iccp);
            metadata.setFromTree("javax_imageio_png_1.0", node);
            pngWriter.write(new IIOImage(image, null, metadata));
        } else {
            pngWriter.write(image);
        }
        pngWriter.dispose();
        outputStream.flush();
        outputStream.close();
    }

    private static byte[] deflate(byte[] data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(data.length);
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        deflater.finish();
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            out.write(buffer, 0, count);
        }
        data = out.toByteArray();
        return data;
    }

    private static ImageWriter getWriter(RenderedImage image, String format) {
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(image);
        Iterator<ImageWriter> iterator = ImageIO.getImageWriters(type, format);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private String getDefaultFileName() {
        Calendar now = Calendar.getInstance();
        String fileName = "%s-%tF-%tH%tM%tS";
        return String.format(SystemInfo.isMac ? fileName + ".png" : fileName, this.myDevice != null ? "device" : "layout", now, now, now, now);
    }

    public File getScreenshot() {
        return this.myScreenshotFile;
    }

    void setScrollPane(@NotNull JScrollPane scrollPane) {
        if (scrollPane == null) {
            ScreenshotViewer.$$$reportNull$$$0(4);
        }
        this.myScrollPane = scrollPane;
    }

    ImageFileEditor getImageFileEditor() {
        return this.myImageFileEditor;
    }

    private VirtualFile loadScreenshotPath() {
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        String lastPath = properties.getValue(SCREENSHOT_SAVE_PATH_KEY);
        if (lastPath != null) {
            return LocalFileSystem.getInstance().findFileByPath(lastPath);
        }
        return this.myProject.getBaseDir();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backingFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollPane";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/ddms/screenshot/ScreenshotViewer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setScrollPane";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JButton jButton3;
        JButton jButton4;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 9, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myRefreshButton = jButton4 = new JButton();
        jButton4.setText("Recapture");
        jPanel2.add((Component)jButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 3, null, new Dimension(66, 26), null));
        this.myRotateRightButton = jButton3 = new JButton();
        ((Component)jButton3).setEnabled(true);
        jButton3.setText("Rotate Right");
        jPanel2.add((Component)jButton3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myFrameScreenshotCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Frame Screenshot");
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 5, 1, 1, 8, 0, 3, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myDeviceArtCombo = jComboBox;
        ((Component)jComboBox).setEnabled(false);
        jPanel2.add(jComboBox, new GridConstraints(0, 6, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myDropShadowCheckBox = jCheckBox2 = new JCheckBox();
        ((Component)jCheckBox2).setEnabled(false);
        jCheckBox2.setText("Drop Shadow");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 7, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myScreenGlareCheckBox = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setEnabled(false);
        jCheckBox.setText("Screen Glare");
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 8, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRotateLeftButton = jButton2 = new JButton();
        jButton2.setText("Rotate Left");
        jPanel2.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 3, null, null, null));
        this.myCopyButton = jButton = new JButton();
        jButton.setText("Copy to Clipboard");
        jPanel2.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        this.myScrollPane = jBScrollPane;
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 7, new Dimension(400, 600), null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class ImageTransferable
    implements Transferable {
        private final BufferedImage myImage;

        ImageTransferable(@NotNull BufferedImage image) {
            if (image == null) {
                ImageTransferable.$$$reportNull$$$0(0);
            }
            this.myImage = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return DataFlavor.imageFlavor.equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!DataFlavor.imageFlavor.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.myImage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/ddms/screenshot/ScreenshotViewer$ImageTransferable", "<init>"));
        }
    }

    private static class ImageProcessorTask
    extends Task.Backgroundable {
        private final BufferedImage mySrcImage;
        private final int myRotationAngle;
        private final DeviceArtDescriptor myDescriptor;
        private final boolean myAddShadow;
        private final boolean myAddReflection;
        private final VirtualFile myDestinationFile;
        private BufferedImage myRotatedImage;
        private BufferedImage myProcessedImage;

        ImageProcessorTask(@Nullable Project project, @NotNull BufferedImage srcImage, int rotateByAngle, @Nullable DeviceArtDescriptor descriptor, boolean addShadow, boolean addReflection, VirtualFile writeToFile) {
            if (srcImage == null) {
                ImageProcessorTask.$$$reportNull$$$0(0);
            }
            super(project, AndroidBundle.message("android.ddms.screenshot.image.processor.task.title", new Object[0]), false);
            this.mySrcImage = srcImage;
            this.myRotationAngle = rotateByAngle;
            this.myDescriptor = descriptor;
            this.myAddShadow = addShadow;
            this.myAddReflection = addReflection;
            this.myDestinationFile = writeToFile;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ImageProcessorTask.$$$reportNull$$$0(1);
            }
            this.myRotatedImage = this.myRotationAngle != 0 ? ImageUtils.rotateByRightAngle((BufferedImage)this.mySrcImage, (int)this.myRotationAngle) : this.mySrcImage;
            this.myProcessedImage = this.myDescriptor != null ? DeviceArtPainter.createFrame((BufferedImage)this.myRotatedImage, (DeviceArtDescriptor)this.myDescriptor, (boolean)this.myAddShadow, (boolean)this.myAddReflection) : this.myRotatedImage;
            this.myProcessedImage = ImageUtils.cropBlank((BufferedImage)this.myProcessedImage, null);
            if (this.myDestinationFile != null) {
                File file = VfsUtilCore.virtualToIoFile((VirtualFile)this.myDestinationFile);
                try {
                    ScreenshotViewer.writePng(this.myProcessedImage, file);
                }
                catch (IOException e) {
                    Logger.getInstance(ImageProcessorTask.class).error("Unexpected error while writing to backing file", (Throwable)e);
                }
            }
        }

        protected BufferedImage getProcessedImage() {
            return this.myProcessedImage;
        }

        protected BufferedImage getRotatedImage() {
            return this.myRotatedImage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "srcImage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ddms/screenshot/ScreenshotViewer$ImageProcessorTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

