/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ScreenRecorderOptions;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractDeviceAction;
import com.android.tools.idea.ddms.actions.CachedFeatures;
import com.android.tools.idea.ddms.actions.Features;
import com.android.tools.idea.ddms.actions.ScreenRecorderTask;
import com.android.tools.idea.ddms.screenrecord.ScreenRecorderOptionsDialog;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.utils.ILogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import icons.AndroidIcons;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScreenRecorderAction
extends AbstractDeviceAction {
    static final String REMOTE_PATH = "/sdcard/ddmsrec.mp4";
    static final String TITLE = "Screen Recorder";
    private static final String EMU_TMP_FILENAME = "tmp.webm";
    private final Features myFeatures;
    private final Project myProject;

    public ScreenRecorderAction(@NotNull Project project, @NotNull DeviceContext context) {
        if (project == null) {
            ScreenRecorderAction.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ScreenRecorderAction.$$$reportNull$$$0(1);
        }
        this(project, context, new CachedFeatures((Disposable)project));
    }

    ScreenRecorderAction(@NotNull Project project, @NotNull DeviceContext context, @NotNull Features features) {
        if (project == null) {
            ScreenRecorderAction.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ScreenRecorderAction.$$$reportNull$$$0(3);
        }
        if (features == null) {
            ScreenRecorderAction.$$$reportNull$$$0(4);
        }
        super(context, AndroidBundle.message("android.ddms.actions.screenrecord", new Object[0]), AndroidBundle.message("android.ddms.actions.screenrecord.description", new Object[0]), AndroidIcons.Ddms.ScreenRecorder);
        this.myFeatures = features;
        this.myProject = project;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ScreenRecorderAction.$$$reportNull$$$0(5);
        }
        Presentation presentation = event.getPresentation();
        if (!this.isEnabled()) {
            presentation.setEnabled(false);
            presentation.setText(AndroidBundle.message("android.ddms.actions.screenrecord", new Object[0]));
            return;
        }
        IDevice device = this.myDeviceContext.getSelectedDevice();
        if (this.myFeatures.watch(device)) {
            presentation.setEnabled(false);
            presentation.setText("Screen Record Is Unavailable for Wear OS");
            return;
        }
        presentation.setEnabled(this.myFeatures.screenRecord(device));
        presentation.setText(AndroidBundle.message("android.ddms.actions.screenrecord", new Object[0]));
    }

    @Override
    protected void performAction(@NotNull IDevice device) {
        ScreenRecorderOptionsDialog dialog;
        if (device == null) {
            ScreenRecorderAction.$$$reportNull$$$0(6);
        }
        if (!(dialog = new ScreenRecorderOptionsDialog(this.myProject)).showAndGet()) {
            return;
        }
        ScreenRecorderOptions options = dialog.getOptions();
        CountDownLatch latch = new CountDownLatch(1);
        CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
        boolean showTouchEnabled = ScreenRecorderAction.isShowTouchEnabled(device);
        AvdManager manager = ScreenRecorderAction.getVirtualDeviceManager();
        Path hostRecordingFileName = manager == null ? null : this.getTemporaryVideoPathForVirtualDevice(device, manager);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (options.showTouches != showTouchEnabled) {
                ScreenRecorderAction.setShowTouch(device, options.showTouches);
            }
            try {
                if (hostRecordingFileName != null) {
                    EmulatorConsole console = EmulatorConsole.getConsole((IDevice)device);
                    if (console != null) {
                        console.startEmulatorScreenRecording(ScreenRecorderAction.getEmulatorScreenRecorderOptions(hostRecordingFileName, options));
                    }
                } else {
                    device.startScreenRecorder(REMOTE_PATH, options, (IShellOutputReceiver)receiver);
                }
            }
            catch (Exception e) {
                ScreenRecorderAction.showError(this.myProject, "Unexpected error while launching screen recorder", e);
                latch.countDown();
            }
            finally {
                if (options.showTouches != showTouchEnabled) {
                    ScreenRecorderAction.setShowTouch(device, showTouchEnabled);
                }
            }
        });
        ScreenRecorderTask screenRecorderShellTask = new ScreenRecorderTask(this.myProject, device, latch, receiver, hostRecordingFileName);
        screenRecorderShellTask.setCancelText("Stop Recording");
        screenRecorderShellTask.queue();
    }

    @Nullable
    private static AvdManager getVirtualDeviceManager() {
        Logger logger = Logger.getInstance(ScreenRecorderAction.class);
        try {
            return AvdManager.getInstance((AndroidSdkHandler)AndroidSdks.getInstance().tryToChooseSdkHandler(), (ILogger)new LogWrapper(logger));
        }
        catch (AndroidLocation.AndroidLocationException exception) {
            logger.warn((Throwable)exception);
            return null;
        }
    }

    @Nullable
    Path getTemporaryVideoPathForVirtualDevice(@NotNull IDevice device, @NotNull AvdManager manager) {
        if (device == null) {
            ScreenRecorderAction.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            ScreenRecorderAction.$$$reportNull$$$0(8);
        }
        if (!this.myFeatures.screenRecord(device)) {
            return null;
        }
        AvdInfo virtualDevice = manager.getAvd(device.getAvdName(), true);
        if (virtualDevice == null) {
            return null;
        }
        return Paths.get(virtualDevice.getDataFolderPath(), EMU_TMP_FILENAME);
    }

    private static void setShowTouch(@NotNull IDevice device, boolean isEnabled) {
        if (device == null) {
            ScreenRecorderAction.$$$reportNull$$$0(9);
        }
        int value2 = isEnabled ? 1 : 0;
        try {
            device.executeShellCommand("settings put system show_touches " + value2, (IShellOutputReceiver)new NullOutputReceiver());
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            Logger.getInstance(ScreenRecorderAction.class).warn("Failed to set show taps to " + isEnabled, e);
        }
    }

    private static boolean isShowTouchEnabled(@NotNull IDevice device) {
        if (device == null) {
            ScreenRecorderAction.$$$reportNull$$$0(10);
        }
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        try {
            device.executeShellCommand("settings get system show_touches", (IShellOutputReceiver)receiver);
            String output = receiver.getOutput();
            return output.equals("1");
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            Logger.getInstance(ScreenRecorderAction.class).warn("Failed to retrieve setting", e);
            return false;
        }
    }

    static String getEmulatorScreenRecorderOptions(@NotNull Path filePath, @NotNull ScreenRecorderOptions options) {
        if (filePath == null) {
            ScreenRecorderAction.$$$reportNull$$$0(11);
        }
        if (options == null) {
            ScreenRecorderAction.$$$reportNull$$$0(12);
        }
        StringBuilder sb = new StringBuilder();
        if (options.width > 0 && options.height > 0) {
            sb.append("--size ");
            sb.append(options.width);
            sb.append('x');
            sb.append(options.height);
            sb.append(' ');
        }
        if (options.bitrateMbps > 0) {
            sb.append("--bit-rate ");
            sb.append(options.bitrateMbps * 1000000);
            sb.append(' ');
        }
        if (options.timeLimit > 0L) {
            sb.append("--time-limit ");
            long seconds = TimeUnit.SECONDS.convert(options.timeLimit, options.timeLimitUnits);
            if (seconds > 180L) {
                seconds = 180L;
            }
            sb.append(seconds);
            sb.append(' ');
        }
        sb.append(filePath);
        return sb.toString();
    }

    static void showError(@Nullable Project project, @NotNull String message, @Nullable Throwable throwable) {
        if (message == null) {
            ScreenRecorderAction.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            String msg = message;
            if (throwable != null) {
                msg = msg + (throwable.getLocalizedMessage() != null ? ": " + throwable.getLocalizedMessage() : "");
            }
            Messages.showErrorDialog((Project)project, (String)msg, (String)TITLE);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "features";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/ddms/actions/ScreenRecorderAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "performAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getTemporaryVideoPathForVirtualDevice";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setShowTouch";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isShowTouchEnabled";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getEmulatorScreenRecorderOptions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "showError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

