/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.actions.ScreenRecorderAction;
import com.intellij.CommonBundle;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.fileTypes.NativeFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PullRecordingTask
extends Task.Modal {
    private final String myLocalPath;
    private final IDevice myDevice;

    public PullRecordingTask(@Nullable Project project, @NotNull IDevice device, @NotNull String localFilePath) {
        if (device == null) {
            PullRecordingTask.$$$reportNull$$$0(0);
        }
        if (localFilePath == null) {
            PullRecordingTask.$$$reportNull$$$0(1);
        }
        super(project, "Screen Recorder", false);
        this.myDevice = device;
        this.myLocalPath = localFilePath;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            PullRecordingTask.$$$reportNull$$$0(2);
        }
        try {
            this.myDevice.pullFile("/sdcard/ddmsrec.mp4", this.myLocalPath);
            this.myDevice.removeRemotePackage("/sdcard/ddmsrec.mp4");
        }
        catch (Exception e) {
            ScreenRecorderAction.showError(this.myProject, "Unexpected error while copying video recording from device", e);
        }
    }

    private void openSavedFile() {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(this.myLocalPath);
        if (file != null) {
            NativeFileType.openAssociatedApplication((VirtualFile)file);
        }
    }

    public void onSuccess() {
        assert (this.myProject != null);
        String message = "Video Recording saved as " + this.myLocalPath;
        String cancel = CommonBundle.getOkButtonText();
        Icon icon = Messages.getInformationIcon();
        if (ShowFilePathAction.isSupported()) {
            String no = "Show in " + ShowFilePathAction.getFileManagerName();
            int exitCode = Messages.showYesNoCancelDialog((Project)this.myProject, (String)message, (String)"Screen Recorder", (String)"Open", (String)no, (String)cancel, (Icon)icon);
            if (exitCode == 0) {
                this.openSavedFile();
            } else if (exitCode == 1) {
                ShowFilePathAction.openFile((File)new File(this.myLocalPath));
            }
        } else if (Messages.showOkCancelDialog((Project)this.myProject, (String)message, (String)"Screen Recorder", (String)"Open File", (String)cancel, (Icon)icon) == 0) {
            this.openSavedFile();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFilePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/ddms/actions/PullRecordingTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

