/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingMode;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.LightBrClass;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDataBinding {
    @Nullable
    private LightBrClass myLightBrClass;
    @NotNull
    private DataBindingMode myDataBindingMode = DataBindingMode.NONE;
    private Module myModule;

    @NotNull
    public static ModuleDataBinding getInstance(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ModuleDataBinding.$$$reportNull$$$0(0);
        }
        ModuleDataBinding dataBinding = (ModuleDataBinding)ModuleServiceManager.getService((Module)facet.getModule(), ModuleDataBinding.class);
        assert (dataBinding != null);
        ModuleDataBinding moduleDataBinding = dataBinding;
        if (moduleDataBinding == null) {
            ModuleDataBinding.$$$reportNull$$$0(1);
        }
        return moduleDataBinding;
    }

    private ModuleDataBinding(Module module) {
        this.myModule = module;
        MessageBusConnection connection = module.getMessageBus().connect((Disposable)module);
        connection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

            public void facetConfigurationChanged(@NotNull Facet facet) {
                if (facet == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (facet.getModule() == ModuleDataBinding.this.myModule) {
                    ModuleDataBinding.this.syncWithConfiguration();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/databinding/ModuleDataBinding$1", "facetConfigurationChanged"));
            }
        });
        this.syncWithConfiguration();
    }

    private void syncWithConfiguration() {
        AndroidModel androidModel;
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        if (facet != null && (androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel()) != null) {
            this.setMode(androidModel.getDataBindingMode());
        }
    }

    public void setMode(@NotNull DataBindingMode mode) {
        if (mode == null) {
            ModuleDataBinding.$$$reportNull$$$0(2);
        }
        if (this.myDataBindingMode != mode) {
            this.myDataBindingMode = mode;
            DataBindingUtil.incrementModificationCount();
        }
    }

    @NotNull
    public DataBindingMode getDataBindingMode() {
        DataBindingMode dataBindingMode = this.myDataBindingMode;
        if (dataBindingMode == null) {
            ModuleDataBinding.$$$reportNull$$$0(3);
        }
        return dataBindingMode;
    }

    public boolean isEnabled() {
        return this.myDataBindingMode != DataBindingMode.NONE;
    }

    void setLightBrClass(@NotNull LightBrClass lightBrClass) {
        if (lightBrClass == null) {
            ModuleDataBinding.$$$reportNull$$$0(4);
        }
        this.myLightBrClass = lightBrClass;
    }

    @Nullable
    LightBrClass getLightBrClass() {
        return this.myLightBrClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/databinding/ModuleDataBinding";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lightBrClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/databinding/ModuleDataBinding";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataBindingMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setMode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setLightBrClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

